// art2tgaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "art2tga.h"
#include "art2tgaDlg.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
// Maximum number of tiles (taken from Ken's "editart.c")
#define MAX_NB_TILES 9216

// Size of the color palette (256 colors, 3 components for each color)
#define PALETTE_SIZE (256 * 3)

// Current version of this software
#define VERSION "0.0"



/* ------------- */
/* --- Types --- */
/* ------------- */

// Definition of some basic types
// Useful, because sometime we need to be sure of the size of an integer type
// May need to be "#ifdef"ed to fit a particular OS on a particular processor
typedef   signed char  int8;
typedef   signed short int16;
typedef   signed int   int32;
typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned int   uint32;

// Description of a tile
typedef struct {
   uint16 XSize;     // Tile's width
   uint16 YSize;     // Tile's height
   uint32 AnimData;  // Flags and values for animating the picture
   uint32 Offset;    // Offset in the ART file
} Tile_t;


/* ------------------------ */
/* --- Global variables --- */
/* ------------------------ */


// List of tiles in the ART file
uint32 NbTiles = 0;
uint32 TilesStartNum;             // Number of the first tile
Tile_t TilesList [MAX_NB_TILES];

// Color palette (in TGA format: set of {Blue, Green, Red})
uint8 Palette [PALETTE_SIZE];

// Animation types
const char* AnimationTypes [4] = {"none", "oscillation", "forward", "backward"};
// ART file
FILE* ArtFile = NULL;


/* ----------------- */
/* --- Functions --- */
/* ----------------- */

/* ------ Prototypes ------ */

// Dump animation data into "animdata.ini"
static bool DumpAnimationData (void);

// Extract pictures from the ART file
static bool ExtractPictures (void);

// Get a uint16 from a little-endian ordered buffer
static uint16 GetLittleEndianUInt16 (const uint8* Buffer);

// Get a uint32 from a little-endian ordered buffer
static uint32 GetLittleEndianUInt32 (const uint8* Buffer);

// Create the pictures list from the ART header
static bool GetPicturesList (void);

// Load the color palette from the PALETTE.DAT file
static bool LoadPalette (void);

// Set a uint16 into a little-endian ordered buffer
static void SetLittleEndianUInt16 (uint16 Integer, uint8* Buffer);

// Extract the picture at TilesList[TileInd] and save it as PictureName
//static bool SpawnTGA (uint32 TileInd, const char* PictureName);

int oldmain (CString ); 

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CArt2tgaDlg dialog

CArt2tgaDlg::CArt2tgaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CArt2tgaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CArt2tgaDlg)
//	m_ctlList.AddString( _T(""); // timmy
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CArt2tgaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CArt2tgaDlg)
	DDX_Control(pDX, IDC_LIST, m_ctlList);
//	DDX_Text(pDX, IDC_LOG, m_LogText); // timmy
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CArt2tgaDlg, CDialog)
	//{{AFX_MSG_MAP(CArt2tgaDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDEXIT, OnExit)
	ON_BN_CLICKED(IDOPEN, OnOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CArt2tgaDlg message handlers

BOOL CArt2tgaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	dirFlag=0;
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CArt2tgaDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CArt2tgaDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CArt2tgaDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CArt2tgaDlg::OnExit() 
{
OnOK();	
}

void CArt2tgaDlg::OnOpen() 
{
CFileDialog m_ldFile(TRUE);

 // Show the File open dialog and capture the result
if (dirFlag==0)
{ 
	m_ldFile.m_ofn.lpstrInitialDir="C:"; // must be before the if!!!!
	dirFlag=1;
}
m_ldFile.m_ofn.lpstrFilter= //what a lot of code just to filter files!
TEXT("Art Files (*.Art)\0*.Art\0Cryptic Passage Art Files (*.Ar_)\0*.Ar_\0All Files (*.*)\0*.*\0");
 if (m_ldFile.DoModal() == IDOK)
 {
 // Get the filename selected
 m_sResults = m_ldFile.GetFileName();
 // should nuke all the stuff in the list box. 
 m_ctlList.ResetContent(); 
 // call mathieus code, and pass the file name through.
  oldmain (m_sResults);  
 // Update the dialog
  UpdateData(FALSE);	
 } // end if
} // end OnOpen()



/* ------ Implementations ------ */

/*
====================
DumpAnimationData

Dump animation data into "animdata.ini"
====================
*/
bool CArt2tgaDlg::DumpAnimationData (void)
{
   // Variables
   FILE* AnimDataFile;
   uint32 Ind;

   // Create the INI file
   AnimDataFile = fopen ("animdata.ini", "wt");
   if (AnimDataFile == NULL)
   {
      m_ctlList.AddString("Error: can't create file \"animdata.ini\"");
      UpdateData(FALSE);
	  return false;
   }

   m_ctlList.AddString("Creating \"animdata.ini\"...");
   UpdateData(FALSE);
   fflush (stdout);

   // Print some infos at the beginning of the INI file
   fprintf (AnimDataFile,
            "; This file contains animation data from \"%s\"\n"
            "; Extracted by Art2Tga version " VERSION "\n"
            "\n",
            ArtFileName
           );

   // For each tile...
   for (Ind = 0; Ind < NbTiles; Ind++)
      // if it has animation data...
      if (TilesList[Ind].AnimData != 0)
      {
         // if the tile has animation data, print them first
         // Note: "AnimationType" should be the only parameter to check, but Blood seems to
         //       put informations in the other animation flags even when the image
         //       is not declared as an animation.
         if (((TilesList[Ind].AnimData >>  0) & 0x3F) != 0 ||
             ((TilesList[Ind].AnimData >>  6) & 0x03) != 0 ||
             ((TilesList[Ind].AnimData >> 24) & 0x0F) != 0
            )
         {
            fprintf (AnimDataFile,
                     "[tile%04u.tga -> tile%04u.tga]\n",
                     Ind + TilesStartNum, Ind + TilesStartNum + (TilesList[Ind].AnimData & 0x3F)
                    );
            fprintf (AnimDataFile,
                     "   AnimationType=%s\n",
                     AnimationTypes[(TilesList[Ind].AnimData >> 6) & 0x03]
                    );
            fprintf (AnimDataFile,
                     "   AnimationSpeed=%u\n",
                     (TilesList[Ind].AnimData >> 24) & 0x0F
                    );

            fprintf (AnimDataFile, "\n");
         }

         fprintf (AnimDataFile, "[tile%04u.tga]\n", Ind + TilesStartNum);

         fprintf (AnimDataFile,
                  "   XCenterOffset=%d\n",
                  (int8)((TilesList[Ind].AnimData >>  8) & 0xFF)
                 );
         fprintf (AnimDataFile,
                  "   YCenterOffset=%d\n",
                  (int8)((TilesList[Ind].AnimData >> 16) & 0xFF)
                 );
         fprintf (AnimDataFile,
                  "   OtherFlags=%u\n",
                  TilesList[Ind].AnimData >> 28  // those flags is supposed to be useless in the ART format, but Blood seems to use them
                 );

         fprintf (AnimDataFile, "\n");
      }

   fclose (AnimDataFile);
   m_ctlList.AddString( "Done dumping animation data");
   UpdateData(FALSE);
   return true;
}


/*
====================
ExtractPictures

Extract pictures from the ART file
====================
*/
bool CArt2tgaDlg::ExtractPictures (void)
{
   // Variables
   uint32 Ind;
   char ImageFileName [13];

   // A little counter...
   m_ctlList.AddString("Extracting pictures");
   UpdateData(FALSE);
   fflush (stdout);

   for (Ind = 0; Ind < NbTiles; Ind++)
   {
      // Updating counter
      //m_ctlList.AddString("%4u", Ind);
      UpdateData(FALSE);
	  fflush (stdout);
		
      sprintf (ImageFileName, "tile%04u.tga", Ind + TilesStartNum);
      SpawnTGA (Ind, ImageFileName);
   }

   m_ctlList.AddString("Done extracting pictures");
   UpdateData(FALSE);
   return true;
}


/*
====================
GetLittleEndianUInt16

Get a uint16 from a little-endian ordered buffer
====================
*/
static uint16 GetLittleEndianUInt16 (const uint8* Buffer)
{
   return (uint16)(Buffer[0] | (Buffer[1] << 8));
}


/*
====================
GetLittleEndianUInt32

Get a uint32 from a little-endian ordered buffer
====================
*/
static uint32 GetLittleEndianUInt32 (const uint8* Buffer)
{
   return Buffer[0] | (Buffer[1] << 8) | (Buffer[2] << 16) | (Buffer[3] << 24);
}


/*
====================
GetPicturesList

Create the pictures list from the ART header
====================
*/
bool CArt2tgaDlg::GetPicturesList (void)
{
   // Variables
   uint8 Buffer [MAX_NB_TILES * 4];
   uint32 Version, TilesEndNum;
   uint32 Ind;
   size_t CrtOffset;

   // Read the first part of the header
   if (fread (Buffer, 1, 16, ArtFile) != 16)
   {
      m_ctlList.AddString("Error: invalid ART file: not enough header data");
      UpdateData(FALSE);
	  return false;
   }
   Version       = GetLittleEndianUInt32 (&Buffer[ 0]);
   NbTiles       = GetLittleEndianUInt32 (&Buffer[ 4]); // useless; overwritten below
   TilesStartNum = GetLittleEndianUInt32 (&Buffer[ 8]);
   TilesEndNum   = GetLittleEndianUInt32 (&Buffer[12]);

   // Compute the real number of tiles contained in the file
   NbTiles = TilesEndNum - TilesStartNum + 1;

   // Check the version number
   if (Version != 1)
   {
      m_ctlList.AddString("Error: invalid ART file: invalid version number (%u)"/*Version*/);
      UpdateData(FALSE);
	  return false;
   }
		  
   //m_ctlList.AddString(NbTiles);// timmy	
   m_ctlList.AddString("Tiles declared in the ART header" /*NbTiles*/);
	UpdateData(FALSE);
   	// Extract sizes
   fread (Buffer, 1, NbTiles * 2, ArtFile);
   for (Ind = 0; Ind < NbTiles; Ind++)
      TilesList[Ind].XSize = GetLittleEndianUInt16 (&Buffer[Ind * 2]);
   fread (Buffer, 1, NbTiles * 2, ArtFile);
   for (Ind = 0; Ind < NbTiles; Ind++)
      TilesList[Ind].YSize = GetLittleEndianUInt16 (&Buffer[Ind * 2]);

   // Extract animation data
   fread (Buffer, 1, NbTiles * 4, ArtFile);
   for (Ind = 0; Ind < NbTiles; Ind++)
      TilesList[Ind].AnimData = GetLittleEndianUInt32 (&Buffer[Ind * 4]);

   // Compute offsets
   CrtOffset = 16 + NbTiles * (2 + 2 + 4);
   for (Ind = 0; Ind < NbTiles; Ind++)
   {
      TilesList[Ind].Offset = CrtOffset;
      CrtOffset += TilesList[Ind].XSize * TilesList[Ind].YSize;
   }

   return true;
}


/*
====================
LoadPalette

Load the color palette from the PALETTE.DAT file
====================
*/
bool CArt2tgaDlg::LoadPalette (void)
{
   // Variables
   FILE* PaletteFile;
   uint32 Ind;
   uint8 Color;

   // Open the file
   PaletteFile = fopen ("palette.dat", "rb");
   if (PaletteFile == NULL)
   {
      m_ctlList.AddString("Error: can't open \"palette.dat\"");
      UpdateData(FALSE);
	  return false;
   }

   // Read the palette
   if (fread (Palette, 1, PALETTE_SIZE, PaletteFile) != PALETTE_SIZE)
   {
      m_ctlList.AddString("Error: can't read the whole palette from \"palette.dat\" file");
      UpdateData(FALSE);
	  fclose (PaletteFile);
      return false;
   }

   // Convert it to TGA palette format
   for (Ind = 0; Ind < PALETTE_SIZE; Ind += 3)
   {
      Color = Palette[Ind];
      Palette[Ind] = (uint8)(Palette[Ind + 2] << 2);
      Palette[Ind + 1] <<= 2;
      Palette[Ind + 2] = (uint8)(Color << 2);
   }

   m_ctlList.AddString( "Palette successfully loaded");
   UpdateData(FALSE);
   fclose (PaletteFile);
   return true;
}


/*
====================
main

Main procedure
====================
*/

 int CArt2tgaDlg::oldmain (CString ArtFileName)
 {
  	 
	 // Load the color palette
   if (! LoadPalette ())
      return EXIT_FAILURE;

   // Open the ART file
   ArtFile = fopen (ArtFileName, "rb");
   if (ArtFile == NULL)
   {
      m_ctlList.AddString( "Error: can't open file " + ArtFileName);
	   //MessageBox (NULL,"Error: can't open file \"%s\"", ""/*ArtFileName*/,MB_OK);
      return EXIT_FAILURE;
   }

   // Extract all the pictures and create the INI file
   if (! GetPicturesList   () ||  // Read the ART header
       ! ExtractPictures   () ||  // Extract pictures from the ART file
       ! DumpAnimationData ()  )  // Dump animation data into "animdata.ini"
   {
      fclose (ArtFile);
      return EXIT_FAILURE;
   }

   fclose (ArtFile);
   return EXIT_SUCCESS;  
 }


/*
====================
SetLittleEndianUInt16

Set a uint16 into a little-endian ordered buffer
====================
*/
static void SetLittleEndianUInt16 (uint16 Integer, uint8* Buffer)
{
   Buffer[0] = (uint8)(Integer & 255);
   Buffer[1] = (uint8)(Integer >> 8);
}


/*
====================
SpawnTGA

Extract the picture number "PictureInd" and save it as PictureName
====================
*/
bool CArt2tgaDlg::SpawnTGA (uint32 TileInd, const char* PictureName)
{
	// Variables
   FILE* ImageFile;
   int32 XInd, YInd;
   uint8 TgaHeader [] =
   {
      0x00,                          // Number of Characters in Identification Field (0)
      0x01,                          // Color Map Type (true)
      0x01,                          // Image Type Code (1 -> uncompressed color mapped)
      0x00, 0x00, 0x00, 0x01, 0x18,  // Color Map Specification (from index 0; 256 colors; 24 bits each)
      0x00, 0x00, 0x00, 0x00,        // Origin of Image (0, 0)
      0x00, 0x00, 0x00, 0x00,        // Size of Image (TO BE FILLED. Bytes 12-13 and 14-15. little-endian)
      0x08,                          // Pixel size (8 bits)
      0x00                           // Flags (image described from bottom left; no alpha bits)
   };
   uint8 *ImageBuffer;
   const uint32 PictureSize = TilesList[TileInd].XSize * TilesList[TileInd].YSize;

   // If the picture is empty, we skip it
   if (PictureSize == 0)
      return true;

   // Load the picture in a buffer
   fseek (ArtFile, TilesList[TileInd].Offset, SEEK_SET);
   
    ImageBuffer =  (uint8*)malloc(PictureSize); // had to typecast !
	

   if (ImageBuffer == NULL)
   {
      m_ctlList.AddString( "Error: can't allocate enough memory to load \"%s\"");// + PictureName;
      return false;
   }
   if (fread (ImageBuffer, 1, PictureSize, ArtFile) != PictureSize)
   {
      m_ctlList.AddString( "Error: can't read enough data in the ART file to load \"%s\"");
	  //+ PictureName;
      free (ImageBuffer);
      return false;
   }

   // Create the file
   ImageFile = fopen (PictureName, "wb");
   if (ImageFile == NULL)
   {
      m_ctlList.AddString( "Error: can't create file \"%s\"");//, "" /*PictureName*/);
      UpdateData(FALSE);
	  free (ImageBuffer);
      return false;
   }

   // Write the TGA header (including the palette)
   SetLittleEndianUInt16 (TilesList[TileInd].XSize, &TgaHeader[12]);
   SetLittleEndianUInt16 (TilesList[TileInd].YSize, &TgaHeader[14]);
   fwrite (TgaHeader, 1, sizeof (TgaHeader), ImageFile);
   fwrite (Palette, 1, PALETTE_SIZE, ImageFile);

   // Write the picture
   for (YInd = TilesList[TileInd].YSize - 1; YInd >= 0; YInd--)  // save the lines from bottom
      for (XInd = 0; XInd < TilesList[TileInd].XSize; XInd++)
         // ART file store pictures by columns, not by lines
         fwrite (&ImageBuffer[YInd + XInd * TilesList[TileInd].YSize], 1, 1, ImageFile);

   free (ImageBuffer);
   fclose (ImageFile);
   return true;
}
