// QUAKEMAPPLUGIN.CPP
// Copyright  2000 Joe Riedel, Nick Randal.
// Author: Joe Riedel.
#include "stdafx.h"
#include "../TreadAPI.h"
#include "QuakeMapPlugin.h"
#include "QuakeMapFile.h"

T3DPLUGINAPI CTreadPlugin* T3D_CreatePluginInstance()
{ return new CQuakeMapPlugin(); }

CQuakeMapPlugin::CQuakeMapPlugin()
{
}

CQuakeMapPlugin::~CQuakeMapPlugin()
{
}

//
// GetAPIVersion(): called by Tread to see what version of the API
// the plugin has been compiled with. Should always return: TP_API_VERSION.
//
int CQuakeMapPlugin::GetAPIVersion()
{ return TP_API_VERSION; }

//
// Called to do one-time initialization when the plugin is started.
//
int CQuakeMapPlugin::InitializePlugin()
{
	// Here we bind the PFF_MAPREADER/PFF_MAPWRITER routines to
	// tell Tread we support this functionality.
	GetPluginAPI()->BindFunction(this, PFF_MAPREADER|PFF_MAPWRITER);

	return TPF_OK;
}

//
// Called to shutdown the plugin and perform any cleanup necessary before
// the system exits.
//
int CQuakeMapPlugin::ShutdownPlugin()
{
	return TPF_OK;
}

//
// Called to get the name of the plugin. Used internally for invocation. This
// should be unique.
//
CString CQuakeMapPlugin::GetPluginName()
{ return "QuakeMapReaderExample"; }

//
// Called when the user selects the plugin from a menu item. pDocument
// is the current map. For more info on the CTread3DDoc class, look at the
// declaration of the class.
//
int CQuakeMapPlugin::InvokePlugin(CTread3DDoc* pDocument, int nMenuID)
{
	return TPF_OK;
}

//
// The system calls these to see if the plugin can read/write the file requested.
// You must bind the PFF_MAPREADER/PFF_MAPWRITER functions.
//
CBaseTreadMapFile* CQuakeMapPlugin::GetMapReader(CString sTag, int nMagic, CTread3DDoc* pDocument)
{
	// Tread typically just uses the def_gamefiletype string to figure out the format of files,
	// since the text .map files are impossible to determine easily.
	CString sType = GetGameAPI()->GetCurrentGame()->GetMapFileTypeString();

	if(sType == "QUAKE_MAP")
		return new CQuakeMapFile();
	return NULL;
}

CBaseTreadMapFile* CQuakeMapPlugin::GetMapWriter(TREAD2XHEADERINFO* pHeader, CTread3DDoc* pDocument)
{
	// We do the same thing here as we do in the MapReader routine.
	CString sType = GetGameAPI()->GetCurrentGame()->GetMapFileTypeString();

	if(sType == "QUAKE_MAP")
		return new CQuakeMapFile();
	return NULL;
}