// QUAKEMAPPLUGIN.H
// Copyright  2000 Joe Riedel, Nick Randal.
// Author: Joe Riedel.

/*
//////////////////////////////////////////////////////////////////////
// FORWARD:															//
//																	//
// This plugin will cover the use of Treads fully extendable		//
// mapAPI: the API that reads writes map files Tread loads. Tread	//
// find suitable readers/writers by asking the current set which	//
// ones can read/write the particular map. Typically this requires	//
// a format check based on file extension or even some bytes of the //
// file. When a plugin is being queryed it is safe to assume that	//
// the current game type has already been set by asking the user.	//
//																	//
// The details of actually reading/writting a map are discussed in	//
// QuakeMapFile.h and QuakeMapFile.cpp. This source code was		//
// released straight out of the code Tread uses to read/write Quake	//
// maps.															//
//																	//
// This plugin does not discuss how to setup the basics of a		//
// plugin. For information regarding that, please consult the		//
// example LeakTrace plugin.										//
//////////////////////////////////////////////////////////////////////
*/

#ifndef QUAKEMAPPLUGIN_H
#define QUAKEMAPPLUGIN_H

#include "../TreadAPI.h"

// Defines a plugin object.
class CQuakeMapPlugin : public CTreadPlugin
{
public:

	CQuakeMapPlugin();
	virtual ~CQuakeMapPlugin();

	//
	// GetAPIVersion(): called by Tread to see what version of the API
	// the plugin has been compiled with. Should always return: TP_API_VERSION.
	//
	virtual int GetAPIVersion();

	//
	// Called to do one-time initialization when the plugin is started.
	//
	virtual int InitializePlugin();

	//
	// Called to shutdown the plugin and perform any cleanup necessary before
	// the system exits.
	//
	virtual int ShutdownPlugin();

	//
	// Called to get the name of the plugin. Used internally for invocation. This
	// should be unique.
	//
	virtual CString GetPluginName();

	//
	// Called when the user selects the plugin from a menu item. pDocument
	// is the current map. For more info on the CTread3DDoc class, look at the
	// declaration of the class.
	//
	virtual int InvokePlugin(CTread3DDoc* pDocument, int nMenuID);

	//
	// The system calls these to see if the plugin can read/write the file requested.
	// You must bind the PFF_MAPREADER/PFF_MAPWRITER functions.
	//
	virtual CBaseTreadMapFile* GetMapReader(CString sTag, int nMagic, CTread3DDoc* pDocument);
	virtual CBaseTreadMapFile* GetMapWriter(TREAD2XHEADERINFO* pHeader, CTread3DDoc* pDocument);

};

#endif