/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QPROCESS_WINDOW_H
#define QPROCESS_WINDOW_H

class QProcessWindow: public wxRichTextCtrl
{
public:
	QProcessWindow(wxWindow *parent);
	~QProcessWindow();

	void ClearWindow(void);
	void OutputText(const char *text);
	void GetViewPos();
	void SetViewPos();

	// Process running
	typedef void (*FinishCallback) ();
	bool IsProcessRunning();
	void ExecProcess(const wxString &commandLine, const wxString &workDir,
			FinishCallback callback);
	void TerminateProcess();

	void OnIdle(wxIdleEvent &event);
	void OnFinishProcess(wxProcessEvent &event);
	DECLARE_EVENT_TABLE();
private:
	long viewLinePos, curStart, curEnd;

	wxProcess *currentProcess;
	FinishCallback currentCallback;
};

#endif //QPROCESS_WINDOW_H
