/*
Copyright (C) 2010-2011 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "LCommon.h"
#include "QQuadFrame.h"
#include "QMainFrame.h"
#include "QooleDoc.h"
#include "QView.h"
#include "QViewPanel.h"

BEGIN_EVENT_TABLE(QQuadFrame, QChildFrame)
	EVT_ACTIVATE(QQuadFrame::OnActivate)
	EVT_CLOSE(QQuadFrame::OnCloseWindow)
END_EVENT_TABLE()

QQuadFrame::QQuadFrame(QMainFrame *parent, QooleDoc *doc)
	: QChildFrame(parent->GetViewsNotebook(), wxID_ANY, doc->GetTitle())
{
	const wxChar *viewTitle[] = {
			_("Top"), _("3D View"), _("Back"), _("Side")
	};

	// Store the document.
	document = doc;
	doc->SetChildFrame(this);

	// Create the views.
	for(int i = 0; i < 4; i++)
	{
		views[i] = new QView();
		views[i]->SetDocument(doc);
		views[i]->SetParentFrame(this);
		if(!views[i]->OnCreate(doc, 0))
			LFatal("Failed to create a view.");
	}

	// Now create the quad views layout.

	// Create a vertical box sizer.
	wxBoxSizer *vertSizer = new wxBoxSizer(wxVERTICAL);

	// Create the top sizer.
	wxBoxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
	vertSizer->Add(topSizer, 1, wxEXPAND);

	// Create the bottom sizer.
	wxBoxSizer *bottomSizer = new wxBoxSizer(wxHORIZONTAL);
	vertSizer->Add(bottomSizer, 1, wxEXPAND);

	// Add the views to the sizers.
	topSizer->Add(views[VID_TOP_LEFT]->GetFrame(), 1, wxEXPAND | wxALL, 2);
	topSizer->Add(views[VID_TOP_RIGHT]->GetFrame(), 1, wxEXPAND | wxALL, 2);
	bottomSizer->Add(views[VID_BOTTOM_LEFT]->GetFrame(), 1, wxEXPAND | wxALL, 2);
	bottomSizer->Add(views[VID_BOTTOM_RIGHT]->GetFrame(), 1, wxEXPAND | wxALL, 2);

	// Set the sizer.
	SetAutoLayout(true);
	SetSizer(vertSizer);
}

QQuadFrame::~QQuadFrame()
{
}

QView *QQuadFrame::GetView(ViewID id)
{
	ASSERT(id >= 0 && id <= 4);
	return views[id];
}

void QQuadFrame::OnActivate(wxActivateEvent& event)
{
	if(event.GetActive())
	{
		// Set the desktop document.
		GetMainFrame()->SetDeskTopDocument(document);

		// Activate the first view.
		views[0]->Activate(true);

		// Send an update view event.
		document->UpdateAllViews();
	}
}

void QQuadFrame::OnCloseWindow(wxCloseEvent& event)
{
	QView *child = NULL;
	for(int i = 0; i < 4; i++)
	{
		child = views[i];
		if(child)
			break;
	}

	if(child)
	{
		bool ans = event.CanVeto()
		           ? child->Close(false) // false means don't delete associated window
		           : false; // Don't delete.

		if (ans)
		{
			document->SetChildFrame(NULL);

			for(int i = 0; i < 4; i++)
			{
				views[i]->Activate(false);
				views[i]->Close(false);
				views[i]->GetFrame()->Destroy();
				delete views[i];
				views[i] = NULL;
			}
			//this->Destroy();
		}
		else
			event.Veto();
	}
	else
		event.Veto();
}
