/*
Copyright 1998, 1998 Alexander Malmberg

Distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "things.h"

#include "d2q.h"
#include "error.h"
#include "level.h"

typedef struct
{
   int type;
   int height;
   char *classname;
} ttype_t;

ttype_t *ttypes;
int ntt;

/*ttype_t ttypes[]=
{
 {    1,24,"info_player_start"},
 {    2,24,"info_player_coop"},
 {    3,24,"info_player_coop"},
 {    4,24,"info_player_coop"},

 {   11,24,"info_player_deathmatch"},
 {   14,24,"misc_teleporter_dest"},

 { 2005,16,"doom_chainsaw"},
 { 2001,16,"weapon_shotgun"},
 {   82,16,"weapon_supershotgun"},
 { 2002,16,"weapon_chaingun"},
 { 2003,16,"weapon_rocketlauncher"},
 { 2004,16,"weapon_hyperblaster"},
 { 2006,16,"weapon_bfg"},

 { 2007,16,"ammo_bullets"},
 { 2048,16,"ammo_bullets"},
 { 2049,16,"ammo_shells"},
 { 2008,16,"ammo_shells"},
 { 2010,16,"ammo_rockets"},
 { 2046,16,"ammo_rockets"},
 {   17,16,"ammo_cells"},
 { 2047,16,"ammo_cells"},

 {    8,16,"item_pack"},

 { 2011,16,"item_health"},          // Stimpak
 { 2012,16,"item_health_large"},    // Medikit
 { 2014,16,"item_health_small"},    // Health Potion +1% health
 { 2015,16,"item_armor_shard"},     // Spirit Armor +1% armor
 { 2018,16,"item_armor_combat"},    // Green armor 100%
 { 2019,16,"item_armor_body"},      // Blue armor 200%
 {   83,16,"doom_megasphere"},      // Megasphere: 200% health, 200% armor
 { 2013,16,"item_health_mega"},     // Soulsphere, Supercharge, +100% health
 { 2022,16,"item_invulnerability"}, // Invulnerability
 { 2023,16,"item_adrenaline"},      // Berserk Strength and 100% health
 { 2024,16,"doom_visibility"},      // Invisibility
 { 2025,16,"item_enviro"},          // Radiation suit
 { 2026,16,"doom_compmap"},         // Computer map
 { 2045,16,"doom_light_goggles"},   // Lite Amplification goggles

 { 2035, 0,"misc_explobox"},

 { 3004,24,"monster_soldier_light"},
 {    9,24,"monster_soldier"},
 { 3001,24,"doom_imp"},

 {   10, 0,"doom_player_gib"},
 {   12, 0,"doom_player_gib"},
 {   15, 0,"doom_player_dead"},
 {   24, 0,"doom_blood"},

 {   35, 0,"doom_candelabra"},
 {   48, 0,"doom_pillar_techno"},
 { 2028, 0,"doom_lamp_floor"},

 {    0,NULL}
};*/

void LoadThings(void)
{
   FILE *f;
   char v1[128],v2[128],v3[128];
   char line[1024];
   char *c,*d;

   ttype_t *tt;

   ntt=0;
   ttypes=NULL;

   f=fopen("d2q.ent","rt");

   if (!f)
   {
      printf("Warning: Couldn't open 'd2q.ent'!\n");
      return;
   }

   while (!feof(f))
   {
      if (!fgets(line,sizeof(line),f))
         break;

      if (strstr(line,"//"))
         *strstr(line,"//")=0;

      while ((line[0]<=32) && line[0])
         strcpy(line,&line[1]);

      while ((line[strlen(line)-1]<=32) && line[0])
         line[strlen(line)-1]=0;

      if (!line[0])
         continue;

      c=line;
      d=v1;
      while (*c>32)
         *d++=*c++;
      *d=0;

      while ((*c<=32) && *c)
         c++;

      d=v2;
      while (*c>32)
         *d++=*c++;
      *d=0;

      while ((*c<=32) && *c)
         c++;

      d=v3;
      while (*c>32)
         *d++=*c++;
      *d=0;

      ttypes=realloc(ttypes,sizeof(ttype_t)*(ntt+1));
      if (!ttypes)
         Error("Out of memory!");
      tt=&ttypes[ntt];
      ntt++;
      tt->type=atoi(v1);
      tt->height=atoi(v2);
      tt->classname=strdup(v3);
      if (!tt->classname)
         Error("Out of memory!");
   }

   ttypes=realloc(ttypes,sizeof(ttype_t)*ntt);
   if (!ttypes)
      Error("Out of memory!");
   tt=&ttypes[ntt];
   ntt++;
   memset(tt,0,sizeof(ttype_t));

   fclose(f);
}

static char found[32768];

void WriteKey(char *key,char *format, ...)
{
   va_list args;

   fprintf(map,"\"%s\" \"",key);
   va_start(args,format);
   vfprintf(map,format,args);
   va_end(args);
   fprintf(map,"\"\n");
}

void AddThings(void)
{
   int i;
   thing_t *t;
   ttype_t *tt;
   int spawnflags;
   sector_t *sec;
   float z;

   LoadThings();

   printf("AddThings(): %i things\n",n_things);
   memset(found,0,sizeof(found));

   t=things;
   for (i=0;i<n_things;i++,t++)
   {
      for (tt=ttypes;tt->classname;tt++)
      {
         if (tt->type==t->type)
            break;
      }

      entities++;
      fprintf(map,"{\n");

      sec=InSector(t->p[0],t->p[1]);
      z=sec->fh;

      if (tt->classname)
      {
         WriteKey("classname","%s",tt->classname);
         z+=tt->height;
      }
      else
      {
         WriteKey("classname","doom_%i",t->type);
         if (!found[t->type])
         {
            printf("Thing unknown: %i\n",t->type);
            found[t->type]++;
         }
      }

      WriteKey("origin","%i %i %g",t->p[0],t->p[1],z);
      if (t->angle)
         WriteKey("angle","%i",t->angle);

      spawnflags=0;
      if (!(t->flags&1))
         spawnflags|=256;

      if (!(t->flags&2))
         spawnflags|=512;

      if (!(t->flags&4))
         spawnflags|=1024;

      if (t->flags&16)
         spawnflags|=1024+512+256;

      if (spawnflags)
         WriteKey("spawnflags","%i",spawnflags);

      fprintf(map,"}\n");
   }
}

