/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.registry;

import com.technofovea.hl2parse.registry.BlobDword;
import com.technofovea.hl2parse.registry.BlobFolder;
import com.technofovea.hl2parse.registry.BlobParseFailure;
import com.technofovea.hl2parse.registry.BlobRaw;
import com.technofovea.hl2parse.registry.BlobText;
import com.technofovea.hl2parse.registry.BlobValue;
import com.technofovea.hl2parse.registry.CellCollection;
import com.technofovea.hl2parse.registry.CellItem;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegParser {
    private static final Logger logger = LoggerFactory.getLogger(RegParser.class);
    static final int HEADER_VAL = 20481;
    static final int HEADER_COMPRESSED = 17153;
    static final Charset charset = Charset.forName("UTF-8");

    public static ByteBuffer readSlice(ByteBuffer source) {
        return RegParser.readSlice(source, source.remaining());
    }

    public static ByteBuffer readSlice(ByteBuffer source, int length) {
        int originalLimit = source.limit();
        source.limit(source.position() + length);
        ByteBuffer sub = source.slice();
        source.position(source.limit());
        source.limit(originalLimit);
        sub.order(ByteOrder.LITTLE_ENDIAN);
        return sub;
    }

    public static String getText(ByteBuffer source) {
        int pos = source.position();
        int end = source.limit();
        while (source.remaining() > 0) {
            if (source.get() != 0) continue;
            end = source.position() - 1;
            break;
        }
        source.position(pos);
        source.limit(end);
        return charset.decode(source).toString();
    }

    public static CellCollection parseCell(ByteBuffer buf) throws BlobParseFailure {
        try {
            CellCollection ret = new CellCollection();
            ByteBuffer mybuf = RegParser.readSlice(buf);
            short magic = mybuf.getShort();
            if (magic != 20481) {
                if (magic == 17153) {
                    throw new BlobParseFailure("The blob given appears to be compressed, but no compressed blob was expected.");
                }
                throw new BlobParseFailure("Expected magic value " + Integer.toHexString(20481) + " but got " + Integer.toHexString(magic));
            }
            int childrenLen = mybuf.getInt() - 10;
            int nullPadded = mybuf.getInt();
            if (magic != 20481) {
                throw new BlobParseFailure("Expected magic value " + Integer.toHexString(20481) + " but got " + Integer.toHexString(magic));
            }
            if (mybuf.remaining() < childrenLen + nullPadded) {
                throw new BlobParseFailure("Content length (" + childrenLen + " and null padding (" + nullPadded + ") are bigger than the total remaining bytes (" + mybuf.remaining() + ")");
            }
            mybuf.limit(mybuf.position() + childrenLen + nullPadded);
            while (mybuf.remaining() > nullPadded) {
                short descriptorLen = mybuf.getShort();
                int payloadLen = mybuf.getInt();
                assert (payloadLen + descriptorLen <= mybuf.remaining());
                ByteBuffer desc = RegParser.readSlice(mybuf, descriptorLen);
                ByteBuffer payload = RegParser.readSlice(mybuf, payloadLen);
                ret.items.add(new CellItem(desc, payload));
            }
            mybuf.position(mybuf.position() + nullPadded);
            ret.underflow = mybuf.remaining();
            return ret;
        }
        catch (BufferUnderflowException bue) {
            throw new BlobParseFailure("A buffer-underflow occurred.", bue);
        }
    }

    public static ByteBuffer decompress(ByteBuffer originalBuffer) throws BlobParseFailure {
        logger.debug("Inflating a compressed binary section, initial length (including header) is {}", (Object)originalBuffer.remaining());
        int headerSkip = 2;
        Inflater inflater = new Inflater(true);
        try {
            ByteBuffer mybuf = RegParser.readSlice(originalBuffer);
            short magic = mybuf.getShort();
            if (magic != 17153) {
                if (magic == 20481) {
                    throw new BlobParseFailure("The blob given appears to be uncompressed,but a compressed blob was expected.");
                }
                throw new BlobParseFailure("Expected magic value " + Integer.toHexString(17153) + " but got " + Integer.toHexString(magic));
            }
            int wholeLen = mybuf.getInt();
            int compressedLen = wholeLen - 20;
            int x1 = mybuf.getInt();
            int decompressedLen = mybuf.getInt();
            int x2 = mybuf.getInt();
            short compLevel = mybuf.getShort();
            logger.debug("Header claims payload compressed length is {}, deflated length is {}, compression level {}", new Object[]{compressedLen, decompressedLen, (int)compLevel});
            if (mybuf.remaining() < compressedLen) {
                throw new BlobParseFailure("The buffer remainder is too small (" + mybuf.remaining() + ") to contain the amount of data the header specifies (" + compressedLen + ").");
            }
            mybuf.limit(mybuf.position() + compressedLen);
            byte[] compressed = new byte[mybuf.remaining()];
            mybuf.get(compressed);
            inflater.setInput(compressed, headerSkip, compressed.length - headerSkip);
            byte[] decompressed = new byte[decompressedLen];
            try {
                logger.debug("Beginning decompression");
                inflater.inflate(decompressed);
                logger.debug("Decompression successful");
            }
            catch (DataFormatException ex) {
                throw new BlobParseFailure("An error occurred attempting to decompress the data", ex);
            }
            ByteBuffer newBuf = ByteBuffer.wrap(decompressed);
            newBuf.order(ByteOrder.LITTLE_ENDIAN);
            return newBuf;
        }
        catch (BufferUnderflowException bue) {
            throw new BlobParseFailure("A buffer-underflow occurred.", bue);
        }
    }

    public static BlobFolder parseClientRegistry(ByteBuffer payload) throws BlobParseFailure {
        logger.debug("Beginning parse of client registry blob data");
        List<BlobFolder> folders = RegParser.readBox(payload);
        if (folders.size() != 1) {
            throw new BlobParseFailure("Client registry should have had only one starting folder, but found  " + folders.size());
        }
        return folders.get(0);
    }

    static void readFolderItem(CellItem spec, BlobFolder parent) throws BlobParseFailure {
        byte typeNum = spec.getMeta().get();
        BlobFolder.FolderItemType thisType = BlobFolder.FolderItemType.fromNumber(typeNum);
        switch (thisType) {
            case FOLDER: {
                List<BlobFolder> folders = RegParser.readBox(spec.getPayload());
                for (BlobFolder f : folders) {
                    if (parent.getFolders().containsKey(f.getName())) {
                        throw new BlobParseFailure("Duplicate folder name encountered.");
                    }
                    parent.folders.put(f.name, f);
                }
                break;
            }
            case FILE: {
                List<BlobValue> values = RegParser.populateValues(spec.getPayload());
                for (BlobValue v : values) {
                    if (parent.getValues().containsKey(v.getName())) {
                        throw new BlobParseFailure("Duplicate item name encountered.");
                    }
                    parent.values.put(v.getName(), v);
                }
                break;
            }
            default: {
                throw new BlobParseFailure("Unexpected folder item type: " + typeNum);
            }
        }
    }

    static void populateFolder(ByteBuffer payload, BlobFolder parent) throws BlobParseFailure {
        logger.trace("Populating folder {}", (Object)parent.getName());
        CellCollection bd = RegParser.parseCell(payload);
        for (CellItem is : bd) {
            RegParser.readFolderItem(is, parent);
        }
    }

    static List<BlobFolder> readBox(ByteBuffer payload) throws BlobParseFailure {
        ArrayList<BlobFolder> ret = new ArrayList<BlobFolder>();
        CellCollection bd = RegParser.parseCell(payload);
        for (CellItem is : bd) {
            String name = RegParser.getText(is.getMeta());
            BlobFolder current = new BlobFolder(name);
            ret.add(current);
            RegParser.populateFolder(is.getPayload(), current);
        }
        return ret;
    }

    static List<BlobValue> populateValues(ByteBuffer payload) throws BlobParseFailure {
        ArrayList<BlobValue> ret = new ArrayList<BlobValue>();
        CellCollection bd = RegParser.parseCell(payload);
        for (CellItem i : bd) {
            String name = RegParser.getText(i.getMeta());
            BlobValue bv = RegParser.readScalar(i.getPayload(), name);
            ret.add(bv);
        }
        return ret;
    }

    static BlobValue readScalar(ByteBuffer payload, String name) throws BlobParseFailure {
        CellCollection bd = RegParser.parseCell(payload);
        if (bd.items.size() != 2) {
            throw new BlobParseFailure("A two-item scalar data payload with type and item were expected, but " + bd.items.size() + " children were encountered.");
        }
        Enum type = null;
        ByteBuffer realValue = null;
        block9: for (CellItem is : bd) {
            byte kind = is.getMeta().get();
            switch (kind) {
                case 1: {
                    byte typeNum = is.getPayload().get();
                    if (type != null) {
                        throw new BlobParseFailure("Scalar data-type block encountered twice, should only be seen once.");
                    }
                    type = BlobValue.DataType.fromNumber(typeNum);
                    if (type != null) continue block9;
                    throw new BlobParseFailure("Unexpected scalar type. Expected DWORD, RAW, or TEXT, but an unrecognized number was encountered: " + typeNum);
                }
                case 2: {
                    if (realValue != null) {
                        throw new BlobParseFailure("Scalar raw-value block encountered twice, should only be seen once.");
                    }
                    realValue = is.getPayload();
                    continue block9;
                }
            }
            throw new BlobParseFailure("Expected a two-item payload with scalar type and scalar value, but encountered an unrecognized discriminator: " + kind);
        }
        if (type == null) {
            throw new BlobParseFailure("No data-type block was found for scalar.");
        }
        if (realValue == null) {
            throw new BlobParseFailure("No raw data block was found for scalar.");
        }
        switch (1.$SwitchMap$com$technofovea$hl2parse$registry$BlobValue$DataType[type.ordinal()]) {
            case 1: {
                return new BlobDword(name, realValue);
            }
            case 2: {
                return new BlobRaw(name, realValue);
            }
            case 3: {
                return new BlobText(name, realValue);
            }
        }
        throw new BlobParseFailure("Not configured to return data type: " + type);
    }
}

