/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.fgd;

import com.technofovea.hl2parse.fgd.ChoicesValue;
import com.technofovea.hl2parse.fgd.FgdSpec;
import com.technofovea.hl2parse.fgd.FlagValue;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FgdProperty {
    public static final String TYPE_CHOICES = "choices";
    public static final String TYPE_FLAGS = "flags";
    String type;
    boolean readonly = false;
    String shortDesc = "";
    String longDesc = "";
    String defaultVal = "";
    List<FlagValue> flags = new ArrayList<FlagValue>();
    List<ChoicesValue> options = new ArrayList<ChoicesValue>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public List<FlagValue> getFlags() {
        return this.flags;
    }

    public List<ChoicesValue> getOptions() {
        return this.options;
    }

    public String toText(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        sb.append(this.type);
        sb.append(") ");
        sb.append(": \"");
        sb.append(this.shortDesc);
        sb.append("\" : ");
        String temp = FgdSpec.quoteVal(this.defaultVal);
        sb.append(temp);
        sb.append(" : \"");
        sb.append(this.longDesc);
        sb.append("\" ");
        if (TYPE_CHOICES.equalsIgnoreCase(this.type)) {
            sb.append("=\n[\n");
            for (ChoicesValue o : this.options) {
                sb.append(o.toText());
                sb.append("\n");
            }
            sb.append("]");
        } else if (TYPE_FLAGS.equalsIgnoreCase(this.type)) {
            sb.append("=\n[\n");
            for (FlagValue f : this.flags) {
                sb.append(f.toText());
                sb.append("\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    void setShortDescription(String str) {
        this.shortDesc = str;
        if (this.shortDesc == null) {
            this.shortDesc = "";
        }
    }

    void setLongDescription(String str) {
        this.longDesc = str;
        if (this.longDesc == null) {
            this.longDesc = "";
        }
    }

    void setDefault(String str) {
        this.defaultVal = str;
        if (this.defaultVal == null) {
            this.defaultVal = "";
        }
    }

    public String getDefaultVal() {
        return this.defaultVal;
    }

    public String getLongDesc() {
        return this.longDesc;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }
}

