----------------------------------------------------------------
-- GAME DEF : Kingpin
----------------------------------------------------------------
--
--  Oblige Level Maker
--
--  Copyright (C) 2006-2011 Andrew Apted
--
--  This program is free software; you can redistribute it and/or
--  modify it under the terms of the GNU General Public License
--  as published by the Free Software Foundation; either version 2
--  of the License, or (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
----------------------------------------------------------------

QUAKE2 = { }

QUAKE2.ENTITIES =
{
  -- players
  player1 = { id="info_player_start", r=16, h=56 }
  player2 = { id="info_player_coop",  r=16, h=56 }
  player3 = { id="info_player_coop",  r=16, h=56 }
  player4 = { id="info_player_coop",  r=16, h=56 }

  dm_player = { id="info_player_deathmatch" }

  teleport_spot = { id="info_notnull" }
  teleporter    = { id="misc_teleporter" }
  tele_pad      = { id="misc_teleporter_dest" }

  -- keys
  k_key1  = { id="key_key1" }
  k_key2  = { id="key_key2" }
  k_key3  = { id="key_key3" }-- under here not used as key
  k_key4  = { id="key_key4" }
  k_key5  = { id="key_key5" }
  k_key6  = { id="key_key6" }
  k_key7  = { id="key_key7" }
  k_key8  = { id="key_key8" }
  k_key9  = { id="key_key9" }
  k_key10  = { id="key_key10" }

  -- powerups
  adrenaline = { id="item_adrenaline", r=16, h=16, pass=true}
  item_pack  = { id="item_pack", r=16, h=16, pass=true}


  -- scenery
 -- trashcan    = { id="props_trashcanA", r=20, h=40, pass=true }
 -- dead_dude   = { id="props2_deadguy", r=20, h=60, pass=true }


  -- special

  light = { id="light" }
  junior = { id="junior", r=10, h=10, pass=true }
  sun   = { id="oblige_sun" }

  door   = { id="func_door" }
  lift   = { id="func_plat" }
  wall   = { id="func_wall" }
  button = { id="func_button" }
  
  secret_door = { id="func_door_secret" }

  trigger  = { id="trigger_multiple" }
  trig_key = { id="trigger_key" }
   
  change_lev = { id="target_changelevel" }

  camera = { id="info_player_intermission" }

  -- TODO
}


QUAKE2.PARAMETERS =
{
  map_limit = 8000  -- verified (limit of C/S protocol)

  centre_map = true

  use_spawnflags = false --Gives problems
  entity_delta_z = 24

  -- keys are lost when you open a locked door
  lose_keys = true

  bridges = true
  extra_floors = true
  deep_liquids = true

  jump_height = 58

  -- the name buffer in Quake II is huge, but this value
  -- reflects the on-screen space (in the computer panel)
  max_name_length = 24

  skip_monsters = { 30,50 }

  time_factor   = 1.0
  damage_factor = 1.0
  ammo_factor   = 0.8
  health_factor = 0.7
  monster_factor = 0.6
}


----------------------------------------------------------------

QUAKE2.MATERIALS =
{
  -- special materials --
  _ERROR = { t="common/rc_tu_ab" }
  _SKY   = { t="common/0_sky1" }


BR_RC_V1  = { t="bricks/br_rc_v1" }
BR_RC_V1A  = { t="bricks/br_rc_v1a" }
BR_RC_V1M1  = { t="bricks/br_rc_v1m1" }
BR_RC_V1MDR1  = { t="bricks/br_rc_v1mdr1" }
BR_SR_20MS  = { t="bricks/br_sr_20ms" }
BR_SR_20MS1  = { t="bricks/br_sr_20ms1" }
B_CP_V10X  = { t="bricks/b_cp_v10x" }
B_CP_V11  = { t="bricks/b_cp_v11" }
B_CP_V13  = { t="bricks/b_cp_v13" }
B_CP_V15  = { t="bricks/b_cp_v15" }
B_CP_V15A  = { t="bricks/b_cp_v15a" }
B_CP_V16  = { t="bricks/b_cp_v16" }
B_CP_V18  = { t="bricks/b_cp_v18" }
B_CP_V18A  = { t="bricks/b_cp_v18a" }
B_CP_V18AN  = { t="bricks/b_cp_v18an" }
B_CP_V18C  = { t="bricks/b_cp_v18c" }
B_CP_V18E  = { t="bricks/b_cp_v18e" }
B_CP_V18EA  = { t="bricks/b_cp_v18ea" }
B_CP_V18G  = { t="bricks/b_cp_v18g" }
B_CP_V19  = { t="bricks/b_cp_v19" }
B_CP_V19AB  = { t="bricks/b_cp_v19ab" }
B_CP_V19AC  = { t="bricks/b_cp_v19ac" }
B_CP_V19AD  = { t="bricks/b_cp_v19ad" }
B_CP_V19B  = { t="bricks/b_cp_v19b" }
B_CP_V19D  = { t="bricks/b_cp_v19d" }
B_CP_V22  = { t="bricks/b_cp_v22" }
B_CP_V23  = { t="bricks/b_cp_v23" }
B_CP_V23A  = { t="bricks/b_cp_v23a" }
B_CP_V25  = { t="bricks/b_cp_v25" }
B_CP_V31  = { t="bricks/b_cp_v31" }
B_CP_V31AA  = { t="bricks/b_cp_v31aa" }
B_CP_V32  = { t="bricks/b_cp_v32" }
B_CP_V33B  = { t="bricks/b_cp_v33b" }
B_CP_V4  = { t="bricks/b_cp_v4" }
B_CP_V8  = { t="bricks/b_cp_v8" }
B_CP_V9  = { t="bricks/b_cp_v9" }
B_CP_V9B  = { t="bricks/b_cp_v9b" }
B_HL_V2  = { t="bricks/b_hl_v2" }
B_HL_V2A  = { t="bricks/b_hl_v2a" }
B_HL_V2B  = { t="bricks/b_hl_v2b" }
B_HL_V2E  = { t="bricks/b_hl_v2e" }
B_HL_V2J  = { t="bricks/b_hl_v2j" }
B_MF_V1  = { t="bricks/b_mf_v1" }
B_MF_V12  = { t="bricks/b_mf_v12" }
B_MF_V12B  = { t="bricks/b_mf_v12b" }
B_MF_V2  = { t="bricks/b_mf_v2" }
B_MF_V2A  = { t="bricks/b_mf_v2a" }
B_MF_V2B  = { t="bricks/b_mf_v2b" }
B_MF_V3  = { t="bricks/b_mf_v3" }
B_MF_V4  = { t="bricks/b_mf_v4" }
B_MF_V5  = { t="bricks/b_mf_v5" }
B_MF_V6A  = { t="bricks/b_mf_v6a" }
B_MF_V8A  = { t="bricks/b_mf_v8a" }
B_PV_V1  = { t="bricks/b_pv_v1" }
B_PV_V1A  = { t="bricks/b_pv_v1a" }
B_PV_V1B  = { t="bricks/b_pv_v1b" }
B_PV_V1C  = { t="bricks/b_pv_v1c" }
B_PV_V1CA  = { t="bricks/b_pv_v1ca" }
B_PV_V1CB  = { t="bricks/b_pv_v1cb" }
B_PV_V1D  = { t="bricks/b_pv_v1d" }
B_PV_V1E  = { t="bricks/b_pv_v1e" }
B_PV_V2  = { t="bricks/b_pv_v2" }
B_PV_V3  = { t="bricks/b_pv_v3" }
B_PV_V3A  = { t="bricks/b_pv_v3a" }
B_PV_V3B  = { t="bricks/b_pv_v3b" }
B_PV_V3C  = { t="bricks/b_pv_v3c" }
B_RC_V10  = { t="bricks/b_rc_v10" }
B_RC_V10AA  = { t="bricks/b_rc_v10aa" }
B_RC_V10AB  = { t="bricks/b_rc_v10ab" }
B_RC_V13  = { t="bricks/b_rc_v13" }
B_RC_V13A  = { t="bricks/b_rc_v13a" }
B_RC_V13B  = { t="bricks/b_rc_v13b" }
B_RC_V13C  = { t="bricks/b_rc_v13c" }
B_RC_V15  = { t="bricks/b_rc_v15" }
B_RC_V16  = { t="bricks/b_rc_v16" }
B_RC_V16A  = { t="bricks/b_rc_v16a" }
B_RC_V19  = { t="bricks/b_rc_v19" }
B_RC_V2  = { t="bricks/b_rc_v2" }
B_RC_V20  = { t="bricks/b_rc_v20" }
B_RC_V23  = { t="bricks/b_rc_v23" }
B_RC_V24  = { t="bricks/b_rc_v24" }
B_RC_V24A  = { t="bricks/b_rc_v24a" }
B_RC_V25  = { t="bricks/b_rc_v25" }
B_RC_V26  = { t="bricks/b_rc_v26" }
B_RC_V27  = { t="bricks/b_rc_v27" }
B_RC_V28  = { t="bricks/b_rc_v28" }
B_RC_V29  = { t="bricks/b_rc_v29" }
B_RC_V3  = { t="bricks/b_rc_v3" }
B_RC_V4  = { t="bricks/b_rc_v4" }
B_RC_V5  = { t="bricks/b_rc_v5" }
B_RC_V6  = { t="bricks/b_rc_v6" }
B_RC_V7  = { t="bricks/b_rc_v7" }
B_RC_V8  = { t="bricks/b_rc_v8" }
B_RC_V9  = { t="bricks/b_rc_v9" }
B_SI_V  = { t="bricks/b_si_v" }
B_SR_20  = { t="bricks/b_sr_20" }
B_SR_20A  = { t="bricks/b_sr_20a" }
B_SR_20AA  = { t="bricks/b_sr_20aa" }
B_SR_20AG  = { t="bricks/b_sr_20ag" }
B_SR_20AP  = { t="bricks/b_sr_20ap" }
B_SR_20B  = { t="bricks/b_sr_20b" }
B_SR_20MM  = { t="bricks/b_sr_20mm" }
B_SR_20X  = { t="bricks/b_sr_20x" }
B_SR_20Z  = { t="bricks/b_sr_20z" }
B_SR_21  = { t="bricks/b_sr_21" }
B_SR_22  = { t="bricks/b_sr_22" }
B_SR_23  = { t="bricks/b_sr_23" }
B_SR_24  = { t="bricks/b_sr_24" }
B_SR_25  = { t="bricks/b_sr_25" }
B_SR_26  = { t="bricks/b_sr_26" }
B_SR_C01  = { t="bricks/b_sr_c01" }
B_SR_C02  = { t="bricks/b_sr_c02" }
B_SR_C03  = { t="bricks/b_sr_c03" }
B_SR_C04  = { t="bricks/b_sr_c04" }
B_SR_C05  = { t="bricks/b_sr_c05" }
B_SR_C06  = { t="bricks/b_sr_c06" }
B_SR_C07  = { t="bricks/b_sr_c07" }
B_SR_C09  = { t="bricks/b_sr_c09" }
B_SR_C09AA  = { t="bricks/b_sr_c09aa" }
B_SR_C10  = { t="bricks/b_sr_c10" }
B_SR_C11  = { t="bricks/b_sr_c11" }
B_SR_C12  = { t="bricks/b_sr_c12" }
B_SR_C12A  = { t="bricks/b_sr_c12a" }
B_SR_C13  = { t="bricks/b_sr_c13" }
B_SR_C14  = { t="bricks/b_sr_c14" }
B_SR_C15  = { t="bricks/b_sr_c15" }
B_SR_C16  = { t="bricks/b_sr_c16" }
B_SR_C17  = { t="bricks/b_sr_c17" }
B_SR_C20  = { t="bricks/b_sr_c20" }
B_SR_C21  = { t="bricks/b_sr_c21" }
B_SR_C22  = { t="bricks/b_sr_c22" }
B_SR_C23  = { t="bricks/b_sr_c23" }
B_SR_C26  = { t="bricks/b_sr_c26" }
B_SR_C26D  = { t="bricks/b_sr_c26d" }
B_SR_C27  = { t="bricks/b_sr_c27" }
B_SR_C29C  = { t="bricks/b_sr_c29c" }
B_SR_C31  = { t="bricks/b_sr_c31" }
B_SR_MV1  = { t="bricks/b_sr_mv1" }
B_SR_V12  = { t="bricks/b_sr_v12" }
B_SR_V18  = { t="bricks/b_sr_v18" }
B_SR_V19  = { t="bricks/b_sr_v19" }
B_SR_V19A  = { t="bricks/b_sr_v19a" }
B_SR_V19C  = { t="bricks/b_sr_v19c" }
B_SR_V19D  = { t="bricks/b_sr_v19d" }
B_SR_V20  = { t="bricks/b_sr_v20" }
B_SR_V20B  = { t="bricks/b_sr_v20b" }
B_SR_V22  = { t="bricks/b_sr_v22" }
B_SR_V22A  = { t="bricks/b_sr_v22a" }
B_SR_V23A  = { t="bricks/b_sr_v23a" }
B_SR_V23B  = { t="bricks/b_sr_v23b" }
B_SR_V24  = { t="bricks/b_sr_v24" }
B_SR_V24T  = { t="bricks/b_sr_v24t" }
B_SR_V25B  = { t="bricks/b_sr_v25b" }
B_SR_V25C  = { t="bricks/b_sr_v25c" }
B_SR_V26  = { t="bricks/b_sr_v26" }
B_SR_V26A  = { t="bricks/b_sr_v26a" }
B_SR_V27  = { t="bricks/b_sr_v27" }
B_SR_V27A  = { t="bricks/b_sr_v27a" }
B_SR_V27B  = { t="bricks/b_sr_v27b" }
B_SR_V27C  = { t="bricks/b_sr_v27c" }
B_SR_V27D  = { t="bricks/b_sr_v27d" }
B_SR_V28  = { t="bricks/b_sr_v28" }
B_SR_V28A  = { t="bricks/b_sr_v28a" }
B_SR_V28B  = { t="bricks/b_sr_v28b" }
B_SR_V28D  = { t="bricks/b_sr_v28d" }
B_SR_V28E  = { t="bricks/b_sr_v28e" }
B_SR_V29  = { t="bricks/b_sr_v29" }
B_SR_V29A  = { t="bricks/b_sr_v29a" }
B_SR_V29D  = { t="bricks/b_sr_v29d" }
B_SR_V30  = { t="bricks/b_sr_v30" }
B_SR_V30A  = { t="bricks/b_sr_v30a" }
B_SR_V30AW  = { t="bricks/b_sr_v30aw" }
B_SR_V30C  = { t="bricks/b_sr_v30c" }
B_SR_V30D  = { t="bricks/b_sr_v30d" }
B_SR_V30E  = { t="bricks/b_sr_v30e" }
B_SR_V30H  = { t="bricks/b_sr_v30h" }
B_SR_V30I  = { t="bricks/b_sr_v30i" }
B_SR_V30J  = { t="bricks/b_sr_v30j" }
B_SR_V30K  = { t="bricks/b_sr_v30k" }
B_SR_V30L  = { t="bricks/b_sr_v30l" }
B_SR_V30W  = { t="bricks/b_sr_v30w" }
B_SR_V31  = { t="bricks/b_sr_v31" }
B_SR_V31A  = { t="bricks/b_sr_v31a" }
B_SR_V31B  = { t="bricks/b_sr_v31b" }
B_SR_V31C  = { t="bricks/b_sr_v31c" }
B_SR_V31D  = { t="bricks/b_sr_v31d" }
B_SR_V31F  = { t="bricks/b_sr_v31f" }
C_MF_V1  = { t="bricks/c_mf_v1" }
C_MF_V10A  = { t="bricks/c_mf_v10a" }
C_MF_V2A  = { t="bricks/c_mf_v2a" }
C_MF_V2B  = { t="bricks/c_mf_v2b" }
C_MF_V3  = { t="bricks/c_mf_v3" }
C_MF_V3A  = { t="bricks/c_mf_v3a" }
C_MF_V3B  = { t="bricks/c_mf_v3b" }
C_MF_V3C  = { t="bricks/c_mf_v3c" }
C_MF_V3D  = { t="bricks/c_mf_v3d" }
C_MF_V5  = { t="bricks/c_mf_v5" }
C_MF_V7  = { t="bricks/c_mf_v7" }
C_MF_V7C  = { t="bricks/c_mf_v7c" }
C_MF_V7D  = { t="bricks/c_mf_v7d" }
C_MF_V7E  = { t="bricks/c_mf_v7e" }
C_PV_18  = { t="bricks/c_pv_18" }
C_PV_18A  = { t="bricks/c_pv_18a" }
C_PV_18B  = { t="bricks/c_pv_18b" }
C_PV_M1  = { t="bricks/c_pv_m1" }
C_PV_M2  = { t="bricks/c_pv_m2" }
C_PV_M22  = { t="bricks/c_pv_m22" }
C_PV_M23  = { t="bricks/c_pv_m23" }
C_PV_M2G  = { t="bricks/c_pv_m2g" }
C_PV_M2GG  = { t="bricks/c_pv_m2gg" }
C_PV_M2PP  = { t="bricks/c_pv_m2pp" }
C_PV_M2Y  = { t="bricks/c_pv_m2y" }
C_PV_M3  = { t="bricks/c_pv_m3" }
C_PV_V1B  = { t="bricks/c_pv_v1b" }
C_PV_V2K  = { t="bricks/c_pv_v2k" }
C_PV_V3Y  = { t="bricks/c_pv_v3y" }
C_SR_M1A  = { t="bricks/c_sr_m1a" }
C_SR_M1A1  = { t="bricks/c_sr_m1a1" }
C_SR_M1D  = { t="bricks/c_sr_m1d" }
C_SR_M2  = { t="bricks/c_sr_m2" }
C_SR_M2A  = { t="bricks/c_sr_m2a" }
C_SR_M2B  = { t="bricks/c_sr_m2b" }
C_SR_M2C  = { t="bricks/c_sr_m2c" }
C_SR_M2D  = { t="bricks/c_sr_m2d" }
C_SR_M2E  = { t="bricks/c_sr_m2e" }
C_SR_M3  = { t="bricks/c_sr_m3" }
C_SR_M3A  = { t="bricks/c_sr_m3a" }
C_SR_M3AA  = { t="bricks/c_sr_m3aa" }
C_SR_M3BA  = { t="bricks/c_sr_m3ba" }
C_SR_M7  = { t="bricks/c_sr_m7" }
C_SR_M8  = { t="bricks/c_sr_m8" }
C_SR_M8A  = { t="bricks/c_sr_m8a" }
C_SR_M8B  = { t="bricks/c_sr_m8b" }
C_SR_M8D  = { t="bricks/c_sr_m8d" }
C_SR_M8E  = { t="bricks/c_sr_m8e" }
C_SR_M9  = { t="bricks/c_sr_m9" }
C_SR_M9A  = { t="bricks/c_sr_m9a" }
C_SR_M9C  = { t="bricks/c_sr_m9c" }
C_SR_MB1  = { t="bricks/c_sr_mb1" }
C_SR_MB1A  = { t="bricks/c_sr_mb1a" }
C_SR_MB1V  = { t="bricks/c_sr_mb1v" }
C_SR_MB2  = { t="bricks/c_sr_mb2" }
C_SR_MB2A  = { t="bricks/c_sr_mb2a" }
C_SR_MB2B  = { t="bricks/c_sr_mb2b" }
C_SR_MR5  = { t="bricks/c_sr_mr5" }
C_TN_M1  = { t="bricks/c_tn_m1" }
C_TN_M3  = { t="bricks/c_tn_m3" }
RF_SR_M2S  = { t="bricks/rf_sr_m2s" }
S_RC_C01  = { t="bricks/s_rc_c01" }
S_RC_C03  = { t="bricks/s_rc_c03" }
S_RC_C07  = { t="bricks/s_rc_c07" }
S_RC_C08  = { t="bricks/s_rc_c08" }
S_RC_C09  = { t="bricks/s_rc_c09" }
S_SR_M12A  = { t="bricks/s_sr_m12a" }
S_SR_M12AB  = { t="bricks/s_sr_m12ab" }
S_SR_M12B  = { t="bricks/s_sr_m12b" }
S_SR_M12C  = { t="bricks/s_sr_m12c" }
S_SR_M12D  = { t="bricks/s_sr_m12d" }
S_SR_M13  = { t="bricks/s_sr_m13" }
S_SR_M13F  = { t="bricks/s_sr_m13f" }
S_SR_M13G  = { t="bricks/s_sr_m13g" }
S_SR_M1A  = { t="bricks/s_sr_m1a" }
S_SR_M1AG  = { t="bricks/s_sr_m1ag" }
S_SR_M2A  = { t="bricks/s_sr_m2a" }
S_SR_M3  = { t="bricks/s_sr_m3" }
S_SR_M4  = { t="bricks/s_sr_m4" }
S_SR_M4A  = { t="bricks/s_sr_m4a" }
S_SR_M6  = { t="bricks/s_sr_m6" }
S_SR_M7  = { t="bricks/s_sr_m7" }

B_CP_41R  = { t="bricks2/b_cp_41r" }
B_CP_41RA  = { t="bricks2/b_cp_41ra" }
B_CP_41S  = { t="bricks2/b_cp_41s" }
B_CP_41SA  = { t="bricks2/b_cp_41sa" }
B_CP_V17AA  = { t="bricks2/b_cp_v17aa" }
B_CP_V17AB  = { t="bricks2/b_cp_v17ab" }
B_CP_V23A  = { t="bricks2/b_cp_v23a" }
B_CP_V23AA  = { t="bricks2/b_cp_v23aa" }
B_CP_V24A  = { t="bricks2/b_cp_v24a" }
B_CP_V24B  = { t="bricks2/b_cp_v24b" }
B_CP_V28A  = { t="bricks2/b_cp_v28a" }
B_CP_V41MA  = { t="bricks2/b_cp_v41ma" }
B_CP_V41N  = { t="bricks2/b_cp_v41n" }
B_CP_V41NA  = { t="bricks2/b_cp_v41na" }
B_CP_V41NB  = { t="bricks2/b_cp_v41nb" }
B_CP_V41NC  = { t="bricks2/b_cp_v41nc" }
B_CP_V41ND  = { t="bricks2/b_cp_v41nd" }
B_CP_V41P  = { t="bricks2/b_cp_v41p" }
B_CP_V43B  = { t="bricks2/b_cp_v43b" }
B_CP_V9A  = { t="bricks2/b_cp_v9a" }
B_CP_V9C  = { t="bricks2/b_cp_v9c" }
B_CT_V1A  = { t="bricks2/b_ct_v1a" }
B_CT_V1C  = { t="bricks2/b_ct_v1c" }
B_CT_V1G  = { t="bricks2/b_ct_v1g" }
B_CT_V1I  = { t="bricks2/b_ct_v1i" }
B_CT_V1J  = { t="bricks2/b_ct_v1j" }
B_CT_V1N  = { t="bricks2/b_ct_v1n" }
B_CT_V1Q  = { t="bricks2/b_ct_v1q" }
B_CT_V2AB  = { t="bricks2/b_ct_v2ab" }
B_CT_V2B  = { t="bricks2/b_ct_v2b" }
B_CT_V2C  = { t="bricks2/b_ct_v2c" }
B_CT_V2D  = { t="bricks2/b_ct_v2d" }
B_CT_V2E  = { t="bricks2/b_ct_v2e" }
B_RC_M1A  = { t="bricks2/b_rc_m1a" }
B_SR_26A  = { t="bricks2/b_sr_26a" }
B_SR_V30S  = { t="bricks2/b_sr_v30s" }
B_SR_V30T  = { t="bricks2/b_sr_v30t" }
B_SR_V30V  = { t="bricks2/b_sr_v30v" }
B_SR_V30X  = { t="bricks2/b_sr_v30x" }
C_PV_18X  = { t="bricks2/c_pv_18x" }
C_PV_18Y  = { t="bricks2/c_pv_18y" }
C_PV_18Z  = { t="bricks2/c_pv_18z" }
C_PV_M1  = { t="bricks2/c_pv_m1" }
C_PV_M2Y  = { t="bricks2/c_pv_m2y" }
C_PV_V18Z  = { t="bricks2/c_pv_v18z" }
C_SY_M1  = { t="bricks2/c_sy_m1" }
C_SY_M2  = { t="bricks2/c_sy_m2" }
C_TN_M3C01  = { t="bricks2/c_tn_m3c01" }
C_TN_M3C02  = { t="bricks2/c_tn_m3c02" }
LOUIE_V1  = { t="bricks2/louie_v1" }

--0_CLIP  = { t="common/0_clip" }
--0_CLIP_MON  = { t="common/0_clip_mon" }
--0_HINT  = { t="common/0_hint" }
--0_ORIGIN  = { t="common/0_origin" }
--0_SKIP  = { t="common/0_skip" }
--0_SKY1  = { t="common/0_sky1" }
--0_TRIGGER  = { t="common/0_trigger" }
--LI_CP_V1B  = { t="common/li_cp_v1b" }
--LI_MF_V12A  = { t="common/li_mf_v12a" }
--LI_MF_V12B  = { t="common/li_mf_v12b" }
--LI_MF_V12C  = { t="common/li_mf_v12c" }
--LI_MF_V12Y  = { t="common/li_mf_v12y" }
--LI_MF_V13  = { t="common/li_mf_v13" }
--LI_MF_V14  = { t="common/li_mf_v14" }
--LI_MF_V15  = { t="common/li_mf_v15" }
--LI_MF_V16  = { t="common/li_mf_v16" }
--LI_MF_V17  = { t="common/li_mf_v17" }
--LI_PV_V1  = { t="common/li_pv_v1" }
--LI_PV_V2  = { t="common/li_pv_v2" }
--LI_PV_V2A  = { t="common/li_pv_v2a" }
--LI_PV_V3  = { t="common/li_pv_v3" }
--LI_PV_V4  = { t="common/li_pv_v4" }
--LI_PV_V4A  = { t="common/li_pv_v4a" }
--LI_PV_V4_BRK  = { t="common/li_pv_v4_brk" }
--LI_PV_V5A  = { t="common/li_pv_v5a" }
--LI_PV_V6  = { t="common/li_pv_v6" }
--LI_PV_V6A  = { t="common/li_pv_v6a" }
--LI_PV_V7  = { t="common/li_pv_v7" }
  LI_PV_V7A  = { t="common/li_pv_v7a" }
--LI_SR_M10  = { t="common/li_sr_m10" }
--LI_SR_M12  = { t="common/li_sr_m12" }
--LI_SR_M14  = { t="common/li_sr_m14" }
--LI_SR_M16  = { t="common/li_sr_m16" }
--LI_SR_M17  = { t="common/li_sr_m17" }
--LI_SR_M19  = { t="common/li_sr_m19" }
--LI_SR_M19A  = { t="common/li_sr_m19a" }
--LI_SR_M2  = { t="common/li_sr_m2" }
--LI_SR_M20  = { t="common/li_sr_m20" }
--LI_SR_M3  = { t="common/li_sr_m3" }
--LI_SR_MA1  = { t="common/li_sr_ma1" }
--LI_SR_ML5  = { t="common/li_sr_ml5" }
--LI_SR_ML6  = { t="common/li_sr_ml6" }
--LI_SR_ML7  = { t="common/li_sr_ml7" }
--LI_SR_ML9  = { t="common/li_sr_ml9" }
--LI_SR_MST2  = { t="common/li_sr_mst2" }
--LI_SR_V10  = { t="common/li_sr_v10" }
--LI_SR_V12  = { t="common/li_sr_v12" }
--LI_SR_V13  = { t="common/li_sr_v13" }
--LI_SR_V17  = { t="common/li_sr_v17" }
--LI_SR_V21  = { t="common/li_sr_v21" }
--LI_SR_V22  = { t="common/li_sr_v22" }
--LI_SR_V23  = { t="common/li_sr_v23" }
--LI_SR_V25  = { t="common/li_sr_v25" }
--LI_SR_V26  = { t="common/li_sr_v26" }
--LI_SR_V27  = { t="common/li_sr_v27" }
--LI_SR_V28  = { t="common/li_sr_v28" }
--LI_SR_V3  = { t="common/li_sr_v3" }
LI_SR_V30  = { t="common/li_sr_v30" }
--LI_SR_V32  = { t="common/li_sr_v32" }
--LI_SR_V34  = { t="common/li_sr_v34" }
--LI_SR_V36  = { t="common/li_sr_v36" }
--LI_SR_V39  = { t="common/li_sr_v39" }
--LI_SR_V40  = { t="common/li_sr_v40" }
--LI_SR_V41  = { t="common/li_sr_v41" }
--LI_TRACK  = { t="common/li_track" }
--LI_TRACK2  = { t="common/li_track2" }
--MOLTED5  = { t="common/molted5" }
--RC_TU_AB  = { t="common/rc_tu_ab" }
--WATER3  = { t="common/water3" }
--WATER_HL_V2  = { t="common/water_hl_v2" }

C_PV_M1  = { t="floors/c_pv_m1" }
C_PV_M2  = { t="floors/c_pv_m2" }
C_PV_M3  = { t="floors/c_pv_m3" }
DR_CP_V7  = { t="floors/dr_cp_v7" }
DR_LH_C01  = { t="floors/dr_lh_c01" }
DR_LH_C01A  = { t="floors/dr_lh_c01a" }
DR_LH_C01A_2  = { t="floors/dr_lh_c01a_2" }
DR_LH_C01B  = { t="floors/dr_lh_c01b" }
DR_LH_C01_2  = { t="floors/dr_lh_c01_2" }
DR_LH_C03  = { t="floors/dr_lh_c03" }
DR_LH_C04  = { t="floors/dr_lh_c04" }
DR_LH_C05A  = { t="floors/dr_lh_c05a" }
DR_PV_M1  = { t="floors/dr_pv_m1" }
DR_PV_M3  = { t="floors/dr_pv_m3" }
DR_PV_M3Y  = { t="floors/dr_pv_m3y" }
DR_PV_M4  = { t="floors/dr_pv_m4" }
DR_PV_M4A  = { t="floors/dr_pv_m4a" }
DR_PV_MA1  = { t="floors/dr_pv_ma1" }
DR_PV_MA1A  = { t="floors/dr_pv_ma1a" }
DR_PV_MA1D  = { t="floors/dr_pv_ma1d" }
DR_PV_MA2  = { t="floors/dr_pv_ma2" }
DR_PV_MM4  = { t="floors/dr_pv_mm4" }
DR_PV_MM4A  = { t="floors/dr_pv_mm4a" }
DR_PV_VV1  = { t="floors/dr_pv_vv1" }
DR_PV_VV1D  = { t="floors/dr_pv_vv1d" }
DR_PV_VV2  = { t="floors/dr_pv_vv2" }
DR_PV_VV3  = { t="floors/dr_pv_vv3" }
DR_SR_MM7  = { t="floors/dr_sr_mm7" }
DR_SR_MM8  = { t="floors/dr_sr_mm8" }
DR_SR_V1  = { t="floors/dr_sr_v1" }
DR_SR_V1Y  = { t="floors/dr_sr_v1y" }
DR_ST_C01  = { t="floors/dr_st_c01" }
DR_ST_C01A  = { t="floors/dr_st_c01a" }
DR_ST_C03  = { t="floors/dr_st_c03" }
DR_ST_M10  = { t="floors/dr_st_m10" }
DR_ST_M10A  = { t="floors/dr_st_m10a" }
DR_ST_M1B  = { t="floors/dr_st_m1b" }
DR_ST_M1C  = { t="floors/dr_st_m1c" }
DR_ST_M1D  = { t="floors/dr_st_m1d" }
DR_ST_M1DM  = { t="floors/dr_st_m1dm" }
DR_ST_M2  = { t="floors/dr_st_m2" }
DR_ST_M3  = { t="floors/dr_st_m3" }
DR_ST_M3A  = { t="floors/dr_st_m3a" }
DR_ST_M3B  = { t="floors/dr_st_m3b" }
DR_ST_M4  = { t="floors/dr_st_m4" }
DR_ST_M4A  = { t="floors/dr_st_m4a" }
DR_ST_M5  = { t="floors/dr_st_m5" }
DR_ST_M6  = { t="floors/dr_st_m6" }
DR_ST_M7  = { t="floors/dr_st_m7" }
DR_ST_M8  = { t="floors/dr_st_m8" }
DR_TY_M1  = { t="floors/dr_ty_m1" }
FL_CP_V11C  = { t="floors/fl_cp_v11c" }
FL_CP_V4  = { t="floors/fl_cp_v4" }
FL_CP_V5  = { t="floors/fl_cp_v5" }
FL_CP_V5A  = { t="floors/fl_cp_v5a" }
FL_CP_V7  = { t="floors/fl_cp_v7" }
FL_CP_V8  = { t="floors/fl_cp_v8" }
FL_CP_V9  = { t="floors/fl_cp_v9" }
FL_HL_V1  = { t="floors/fl_hl_v1" }
FL_HL_V1A  = { t="floors/fl_hl_v1a" }
FL_HL_V1B  = { t="floors/fl_hl_v1b" }
FL_HL_V1C  = { t="floors/fl_hl_v1c" }
FL_HL_V1D  = { t="floors/fl_hl_v1d" }
FL_PV_M  = { t="floors/fl_pv_m" }
FL_PV_M13  = { t="floors/fl_pv_m13" }
FL_PV_M13A  = { t="floors/fl_pv_m13a" }
FL_PV_M13B  = { t="floors/fl_pv_m13b" }
FL_PV_M3  = { t="floors/fl_pv_m3" }
FL_PV_M4  = { t="floors/fl_pv_m4" }
FL_PV_MR4  = { t="floors/fl_pv_mr4" }
FL_PV_V1A  = { t="floors/fl_pv_v1a" }
FL_PV_V2A  = { t="floors/fl_pv_v2a" }
FL_RC_C01  = { t="floors/fl_rc_c01" }
FL_RC_C02  = { t="floors/fl_rc_c02" }
FL_RC_V2  = { t="floors/fl_rc_v2" }
FL_RC_V3  = { t="floors/fl_rc_v3" }
FL_RC_V4  = { t="floors/fl_rc_v4" }
FL_RC_V4A  = { t="floors/fl_rc_v4a" }
FL_RC_V5  = { t="floors/fl_rc_v5" }
FL_SR_V1  = { t="floors/fl_sr_v1" }
FL_SR_V1A  = { t="floors/fl_sr_v1a" }
FL_SR_V1B  = { t="floors/fl_sr_v1b" }
FL_SR_V1C  = { t="floors/fl_sr_v1c" }
FL_ST_M1  = { t="floors/fl_st_m1" }
FL_ST_M2  = { t="floors/fl_st_m2" }
FL_ST_M2A  = { t="floors/fl_st_m2a" }
FL_ST_M2B  = { t="floors/fl_st_m2b" }
RF_SR_M1  = { t="floors/rf_sr_m1" }
RF_SR_M2  = { t="floors/rf_sr_m2" }
RF_SR_M2S  = { t="floors/rf_sr_m2s" }
RF_SR_MW12  = { t="floors/rf_sr_mw12" }
RF_SR_MWA1  = { t="floors/rf_sr_mwa1" }
R_SR_M1  = { t="floors/r_sr_m1" }
R_SR_M2  = { t="floors/r_sr_m2" }
R_SR_M2A  = { t="floors/r_sr_m2a" }

TI_RC_18  = { t="floors/ti_rc_18" }
TI_RC_C09  = { t="floors/ti_rc_c09" }
TI_RC_C1  = { t="floors/ti_rc_c1" }
TI_RC_C10  = { t="floors/ti_rc_c10" }
TI_RC_C11  = { t="floors/ti_rc_c11" }
TI_RC_C12  = { t="floors/ti_rc_c12" }
TI_RC_C13  = { t="floors/ti_rc_c13" }
TI_RC_C14  = { t="floors/ti_rc_c14" }
TI_RC_C15  = { t="floors/ti_rc_c15" }
TI_RC_C16  = { t="floors/ti_rc_c16" }
TI_RC_C17B  = { t="floors/ti_rc_c17b" }
TI_RC_C1A  = { t="floors/ti_rc_c1a" }
TI_RC_C1B  = { t="floors/ti_rc_c1b" }
TI_RC_C2  = { t="floors/ti_rc_c2" }
TI_RC_C3  = { t="floors/ti_rc_c3" }
TI_RC_C3A  = { t="floors/ti_rc_c3a" }
TI_RC_C4A  = { t="floors/ti_rc_c4a" }
TI_RC_C5  = { t="floors/ti_rc_c5" }
TI_RC_C5B  = { t="floors/ti_rc_c5b" }
TI_RC_C6  = { t="floors/ti_rc_c6" }
TI_RC_C7  = { t="floors/ti_rc_c7" }
TI_RC_C8  = { t="floors/ti_rc_c8" }
TI_RC_C8A  = { t="floors/ti_rc_c8a" }

--BREAK_WD1  = { t="fx/break_wd1" }
--BREAK_WD2  = { t="fx/break_wd2" }
--EXPLODE_BX1  = { t="fx/explode_bx1" }
--EXPLODE_BX1A  = { t="fx/explode_bx1a" }
--EXPLODE_BX2  = { t="fx/explode_bx2" }
--EXPLODE_BX3  = { t="fx/explode_bx3" }
--EXPL_AMMO1  = { t="fx/expl_ammo1" }
--EXPL_AMMO2  = { t="fx/expl_ammo2" }
--EXPL_AMMO3  = { t="fx/expl_ammo3" }
--PUSH_BX1  = { t="fx/push_bx1" }
--PUSH_BX2  = { t="fx/push_bx2" }

ME_HL_C23  = { t="metals/me_hl_c23" }
ME_HL_C24  = { t="metals/me_hl_c24" }
ME_HL_C25  = { t="metals/me_hl_c25" }
ME_HL_C26  = { t="metals/me_hl_c26" }
ME_HL_C27  = { t="metals/me_hl_c27" }
ME_HL_C28  = { t="metals/me_hl_c28" }
ME_HL_C29  = { t="metals/me_hl_c29" }
ME_HL_C30  = { t="metals/me_hl_c30" }
ME_HL_C33  = { t="metals/me_hl_c33" }
ME_HL_C34  = { t="metals/me_hl_c34" }
MT_MF_V10  = { t="metals/mt_mf_v10" }
MT_MF_V10A  = { t="metals/mt_mf_v10a" }
MT_MF_V11  = { t="metals/mt_mf_v11" }
MT_MF_V1A  = { t="metals/mt_mf_v1a" }
MT_MF_V1B  = { t="metals/mt_mf_v1b" }
MT_MF_V1C  = { t="metals/mt_mf_v1c" }
MT_MF_V1D  = { t="metals/mt_mf_v1d" }
MT_MF_V2A  = { t="metals/mt_mf_v2a" }
MT_MF_V2B  = { t="metals/mt_mf_v2b" }
MT_MF_V2C  = { t="metals/mt_mf_v2c" }
MT_MF_V3  = { t="metals/mt_mf_v3" }
MT_MF_V4  = { t="metals/mt_mf_v4" }
MT_PV_17  = { t="metals/mt_pv_17" }
MT_PV_17A  = { t="metals/mt_pv_17a" }
MT_PV_17B  = { t="metals/mt_pv_17b" }
MT_PV_17D  = { t="metals/mt_pv_17d" }
MT_PV_17E  = { t="metals/mt_pv_17e" }
MT_PV_17F  = { t="metals/mt_pv_17f" }
MT_PV_17G  = { t="metals/mt_pv_17g" }
MT_PV_M10  = { t="metals/mt_pv_m10" }
MT_PV_M10ALM  = { t="metals/mt_pv_m10alm" }
MT_PV_M10AM  = { t="metals/mt_pv_m10am" }
MT_PV_M10AMA  = { t="metals/mt_pv_m10ama" }
MT_PV_M10BM  = { t="metals/mt_pv_m10bm" }
MT_PV_M10CM  = { t="metals/mt_pv_m10cm" }
MT_PV_M10M  = { t="metals/mt_pv_m10m" }
MT_PV_M11AL  = { t="metals/mt_pv_m11al" }
MT_PV_M11AM  = { t="metals/mt_pv_m11am" }
MT_PV_M11BM  = { t="metals/mt_pv_m11bm" }
MT_PV_M11C  = { t="metals/mt_pv_m11c" }
MT_PV_M11H  = { t="metals/mt_pv_m11h" }
MT_PV_M11I  = { t="metals/mt_pv_m11i" }
MT_PV_M11M  = { t="metals/mt_pv_m11m" }
MT_PV_M13  = { t="metals/mt_pv_m13" }
MT_PV_M13A  = { t="metals/mt_pv_m13a" }
MT_PV_M13AG  = { t="metals/mt_pv_m13ag" }
MT_PV_M13B  = { t="metals/mt_pv_m13b" }
MT_PV_M13BG  = { t="metals/mt_pv_m13bg" }
MT_PV_M13C  = { t="metals/mt_pv_m13c" }
MT_PV_M13G  = { t="metals/mt_pv_m13g" }
MT_PV_M14  = { t="metals/mt_pv_m14" }
MT_PV_M14Y  = { t="metals/mt_pv_m14y" }
MT_PV_M15B  = { t="metals/mt_pv_m15b" }
MT_PV_M15F  = { t="metals/mt_pv_m15f" }
MT_PV_M16  = { t="metals/mt_pv_m16" }
MT_PV_M16A  = { t="metals/mt_pv_m16a" }
MT_PV_M16B  = { t="metals/mt_pv_m16b" }
MT_PV_M16BB  = { t="metals/mt_pv_m16bb" }
MT_PV_M16BC  = { t="metals/mt_pv_m16bc" }
MT_PV_M16C  = { t="metals/mt_pv_m16c" }
MT_PV_M16D  = { t="metals/mt_pv_m16d" }
MT_PV_M16E  = { t="metals/mt_pv_m16e" }
MT_PV_M16F  = { t="metals/mt_pv_m16f" }
MT_PV_M16J  = { t="metals/mt_pv_m16j" }
MT_PV_M16K  = { t="metals/mt_pv_m16k" }
MT_PV_M16L  = { t="metals/mt_pv_m16l" }
MT_PV_M16M  = { t="metals/mt_pv_m16m" }
MT_PV_M16N  = { t="metals/mt_pv_m16n" }
MT_PV_M17  = { t="metals/mt_pv_m17" }
MT_PV_M1AM  = { t="metals/mt_pv_m1am" }
MT_PV_M1BM  = { t="metals/mt_pv_m1bm" }
MT_PV_M1CM  = { t="metals/mt_pv_m1cm" }
MT_PV_M1EM  = { t="metals/mt_pv_m1em" }
MT_PV_M1M  = { t="metals/mt_pv_m1m" }
MT_PV_M26  = { t="metals/mt_pv_m26" }
MT_PV_M26Y  = { t="metals/mt_pv_m26y" }
MT_PV_M2AM  = { t="metals/mt_pv_m2am" }
MT_PV_M2AMA  = { t="metals/mt_pv_m2ama" }
MT_PV_M2M  = { t="metals/mt_pv_m2m" }
MT_PV_M3AM  = { t="metals/mt_pv_m3am" }
MT_PV_M3BM  = { t="metals/mt_pv_m3bm" }
MT_PV_M3CM  = { t="metals/mt_pv_m3cm" }
MT_PV_M3DM  = { t="metals/mt_pv_m3dm" }
MT_PV_M3M  = { t="metals/mt_pv_m3m" }
MT_PV_M4AM  = { t="metals/mt_pv_m4am" }
MT_PV_M4M  = { t="metals/mt_pv_m4m" }
MT_PV_M5AM  = { t="metals/mt_pv_m5am" }
MT_PV_M5BM  = { t="metals/mt_pv_m5bm" }
MT_PV_M5CM  = { t="metals/mt_pv_m5cm" }
MT_PV_M5M  = { t="metals/mt_pv_m5m" }
MT_PV_M6AM  = { t="metals/mt_pv_m6am" }
MT_PV_M6M  = { t="metals/mt_pv_m6m" }
MT_PV_M7AM  = { t="metals/mt_pv_m7am" }
MT_PV_M7BM  = { t="metals/mt_pv_m7bm" }
MT_PV_M7EM  = { t="metals/mt_pv_m7em" }
MT_PV_M7M  = { t="metals/mt_pv_m7m" }
MT_PV_M8M  = { t="metals/mt_pv_m8m" }
MT_PV_M9AM  = { t="metals/mt_pv_m9am" }
MT_PV_M9BM  = { t="metals/mt_pv_m9bm" }
MT_PV_M9CM  = { t="metals/mt_pv_m9cm" }
MT_PV_M9M  = { t="metals/mt_pv_m9m" }
MT_PV_V4B  = { t="metals/mt_pv_v4b" }
MT_PV_V4F  = { t="metals/mt_pv_v4f" }
MT_PV_V4G  = { t="metals/mt_pv_v4g" }
MT_PV_V4H  = { t="metals/mt_pv_v4h" }
MT_PV_V5  = { t="metals/mt_pv_v5" }
MT_PV_V6  = { t="metals/mt_pv_v6" }
MT_PV_V7  = { t="metals/mt_pv_v7" }
MT_P_1_M  = { t="metals/mt_p_1_m" }
MT_P_B_M1  = { t="metals/mt_p_b_m1" }
MT_P_R_M1  = { t="metals/mt_p_r_m1" }
MT_P_V3  = { t="metals/mt_p_v3" }
MT_P_V3A  = { t="metals/mt_p_v3a" }
MT_P_V3B  = { t="metals/mt_p_v3b" }
MT_P_V4  = { t="metals/mt_p_v4" }
MT_P_V4A  = { t="metals/mt_p_v4a" }
MT_P_V4B  = { t="metals/mt_p_v4b" }
MT_P_V5  = { t="metals/mt_p_v5" }
MT_P_V5A  = { t="metals/mt_p_v5a" }
MT_P_V5B  = { t="metals/mt_p_v5b" }
MT_P_V6  = { t="metals/mt_p_v6" }
MT_P_V6A  = { t="metals/mt_p_v6a" }
MT_P_V6B  = { t="metals/mt_p_v6b" }
MT_P_Y_M1  = { t="metals/mt_p_y_m1" }
MT_RC_V6  = { t="metals/mt_rc_v6" }
MT_RC_V7  = { t="metals/mt_rc_v7" }
MT_RC_V8  = { t="metals/mt_rc_v8" }
MT_RC_V9  = { t="metals/mt_rc_v9" }
MT_SR_B0  = { t="metals/mt_sr_b0" }
MT_SR_B0B  = { t="metals/mt_sr_b0b" }
MT_SR_B1A  = { t="metals/mt_sr_b1a" }
MT_SR_B1B  = { t="metals/mt_sr_b1b" }
MT_SR_B2  = { t="metals/mt_sr_b2" }
MT_SR_BR1  = { t="metals/mt_sr_br1" }
MT_SR_M1A  = { t="metals/mt_sr_m1a" }
MT_SR_M1AA  = { t="metals/mt_sr_m1aa" }
MT_SR_M1AB  = { t="metals/mt_sr_m1ab" }
MT_SR_M1Z  = { t="metals/mt_sr_m1z" }
MT_SR_M2A  = { t="metals/mt_sr_m2a" }
MT_SR_M2Z  = { t="metals/mt_sr_m2z" }
MT_SR_M3  = { t="metals/mt_sr_m3" }
MT_SR_M5  = { t="metals/mt_sr_m5" }
MT_SR_M6  = { t="metals/mt_sr_m6" }
MT_SR_M7  = { t="metals/mt_sr_m7" }
MT_SR_MA1  = { t="metals/mt_sr_ma1" }
MT_SR_MB1  = { t="metals/mt_sr_mb1" }
MT_SR_MN1  = { t="metals/mt_sr_mn1" }
MT_SR_MN3  = { t="metals/mt_sr_mn3" }
MT_SR_MN4  = { t="metals/mt_sr_mn4" }
MT_SR_MN4W  = { t="metals/mt_sr_mn4w" }
MT_SR_MN5  = { t="metals/mt_sr_mn5" }
MT_SR_MN6  = { t="metals/mt_sr_mn6" }
MT_SR_MN7  = { t="metals/mt_sr_mn7" }
MT_SR_MN8  = { t="metals/mt_sr_mn8" }
MT_SR_MP1  = { t="metals/mt_sr_mp1" }
MT_SR_MP1A  = { t="metals/mt_sr_mp1a" }
MT_SR_MP1B  = { t="metals/mt_sr_mp1b" }
MT_SR_V12  = { t="metals/mt_sr_v12" }
MT_SR_V13  = { t="metals/mt_sr_v13" }
MT_SR_V15  = { t="metals/mt_sr_v15" }
MT_SR_V16  = { t="metals/mt_sr_v16" }
MT_SR_V17  = { t="metals/mt_sr_v17" }
MT_SR_V18  = { t="metals/mt_sr_v18" }
MT_SR_V19  = { t="metals/mt_sr_v19" }
MT_SR_V1T  = { t="metals/mt_sr_v1t" }
MT_SR_V1X  = { t="metals/mt_sr_v1x" }
MT_SR_V1Y  = { t="metals/mt_sr_v1y" }
MT_SR_V20  = { t="metals/mt_sr_v20" }
MT_SR_V21  = { t="metals/mt_sr_v21" }
MT_SR_V23  = { t="metals/mt_sr_v23" }
MT_SR_V24  = { t="metals/mt_sr_v24" }
MT_SR_V7  = { t="metals/mt_sr_v7" }
MT_SR_V8  = { t="metals/mt_sr_v8" }
MT_SR_VC18  = { t="metals/mt_sr_vc18" }
MT_ST_C01  = { t="metals/mt_st_c01" }
M_HL_C06  = { t="metals/m_hl_c06" }
M_HL_C07  = { t="metals/m_hl_c07" }
M_HL_C07B  = { t="metals/m_hl_c07b" }
M_HL_C10  = { t="metals/m_hl_c10" }
M_HL_C10A  = { t="metals/m_hl_c10a" }
M_HL_C10AA  = { t="metals/m_hl_c10aa" }
M_HL_C10AB  = { t="metals/m_hl_c10ab" }
M_HL_C10B  = { t="metals/m_hl_c10b" }
M_HL_C10BA  = { t="metals/m_hl_c10ba" }
M_HL_C10BB  = { t="metals/m_hl_c10bb" }
M_HL_C10C  = { t="metals/m_hl_c10c" }
M_HL_C10E  = { t="metals/m_hl_c10e" }
M_HL_C10EA  = { t="metals/m_hl_c10ea" }
M_HL_C10FA  = { t="metals/m_hl_c10fa" }
M_HL_C10FA2  = { t="metals/m_hl_c10fa2" }
M_HL_C10FB  = { t="metals/m_hl_c10fb" }
M_HL_C10FY2  = { t="metals/m_hl_c10fy2" }
M_HL_C10H  = { t="metals/m_hl_c10h" }
M_HL_C10M  = { t="metals/m_hl_c10m" }
M_HL_C10MA  = { t="metals/m_hl_c10ma" }
M_HL_C11B  = { t="metals/m_hl_c11b" }
M_HL_C17  = { t="metals/m_hl_c17" }
M_HL_C21  = { t="metals/m_hl_c21" }
M_HL_C23  = { t="metals/m_hl_c23" }
M_MF_V1  = { t="metals/m_mf_v1" }
M_MF_V2  = { t="metals/m_mf_v2" }
M_MF_V2A  = { t="metals/m_mf_v2a" }
M_MF_V2B  = { t="metals/m_mf_v2b" }
M_MF_V3  = { t="metals/m_mf_v3" }
M_PV_V2  = { t="metals/m_pv_v2" }
M_PV_V2Y  = { t="metals/m_pv_v2y" }
M_PV_V3  = { t="metals/m_pv_v3" }
M_PV_V4  = { t="metals/m_pv_v4" }
M_PV_V4A  = { t="metals/m_pv_v4a" }
M_PV_V5  = { t="metals/m_pv_v5" }
M_PV_V6  = { t="metals/m_pv_v6" }
M_PV_V9  = { t="metals/m_pv_v9" }
M_RC_V4  = { t="metals/m_rc_v4" }
TK_RC_C01  = { t="metals/tk_rc_c01" }
TK_RC_C02  = { t="metals/tk_rc_c02" }

AC_FRONT  = { t="props/ac_front" }
BARREL_V1  = { t="props/barrel_v1" }
BARREL_V2  = { t="props/barrel_v2" }
BARREL_V2T  = { t="props/barrel_v2t" }
BARREL_V3  = { t="props/barrel_v3" }
BARREL_V3T  = { t="props/barrel_v3t" }
BARREL_V4  = { t="props/barrel_v4" }
BARREL_V5  = { t="props/barrel_v5" }
BLD_RC_C1  = { t="props/bld_rc_c1" }
BLD_RC_C10  = { t="props/bld_rc_c10" }
BLD_RC_C11  = { t="props/bld_rc_c11" }
BLD_RC_C2  = { t="props/bld_rc_c2" }
BLD_RC_C3  = { t="props/bld_rc_c3" }
BLD_RC_C4  = { t="props/bld_rc_c4" }
BLD_RC_C5  = { t="props/bld_rc_c5" }
BLD_RC_C6  = { t="props/bld_rc_c6" }
BLD_RC_C8A  = { t="props/bld_rc_c8a" }
BLD_SR_C1  = { t="props/bld_sr_c1" }
BLD_SR_C1A  = { t="props/bld_sr_c1a" }
BLD_SR_C2  = { t="props/bld_sr_c2" }
BLD_SR_C5  = { t="props/bld_sr_c5" }
BL_RC_C02  = { t="props/bl_rc_c02" }
BL_RC_C03  = { t="props/bl_rc_c03" }
BL_RC_C05  = { t="props/bl_rc_c05" }
BL_RC_C08  = { t="props/bl_rc_c08" }
BL_RC_C09B  = { t="props/bl_rc_c09b" }
BL_RC_C10  = { t="props/bl_rc_c10" }
BL_RC_C11  = { t="props/bl_rc_c11" }
BL_RC_C12  = { t="props/bl_rc_c12" }
BL_RC_C13  = { t="props/bl_rc_c13" }
BL_RC_C14  = { t="props/bl_rc_c14" }
BL_RC_C15  = { t="props/bl_rc_c15" }
BL_RC_C17  = { t="props/bl_rc_c17" }
BL_RC_C18  = { t="props/bl_rc_c18" }
BL_RC_C20  = { t="props/bl_rc_c20" }
BL_RC_C24  = { t="props/bl_rc_c24" }
BL_RC_C25  = { t="props/bl_rc_c25" }
BL_RC_C30  = { t="props/bl_rc_c30" }
BOOK_V  = { t="props/book_v" }
BOX_C_M4  = { t="props/box_c_m4" }
BOX_C_M5  = { t="props/box_c_m5" }
BOX_C_M6  = { t="props/box_c_m6" }
BOX_SR_M10  = { t="props/box_sr_m10" }
BOX_SR_M11  = { t="props/box_sr_m11" }
BOX_SR_M12  = { t="props/box_sr_m12" }
BOX_SR_M13  = { t="props/box_sr_m13" }
BOX_SR_M14  = { t="props/box_sr_m14" }
BOX_SR_M15  = { t="props/box_sr_m15" }
BOX_SR_M19  = { t="props/box_sr_m19" }
BOX_SR_M5  = { t="props/box_sr_m5" }
BOX_SR_M6  = { t="props/box_sr_m6" }
BOX_SR_M6S  = { t="props/box_sr_m6s" }
BOX_SR_M6SA  = { t="props/box_sr_m6sa" }
BOX_SR_M6SAB  = { t="props/box_sr_m6sab" }
BOX_SR_M7A  = { t="props/box_sr_m7a" }
BOX_SR_M7B  = { t="props/box_sr_m7b" }
BOX_SR_M8  = { t="props/box_sr_m8" }
BOX_SR_M9  = { t="props/box_sr_m9" }
BOX_W_M1  = { t="props/box_w_m1" }
BOX_W_M1A  = { t="props/box_w_m1a" }
BOX_W_M2  = { t="props/box_w_m2" }
BOX_W_M5  = { t="props/box_w_m5" }
BO_PV_C1  = { t="props/bo_pv_c1" }
BO_PV_C2  = { t="props/bo_pv_c2" }
BO_PV_C3  = { t="props/bo_pv_c3" }
B_RC_C03  = { t="props/b_rc_c03" }
CALLBOX  = { t="props/callbox" }
CALLBOX4  = { t="props/callbox4" }
CALLBOX_G  = { t="props/callbox_g" }
CHALK_L2  = { t="props/chalk_l2" }
CL_RC_C1  = { t="props/cl_rc_c1" }
DUMP_M1A  = { t="props/dump_m1a" }
DUMP_M2A  = { t="props/dump_m2a" }
DUMP_M3  = { t="props/dump_m3" }
DUMP_M4  = { t="props/dump_m4" }
DUMP_M4A  = { t="props/dump_m4a" }
EN_RC_C1  = { t="props/en_rc_c1" }
EN_RC_C10  = { t="props/en_rc_c10" }
EN_RC_C11  = { t="props/en_rc_c11" }
EN_RC_C2  = { t="props/en_rc_c2" }
EN_RC_C3  = { t="props/en_rc_c3" }
EN_RC_C4  = { t="props/en_rc_c4" }
EN_RC_C5  = { t="props/en_rc_c5" }
EN_RC_C6  = { t="props/en_rc_c6" }
EN_RC_C8  = { t="props/en_rc_c8" }
EN_RC_C9  = { t="props/en_rc_c9" }
FILEC_M1  = { t="props/filec_m1" }
FILEC_M2  = { t="props/filec_m2" }
FIRE_V1  = { t="props/fire_v1" }
FR_RC_C1  = { t="props/fr_rc_c1" }
FR_RC_C11  = { t="props/fr_rc_c11" }
FR_RC_C12  = { t="props/fr_rc_c12" }
FR_RC_C14  = { t="props/fr_rc_c14" }
FR_RC_C15  = { t="props/fr_rc_c15" }
FR_RC_C16  = { t="props/fr_rc_c16" }
FR_RC_C17  = { t="props/fr_rc_c17" }
FR_RC_C18  = { t="props/fr_rc_c18" }
FR_RC_C1B  = { t="props/fr_rc_c1b" }
FR_RC_C2  = { t="props/fr_rc_c2" }
FR_RC_C20A  = { t="props/fr_rc_c20a" }
FR_RC_C20B  = { t="props/fr_rc_c20b" }
FR_RC_C20D  = { t="props/fr_rc_c20d" }
FR_RC_C20E  = { t="props/fr_rc_c20e" }
FR_RC_C21  = { t="props/fr_rc_c21" }
FR_RC_C22  = { t="props/fr_rc_c22" }
FR_RC_C22A  = { t="props/fr_rc_c22a" }
FR_RC_C23  = { t="props/fr_rc_c23" }
FR_RC_C24  = { t="props/fr_rc_c24" }
FR_RC_C25  = { t="props/fr_rc_c25" }
FR_RC_C25A  = { t="props/fr_rc_c25a" }
FR_RC_C3  = { t="props/fr_rc_c3" }
FR_RC_C4  = { t="props/fr_rc_c4" }
FR_RC_C5  = { t="props/fr_rc_c5" }
FR_RC_C6  = { t="props/fr_rc_c6" }
FR_RC_C7  = { t="props/fr_rc_c7" }
FR_RC_C7A  = { t="props/fr_rc_c7a" }
HOUSE_V1  = { t="props/house_v1" }
LIGHTBULB  = { t="props/lightbulb" }
LOCKER_M1  = { t="props/locker_m1" }
LOCKER_M1A  = { t="props/locker_m1a" }
LOCKER_M1B  = { t="props/locker_m1b" }
LUG_RC_C1  = { t="props/lug_rc_c1" }
LUG_RC_C1A  = { t="props/lug_rc_c1a" }
LUG_RC_C2  = { t="props/lug_rc_c2" }
MA_RC_C1  = { t="props/ma_rc_c1" }
MA_RC_C2  = { t="props/ma_rc_c2" }
MA_RC_C4  = { t="props/ma_rc_c4" }
MT_SR_MN3B  = { t="props/mt_sr_mn3b" }
NE_RC_C05  = { t="props/ne_rc_c05" }
NP_RC_C02  = { t="props/np_rc_c02" }
NP_RC_C03  = { t="props/np_rc_c03" }
PAWN_S  = { t="props/pawn_s" }
PAWN_S1  = { t="props/pawn_s1" }
PAWN_SB  = { t="props/pawn_sb" }
PA_CA_C01  = { t="props/pa_ca_c01" }
PA_CA_C02  = { t="props/pa_ca_c02" }
PA_CA_C03  = { t="props/pa_ca_c03" }
PA_CA_C04  = { t="props/pa_ca_c04" }
PIPE1  = { t="props/pipe1" }
PIPE1_B_M1  = { t="props/pipe1_b_m1" }
PIPE1_G_M1  = { t="props/pipe1_g_m1" }
PIPE1_R_M1  = { t="props/pipe1_r_m1" }
PI_RC_C2  = { t="props/pi_rc_c2" }
POSTER1  = { t="props/poster1" }
POST_RC_V  = { t="props/post_rc_v" }
RAIL_3  = { t="props/rail_3" }
RAIL_RC_C01  = { t="props/rail_rc_c01" }
SAFE  = { t="props/safe" }
SAFE_L  = { t="props/safe_l" }
SAFE_W  = { t="props/safe_w" }
SCH_RC_C1  = { t="props/sch_rc_c1" }
SCH_RC_C2  = { t="props/sch_rc_c2" }
SG_RC_C06  = { t="props/sg_rc_c06" }
SG_SR_2A  = { t="props/sg_sr_2a" }
SG_SR_B3  = { t="props/sg_sr_b3" }
SG_SR_BA2  = { t="props/sg_sr_ba2" }
SG_SR_BA3  = { t="props/sg_sr_ba3" }
SG_SR_BA4  = { t="props/sg_sr_ba4" }
SG_SR_C01B  = { t="props/sg_sr_c01b" }
SG_SR_C02B  = { t="props/sg_sr_c02b" }
SG_SR_C03B  = { t="props/sg_sr_c03b" }
SG_SR_C04B  = { t="props/sg_sr_c04b" }
SG_SR_C05  = { t="props/sg_sr_c05" }
SG_SR_M5  = { t="props/sg_sr_m5" }
SG_SR_MN1  = { t="props/sg_sr_mn1" }
SG_SR_MN10  = { t="props/sg_sr_mn10" }
SG_SR_MN7  = { t="props/sg_sr_mn7" }
SG_SR_MN9  = { t="props/sg_sr_mn9" }
SG_SR_V1A  = { t="props/sg_sr_v1a" }
SG_SR_V1C  = { t="props/sg_sr_v1c" }
SG_SR_V1F  = { t="props/sg_sr_v1f" }
SG_ST_C01  = { t="props/sg_st_c01" }
SH_RC_C02  = { t="props/sh_rc_c02" }
SH_RC_C02C  = { t="props/sh_rc_c02c" }
SH_RC_C02D  = { t="props/sh_rc_c02d" }
SH_RC_C02F  = { t="props/sh_rc_c02f" }
SIGN_V1  = { t="props/sign_v1" }
SIGN_V2  = { t="props/sign_v2" }
SI_BA_C01  = { t="props/si_ba_c01" }
SI_B_M1  = { t="props/si_b_m1" }
SI_B_M1A  = { t="props/si_b_m1a" }
SI_RC_C01  = { t="props/si_rc_c01" }
SI_RC_C01B  = { t="props/si_rc_c01b" }
SI_RC_C02B  = { t="props/si_rc_c02b" }
SI_RC_C07  = { t="props/si_rc_c07" }
SI_RC_C12  = { t="props/si_rc_c12" }
SI_RC_C13  = { t="props/si_rc_c13" }
SI_RC_C14  = { t="props/si_rc_c14" }
SI_RC_C16  = { t="props/si_rc_c16" }
SI_RC_N1  = { t="props/si_rc_n1" }
SI_RC_N2  = { t="props/si_rc_n2" }
SI_RC_N3  = { t="props/si_rc_n3" }
SI_RC_N4  = { t="props/si_rc_n4" }
SI_ST_C02  = { t="props/si_st_c02" }
SI_ST_C04  = { t="props/si_st_c04" }
SI_ST_C06  = { t="props/si_st_c06" }
SI_ST_C07  = { t="props/si_st_c07" }
SI_ST_C09  = { t="props/si_st_c09" }
SI_SW_M1  = { t="props/si_sw_m1" }
SI_SW_M2  = { t="props/si_sw_m2" }
SI_SW_M3  = { t="props/si_sw_m3" }
SI_SW_M4  = { t="props/si_sw_m4" }
SI_SW_M5  = { t="props/si_sw_m5" }
SI_SW_M6  = { t="props/si_sw_m6" }
SPIDER_TEST  = { t="props/spider_test" }
STOOL_T  = { t="props/stool_t" }
STOOL_T2  = { t="props/stool_t2" }
STOOL_T3  = { t="props/stool_t3" }
STOOL_T4  = { t="props/stool_t4" }
STOOL_T5  = { t="props/stool_t5" }
TRACK1  = { t="props/track1" }
TRACK2  = { t="props/track2" }
TRACK3  = { t="props/track3" }
TRACK4  = { t="props/track4" }
TR_RD_11  = { t="props/tr_rd_11" }
TR_RD_12  = { t="props/tr_rd_12" }
TR_RD_12A  = { t="props/tr_rd_12a" }
TR_RD_12B  = { t="props/tr_rd_12b" }
TR_RD_13  = { t="props/tr_rd_13" }
TR_RD_13A  = { t="props/tr_rd_13a" }
TR_RD_13BLUR  = { t="props/tr_rd_13blur" }
TR_RD_13BOLD  = { t="props/tr_rd_13bold" }
TR_RD_14  = { t="props/tr_rd_14" }
TR_RD_14A  = { t="props/tr_rd_14a" }
TR_RD_3  = { t="props/tr_rd_3" }
TR_RD_4  = { t="props/tr_rd_4" }
TR_RD_5  = { t="props/tr_rd_5" }
TR_RD_6  = { t="props/tr_rd_6" }
TR_RD_7  = { t="props/tr_rd_7" }
W_CP_V1  = { t="props/w_cp_v1" }
W_RC_V1  = { t="props/w_rc_v1" }
W_RC_V3  = { t="props/w_rc_v3" }
W_SR_B10  = { t="props/w_sr_b10" }
W_SR_B11  = { t="props/w_sr_b11" }
W_SR_B15  = { t="props/w_sr_b15" }
W_SR_B15B  = { t="props/w_sr_b15b" }
W_SR_B16  = { t="props/w_sr_b16" }
W_SR_B16A  = { t="props/w_sr_b16a" }
W_SR_B17  = { t="props/w_sr_b17" }
W_SR_B21  = { t="props/w_sr_b21" }
W_SR_B24  = { t="props/w_sr_b24" }
W_SR_B25  = { t="props/w_sr_b25" }
W_SR_BA12  = { t="props/w_sr_ba12" }
W_SR_BA7B  = { t="props/w_sr_ba7b" }
W_SR_BA7C  = { t="props/w_sr_ba7c" }
W_SR_BA8  = { t="props/w_sr_ba8" }
W_SR_BA9  = { t="props/w_sr_ba9" }
W_SR_BA9A  = { t="props/w_sr_ba9a" }
W_SR_M1A  = { t="props/w_sr_m1a" }
W_SR_M2A  = { t="props/w_sr_m2a" }
W_SR_M3A  = { t="props/w_sr_m3a" }
W_SR_M4A  = { t="props/w_sr_m4a" }
W_SR_M6A  = { t="props/w_sr_m6a" }
W_SR_M6B  = { t="props/w_sr_m6b" }
W_SR_M6D  = { t="props/w_sr_m6d" }
W_SR_M6E  = { t="props/w_sr_m6e" }
W_SR_M6F  = { t="props/w_sr_m6f" }
W_SR_M6X  = { t="props/w_sr_m6x" }
W_SR_M6Y  = { t="props/w_sr_m6y" }
W_SR_V1  = { t="props/w_sr_v1" }
W_SR_V2  = { t="props/w_sr_v2" }
W_ST_M1  = { t="props/w_st_m1" }
W_ST_M2  = { t="props/w_st_m2" }
W_ST_M4  = { t="props/w_st_m4" }
W_ST_M4S  = { t="props/w_st_m4s" }

--+1NE_RC_C10  = { t="props2/+1ne_rc_c10" }
--+2NE_RC_C10  = { t="props2/+2ne_rc_c10" }
BACK_IN10_SIGN  = { t="props2/back_in10_sign" }
BAIT_V1  = { t="props2/bait_v1" }
BARREL_V6  = { t="props2/barrel_v6" }
BARREL_V6A  = { t="props2/barrel_v6a" }
BARREL_V7  = { t="props2/barrel_v7" }
BAR_V1  = { t="props2/bar_v1" }
BENT_01  = { t="props2/bent_01" }
BENT_02  = { t="props2/bent_02" }
BENT_03  = { t="props2/bent_03" }
BENT_04  = { t="props2/bent_04" }
BLANCO_SIGN  = { t="props2/blanco_sign" }
BLANCO_SIGN2  = { t="props2/blanco_sign2" }
BLANCO_SIGN3  = { t="props2/blanco_sign3" }
BLANCO_V1  = { t="props2/blanco_v1" }
BLANCO_V2  = { t="props2/blanco_v2" }
BLANCO_V3  = { t="props2/blanco_v3" }
BLOOD_V1  = { t="props2/blood_v1" }
BLUEPRINT  = { t="props2/blueprint" }
BLUEPRINT_PIC  = { t="props2/blueprint_pic" }
BL_RC_C09B  = { t="props2/bl_rc_c09b" }
BL_RC_C09BY  = { t="props2/bl_rc_c09by" }
BL_RC_C10Y  = { t="props2/bl_rc_c10y" }
BL_RC_C14Y  = { t="props2/bl_rc_c14y" }
BL_RC_C15Y  = { t="props2/bl_rc_c15y" }
BL_RC_C18A  = { t="props2/bl_rc_c18a" }
BL_RC_C18B  = { t="props2/bl_rc_c18b" }
BL_RC_C28  = { t="props2/bl_rc_c28" }
BOARD_V  = { t="props2/board_v" }
BOARD_V1  = { t="props2/board_v1" }
BOILER_V1  = { t="props2/boiler_v1" }
BOOK_C02  = { t="props2/book_c02" }
BOOK_C02L  = { t="props2/book_c02l" }
BOOK_C03  = { t="props2/book_c03" }
BOOTH_M1  = { t="props2/booth_m1" }
BOTTLE_C01  = { t="props2/bottle_c01" }
BOTTLE_C02  = { t="props2/bottle_c02" }
BOTTLE_C03  = { t="props2/bottle_c03" }
BR_ST_M3C  = { t="props2/br_st_m3c" }
BR_ST_M3D  = { t="props2/br_st_m3d" }
BR_ST_M3E  = { t="props2/br_st_m3e" }
BR_ST_M3F  = { t="props2/br_st_m3f" }
B_BIL_C01  = { t="props2/b_bil_c01" }
B_RC_V4X  = { t="props2/b_rc_v4x" }
B_RC_V4Y  = { t="props2/b_rc_v4y" }
CALENDAR  = { t="props2/calendar" }
CAR2_01  = { t="props2/car2_01" }
CAR2_02  = { t="props2/car2_02" }
CAR2_03  = { t="props2/car2_03" }
CAR2_04  = { t="props2/car2_04" }
CARPET_03  = { t="props2/carpet_03" }
CAR_01  = { t="props2/car_01" }
CAR_02  = { t="props2/car_02" }
CAR_03  = { t="props2/car_03" }
CAR_04  = { t="props2/car_04" }
CAR_C01  = { t="props2/Car_c01" }
CAR_C01A  = { t="props2/Car_c01a" }
CAR_C01B  = { t="props2/Car_c01b" }
CAR_C01C  = { t="props2/Car_c01c" }
CENTRAL_V1  = { t="props2/central_v1" }
CHINA  = { t="props2/china" }
CHINA2  = { t="props2/china2" }
CHINA3  = { t="props2/china3" }
CHINA4  = { t="props2/china4" }
CR_GA_C02  = { t="props2/cr_ga_c02" }
CT_ST_C01Y  = { t="props2/ct_st_c01y" }
CT_ST_C02  = { t="props2/ct_st_c02" }
DANGER_SI  = { t="props2/danger_si" }
DEISEL_SIGN  = { t="props2/deisel_sign" }
DESK1  = { t="props2/desk1" }
DESK2  = { t="props2/desk2" }
DESK3  = { t="props2/desk3" }
DESK_TOP  = { t="props2/desk_top" }
DRAGON  = { t="props2/dragon" }
DRAGON2  = { t="props2/dragon2" }
DRAGON3  = { t="props2/dragon3" }
DRAGON4  = { t="props2/dragon4" }
DRAGON_V1  = { t="props2/dragon_v1" }
DRAGON_VX  = { t="props2/dragon_vx" }
DRAGON_VY  = { t="props2/dragon_vy" }
DRAGON_VZ  = { t="props2/dragon_vz" }
EN_RC_C3MS  = { t="props2/en_rc_c3ms" }
FRIDG1  = { t="props2/fridg1" }
FRIDG1A  = { t="props2/fridg1a" }
FRIDG2  = { t="props2/fridg2" }
FRIDG2A  = { t="props2/fridg2a" }
FRIDG3A  = { t="props2/fridg3a" }
FRIDG4  = { t="props2/fridg4" }
FRIDG4A  = { t="props2/fridg4a" }
FR_RC_C7A  = { t="props2/fr_rc_c7a" }
FUSE_BOX  = { t="props2/fuse_box" }
GUN_M1  = { t="props2/gun_m1" }
GUN_V1  = { t="props2/gun_v1" }
GUN_V2  = { t="props2/gun_v2" }
HELI1  = { t="props2/heli1" }
HELI2  = { t="props2/heli2" }
HELI3  = { t="props2/heli3" }
HELI4  = { t="props2/heli4" }
JOINT_ST  = { t="props2/joint_st" }
LAWYER_1V  = { t="props2/lawyer_1v" }
MAINSTRT  = { t="props2/mainstrt" }
MAP_02  = { t="props2/map_02" }
ME_HL_C31  = { t="props2/me_hl_c31" }
ME_HL_C31A  = { t="props2/me_hl_c31a" }
MOKER_BSIGN  = { t="props2/moker_bsign" }
MOKER_SIGNA  = { t="props2/moker_signa" }
MR_RC_C01A  = { t="props2/mr_rc_c01a" }
MR_RC_C02  = { t="props2/mr_rc_c02" }
MR_RC_C02A  = { t="props2/mr_rc_c02a" }
MR_RC_C03  = { t="props2/mr_rc_c03" }
MR_RC_C03A  = { t="props2/mr_rc_c03a" }
MR_RC_C04  = { t="props2/mr_rc_c04" }
MR_RC_C05  = { t="props2/mr_rc_c05" }
M_HL_C14  = { t="props2/m_hl_c14" }
M_RC_C02  = { t="props2/m_rc_c02" }
M_RC_C03  = { t="props2/m_rc_c03" }
NE_CON1  = { t="props2/ne_con1" }
NE_CON1A  = { t="props2/ne_con1a" }
NE_CON1B  = { t="props2/ne_con1b" }
NE_CON1B2  = { t="props2/ne_con1b2" }
NE_CON1B3  = { t="props2/ne_con1b3" }
NE_CON1Y2  = { t="props2/ne_con1y2" }
NE_CON1YB  = { t="props2/ne_con1yb" }
NE_PV_C01  = { t="props2/ne_pv_C01" }
NE_PV_C02  = { t="props2/ne_pv_C02" }
NE_PV_C02B  = { t="props2/ne_pv_C02b" }
NE_PV_C03  = { t="props2/ne_pv_C03" }
NE_RC_C04  = { t="props2/ne_rc_c04" }
NE_RC_C04B  = { t="props2/ne_rc_c04b" }
NE_RC_C07  = { t="props2/ne_rc_c07" }
NE_RC_C07A  = { t="props2/ne_rc_c07a" }
NE_RC_C07C  = { t="props2/ne_rc_c07c" }
NE_RC_C08  = { t="props2/ne_rc_c08" }
NE_RC_C09  = { t="props2/ne_rc_c09" }
NE_RC_C10  = { t="props2/ne_rc_c10" }
NO_CLIMB_SIGN  = { t="props2/no_climb_sign" }
NP_RC_C03  = { t="props2/np_rc_c03" }
NP_ST_C01  = { t="props2/np_st_c01" }
NP_ST_C02  = { t="props2/np_st_c02" }
NP_ST_C03  = { t="props2/np_st_c03" }
NP_ST_C04  = { t="props2/np_st_c04" }
OFFICE_C01  = { t="props2/office_c01" }
OFFICE_C02  = { t="props2/office_c02" }
OFFICE_C03  = { t="props2/office_c03" }
OFFICE_C04  = { t="props2/office_c04" }
PANEL_C01  = { t="props2/panel_c01" }
PANEL_C02  = { t="props2/panel_c02" }
PHONE  = { t="props2/phone" }
PICTURE_01  = { t="props2/picture_01" }
PICTURE_02  = { t="props2/picture_02" }
PICTURE_03  = { t="props2/picture_03" }
PICTURE_05  = { t="props2/picture_05" }
PICTURE_V1  = { t="props2/picture_v1" }
PINBALL  = { t="props2/pinball" }
PINBALL2  = { t="props2/pinball2" }
PINBALL3  = { t="props2/pinball3" }
POSTER_01A  = { t="props2/poster_01a" }
POSTER_02  = { t="props2/poster_02" }
POSTER_03  = { t="props2/poster_03" }
PROPWALL  = { t="props2/propwall" }
SAFE_B  = { t="props2/safe_b" }
SAFE_WA  = { t="props2/safe_wa" }
SAIL_V  = { t="props2/sail_v" }
SG_ST_V1  = { t="props2/sg_st_v1" }
SH_RC_C02F  = { t="props2/sh_rc_c02f" }
SIGN_V1  = { t="props2/sign_v1" }
SIGN_V1X  = { t="props2/sign_v1x" }
SIGN_V1Y  = { t="props2/sign_v1y" }
SIGN_V1Z  = { t="props2/sign_v1z" }
SIGN_V2  = { t="props2/sign_v2" }
SI_A  = { t="props2/si_a" }
SI_BUS  = { t="props2/si_bus" }
SI_GRAF1  = { t="props2/si_graf1" }
SI_LH_C01  = { t="props2/si_lh_c01" }
SI_LH_C02  = { t="props2/si_lh_c02" }
SI_LH_C03  = { t="props2/si_lh_c03" }
SI_RC_C20  = { t="props2/si_rc_c20" }
SI_RC_C21  = { t="props2/si_rc_c21" }
SI_SCORP1  = { t="props2/si_scorp1" }
SI_SCORP2  = { t="props2/si_scorp2" }
SI_SCORP5  = { t="props2/si_scorp5" }
SI_SEWER1  = { t="props2/si_sewer1" }
SI_SEWER2  = { t="props2/si_sewer2" }
SI_SR_M2CC  = { t="props2/si_sr_m2cc" }
SI_SR_M3CC  = { t="props2/si_sr_m3cc" }
SI_ST_M1A  = { t="props2/si_st_m1a" }
SI_ST_M1B  = { t="props2/si_st_m1b" }
SI_ST_M2A  = { t="props2/si_st_m2a" }
SI_ST_M2B  = { t="props2/si_st_m2b" }
SI_ST_M3  = { t="props2/si_st_m3" }
SI_ST_M3A  = { t="props2/si_st_m3a" }
SI_ST_M4  = { t="props2/si_st_m4" }
SMOKE_V1  = { t="props2/smoke_v1" }
SPEAKER1  = { t="props2/speaker1" }
STAND_V1  = { t="props2/stand_v1" }
STOOL_T5  = { t="props2/stool_t5" }
STOOL_T6  = { t="props2/stool_t6" }
STOVE_PV_V  = { t="props2/stove_pv_v" }
STOVE_PV_V2  = { t="props2/stove_pv_v2" }
STOVE_PV_V3  = { t="props2/stove_pv_v3" }
STOVE_PV_V4  = { t="props2/stove_pv_v4" }
SWANK  = { t="props2/swank" }
SWANK2  = { t="props2/swank2" }
SWANK3  = { t="props2/swank3" }
TANK1  = { t="props2/tank1" }
TANK2  = { t="props2/tank2" }
TANK3  = { t="props2/tank3" }
TANK4  = { t="props2/tank4" }
TANK5  = { t="props2/tank5" }
TIRE_V1  = { t="props2/tire_v1" }
TIRE_V2  = { t="props2/tire_v2" }
TK_RC_C01A  = { t="props2/tk_rc_c01a" }
TK_RC_C02A  = { t="props2/tk_rc_c02a" }
TRUCK_V1  = { t="props2/truck_v1" }
TRUCK_V1A  = { t="props2/truck_v1a" }
TR_RD_13MS  = { t="props2/tr_rd_13ms" }
TYPHOON  = { t="props2/typhoon" }
WI_RC_C01  = { t="props2/wi_rc_c01" }
W_RCB_V1  = { t="props2/w_rcb_v1" }
W_SY_V1  = { t="props2/w_sy_v1" }
W_SY_V2  = { t="props2/w_sy_v2" }
W_SY_V3  = { t="props2/w_sy_v3" }

PV_G10  = { t="pvglass/pv_g10" }
PV_G10Y  = { t="pvglass/pv_g10y" }
PV_G2  = { t="pvglass/pv_g2" }
PV_G5  = { t="pvglass/pv_g5" }
PV_G6  = { t="pvglass/pv_g6" }
PV_G8  = { t="pvglass/pv_g8" }
PV_G9  = { t="pvglass/pv_g9" }
W_SR_M6B  = { t="pvglass/w_sr_m6b" }

ALFA_V1  = { t="sprites/alfa_v1" }
BARS  = { t="sprites/bars" }
BARS_V1  = { t="sprites/bars_v1" }
BLOOD_V1  = { t="sprites/blood_v1" }
CHAIN_SR  = { t="sprites/chain_sr" }
CHAIN_V2  = { t="sprites/chain_v2" }
FENC_M  = { t="sprites/fenc_m" }
FENC_MD  = { t="sprites/fenc_md" }
FENC_MS  = { t="sprites/fenc_ms" }
GRATE_A_M1A  = { t="sprites/grate_a_m1a" }
HOLE_V1  = { t="sprites/hole_v1" }
HOLE_V2  = { t="sprites/hole_v2" }
HOLE_V2D  = { t="sprites/hole_v2d" }
MB_GRATE_1  = { t="sprites/mb_grate_1" }
MB_GRATE_2  = { t="sprites/mb_grate_2" }
MB_GRATE_3  = { t="sprites/mb_grate_3" }
MT_PV_V7  = { t="sprites/mt_pv_v7" }
MT_PV_V7A  = { t="sprites/mt_pv_v7a" }
MT_PV_V7B  = { t="sprites/mt_pv_v7b" }
M_RC_C02  = { t="sprites/m_rc_c02" }
M_RC_C02A  = { t="sprites/m_rc_c02a" }
M_RC_V3  = { t="sprites/m_rc_v3" }
M_RC_V5  = { t="sprites/m_rc_v5" }
M_RC_V6  = { t="sprites/m_rc_v6" }
PIPES_V1  = { t="sprites/pipes_v1" }
RAIL_C03  = { t="sprites/rail_c03" }
RAIL_C2  = { t="sprites/rail_c2" }
RAIL_C2A  = { t="sprites/rail_c2a" }
RAIL_C2B  = { t="sprites/rail_c2b" }
RAIL_C2BY  = { t="sprites/rail_c2by" }
RAIL_C2C  = { t="sprites/rail_c2c" }
RAIL_RC_C01  = { t="sprites/rail_rc_c01" }
RAIL_SR_M1  = { t="sprites/rail_sr_m1" }
RAIL_V1  = { t="sprites/rail_v1" }
RAIL_V2  = { t="sprites/rail_v2" }
RAIL_V3  = { t="sprites/rail_v3" }
RAIL_V4  = { t="sprites/rail_v4" }
SKYLN_M1  = { t="sprites/skyln_m1" }
WIN_BARS  = { t="sprites/win_bars" }
WIR_MF_V1  = { t="sprites/wir_mf_v1" }
WIR_MF_V1A  = { t="sprites/wir_mf_v1a" }
WIR_MF_V1AD  = { t="sprites/wir_mf_v1ad" }

GROUND_ST  = { t="terrain/ground_st" }
GR_RC_C08  = { t="terrain/gr_rc_c08" }
RC_RC_C4  = { t="terrain/rc_rc_c4" }
RC_RC_C6  = { t="terrain/rc_rc_c6" }
RC_RC_C6A  = { t="terrain/rc_rc_c6a" }
RC_RC_C6A_2  = { t="terrain/rc_rc_c6a_2" }
RC_RC_C7  = { t="terrain/rc_rc_c7" }
TREE_C02  = { t="terrain/tree_c02" }

WD_B_M2  = { t="wood/wd_b_m2" }
WD_CP_V  = { t="wood/wd_cp_v" }
WD_CP_V2  = { t="wood/wd_cp_v2" }
WD_CP_V3  = { t="wood/wd_cp_v3" }
WD_CP_V4  = { t="wood/wd_cp_v4" }
WD_CP_V5  = { t="wood/wd_cp_v5" }
WD_HL_V3  = { t="wood/wd_hl_v3" }
WD_HL_V3B  = { t="wood/wd_hl_v3b" }
WD_HL_V3D  = { t="wood/wd_hl_v3d" }
WD_HL_V3E  = { t="wood/wd_hl_v3e" }
WD_HL_V4  = { t="wood/wd_hl_v4" }
WD_HL_V4A  = { t="wood/wd_hl_v4a" }
WD_HL_V4F  = { t="wood/wd_hl_v4f" }
WD_SR_C02  = { t="wood/wd_sr_c02" }
WD_SR_M11  = { t="wood/wd_sr_m11" }
WD_SR_M14  = { t="wood/wd_sr_m14" }
WD_SR_M14N  = { t="wood/wd_sr_m14n" }
WD_SR_M3A  = { t="wood/wd_sr_m3a" }
WD_SR_M3B  = { t="wood/wd_sr_m3b" }
WD_SR_M3C  = { t="wood/wd_sr_m3c" }
WD_SR_M3T  = { t="wood/wd_sr_m3t" }
WD_SR_M3X  = { t="wood/wd_sr_m3x" }
WD_SR_M3Y  = { t="wood/wd_sr_m3y" }
WD_SR_M3Z  = { t="wood/wd_sr_m3z" }
WD_SR_M4  = { t="wood/wd_sr_m4" }
WD_SR_M9  = { t="wood/wd_sr_m9" }
WD_SR_V1  = { t="wood/wd_sr_v1" }
WD_SR_V11  = { t="wood/wd_sr_v11" }
WD_SR_V13  = { t="wood/wd_sr_v13" }
WD_SR_V14  = { t="wood/wd_sr_v14" }
WD_SR_V2  = { t="wood/wd_sr_v2" }
WD_SR_V3  = { t="wood/wd_sr_v3" }
WD_SR_V3A  = { t="wood/wd_sr_v3a" }
WD_SR_V3AA  = { t="wood/wd_sr_v3aa" }
WD_SR_V3AB  = { t="wood/wd_sr_v3ab" }
WD_SR_V8  = { t="wood/wd_sr_v8" }
WD_SR_VA1  = { t="wood/wd_sr_va1" }
WD_SR_VA2  = { t="wood/wd_sr_va2" }
WD_SR_VA2A  = { t="wood/wd_sr_va2a" }
WD_SR_VA2AA  = { t="wood/wd_sr_va2aa" }
WD_SR_VA2B  = { t="wood/wd_sr_va2b" }
WD_SR_VA2C  = { t="wood/wd_sr_va2c" }
WD_SR_VA2D  = { t="wood/wd_sr_va2d" }
WD_SR_VA2E  = { t="wood/wd_sr_va2e" }
WD_SR_VA3  = { t="wood/wd_sr_va3" }
WD_SR_VA4  = { t="wood/wd_sr_va4" }
WD_SR_VA6  = { t="wood/wd_sr_va6" }
WD_SR_VA7  = { t="wood/wd_sr_va7" }
WD_SR_VY2  = { t="wood/wd_sr_vy2" }
WD_ST_C02  = { t="wood/wd_st_c02" }
WD_ST_C02N  = { t="wood/wd_st_c02n" }
WD_ST_C02NA  = { t="wood/wd_st_c02na" }
WD_ST_C02NB  = { t="wood/wd_st_c02nb" }
WD_ST_C03  = { t="wood/wd_st_c03" }
WD_ST_C04  = { t="wood/wd_st_c04" }
WD_ST_C04A  = { t="wood/wd_st_c04a" }
WD_ST_C04B  = { t="wood/wd_st_c04b" }
WD_ST_C04BB  = { t="wood/wd_st_c04bb" }
WD_ST_C04D  = { t="wood/wd_st_c04d" }
WD_ST_C05  = { t="wood/wd_st_c05" }
WD_ST_C06  = { t="wood/wd_st_c06" }
WD_ST_M1  = { t="wood/wd_st_m1" }
WD_ST_M1B  = { t="wood/wd_st_m1b" }
WD_ST_M1D  = { t="wood/wd_st_m1d" }
WD_ST_M2  = { t="wood/wd_st_m2" }
WD_ST_M3  = { t="wood/wd_st_m3" }
WD_ST_M3S  = { t="wood/wd_st_m3s" }
WD_ST_M4  = { t="wood/wd_st_m4" }
WD_ST_M4D  = { t="wood/wd_st_m4d" }
WD_ST_M7  = { t="wood/wd_st_m7" }
WD_ST_M7S  = { t="wood/wd_st_m7s" }
WD_ST_V2  = { t="wood/wd_st_v2" }
WD_ST_V4  = { t="wood/wd_st_v4" }
WD_ST_V5  = { t="wood/wd_st_v5" }
WD_SY_M1  = { t="wood/wd_sy_m1" }
WD_SY_M1A  = { t="wood/wd_sy_m1a" }
WD_SY_M1B  = { t="wood/wd_sy_m1b" }
WD_SY_M2  = { t="wood/wd_sy_m2" }
WD_SY_M3  = { t="wood/wd_sy_m3" }
WD_SY_M4  = { t="wood/wd_sy_m4" }
WD_SY_M4A  = { t="wood/wd_sy_m4a" }
WD_SY_M4B  = { t="wood/wd_sy_m4b" }
W_SR_VA3  = { t="wood/w_sr_va3" }
W_SR_VA4  = { t="wood/w_sr_va4" }


 
  -- special stuff

  TRIGGER    = { t="common/0_trigger" }

  L_LAVA1    = { t="common/molted5" }
  L_WATER1   = { t="common/water3" }
  L_WATER2   = { t="common/water_hl_v2" }


  -- Oblige specific textures
  O_CHROME    = { t="chrome1" }
  O_REFLMAP   = { t="reflmap" }
  O_REGION    = { t="region" }
  O_SPECULAR  = { t="specular" }

}

QUAKE2.RAILS =
{
}


QUAKE2.LIQUIDS =
{
  water  = { mat="L_WATER1", medium="water", light=0, special=0 }
  water2 = { mat="L_WATER2", medium="water", light=0, special=0 }
  lava   = { mat="L_LAVA1",  medium="lava",  light=1, special=0, damage=99 }
}


----------------------------------------------------------------

QUAKE2.SKINS =
{
  ----| STARTS |----

  Start_basic =
  {
    _prefab = "START_SPOT"
    _where  = "middle"

    top = "MT_MF_V11"
  }


  ----| EXITS |----

  Exit_basic =
  {
    _prefab = "QUAKE2_EXIT_PAD"
    _where  = "middle"

    pad  = "MT_SR_V24"
    side = "MT_SR_V23"
  }


  ----| PICTURES |----

  Pic_Carve =
  {
    _prefab = "PICTURE"
    _where  = "edge"
    _long   = 192

    pic   = "SG_SR_MN9"
    pic_w = 64
    pic_h = 64

    light = 64
  }


  ----| KEY |----

  Item_niche =
  {
    _prefab = "ITEM_NICHE"
    _where  = "edge"
    _long   = 192
    _deep   = 64

    light = 128
    style = 11
  }

  Pedestal_1 =
  {
    _prefab = "PEDESTAL"
    _where  = "middle"

    top  = "LI_PV_V7A"   --Light?
    side = "MT_SR_V24"

    light = 160
    style = 11
  }


  ----| STAIRS |----

  Stair_Up1 =
  {
    _prefab = "STAIR_6"
    _where  = "floor"
    _deltas = { 32,48,64,64,80 }
  }

  Stair_Down1 =
  {
    _prefab = "NICHE_STAIR_8"
    _where  = "floor"
    _deltas = { -32,-48,-64,-80,-96 }
  }

  Lift_Up1 =
  {
    _prefab = "QUAKE_LIFT_UP"
    _where  = "floor"
    _deltas = { 96,128,128,160,192 }

    lift = "MT_SR_V8" -- Lift texture
  }

  Lift_Down1 =
  {
    _prefab = "QUAKE_LIFT_DOWN"
    _where  = "floor"
    _deltas = { -96,-128,-128,-160,-192 }

    lift = "MT_SR_V8"
  }


  ----| ARCHES |----


  Arch1 =
  {
    _prefab = "ARCH"
    _where  = "edge"
    _long   = 192
    _deep   = 64
  }


  ----| DOORS |----

  Door_plain =
  {
    _prefab = "QUAKE_DOOR"
    _where  = "edge"
    _long   = 192
    _deep   = 32

    door = "DR_PV_MA1"
  }




  --- LOCKED DOORS ---

  Locked_key10 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key10"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key10"
  }

  Locked_key9 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key9"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key9"
  }
  
  Locked_key8 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key8"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key8"
  }

  Locked_key7 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key7"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key7"
  }
  
    Locked_key6 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key6"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key6"
  }

  Locked_key5 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key5"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key5"
  }
  
  Locked_key4 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key4"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key4"
  }

  Locked_key3 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key3"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key3"
  }
  
  Locked_key2 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key2"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key2"
  }

  Locked_key1 =
  {
    _prefab = "QUAKE2_KEY_DOOR"
    _where  = "edge"
    _key    = "k_key1"
    _long = 192
    _deep = 32

    door = "ELEVDOOR"
    item = "key_key1"
  }


  ----| SWITCHED DOORS |---- 

  Door_SW_1 =
  {
    _prefab = "QUAKE_DOOR"
    _where  = "edge"
    _switch = "sw_foo"
    _long = 192
    _deep = 32

    door = "DR_PV_M1"
    message = "Find the button thug!"
    wait = -1
  }

  Switch_floor1 =
  {
    _prefab = "QUAKE_FLOOR_SWITCH"
    _where  = "middle"
    _switch = "sw_foo"

    switch = "M_MF_V2"
    side   = "M_MF_V2B"
  }


  ---| TELEPORTERS |---

  Teleporter1 =
  {
    _prefab = "QUAKE2_TELEPORTER"
    _where  = "middle"
  }




  ---| WINDOWS |---

  Window1 =
  {
    _prefab = "WINDOW"
    _where  = "edge"
    _long   = 192
    _deep   = 32

    track = "W_SR_V1"
  }

--[[
  ---| FENCES |---

  Fence1 =
  {
    _prefab = "FENCE_STICKS_QUAKE"
    _where  = "edge"
    _long   = 192
    _deep   = 32

    fence = "WIZWOOD1_8"
    metal = "METAL1_1"
  }


  ---| DECORATION |---

  TechLamp =
  {
    _prefab = "QUAKE_TECHLAMP"
    _radius = 24
  }

  RoundPillar =
  {
    _prefab = "ROUND_PILLAR"
    _radius = 32

    pillar = "TECH02_5"
  }
--]]


  ---| HALLWAY PIECES |---

  Hall_Basic_I =
  {
    _prefab = "HALL_BASIC_I"
    _shape  = "I"
  }

  Hall_Basic_C =
  {
    _prefab = "HALL_BASIC_C"
    _shape  = "C"

    torch_ent = "none"
  }

  Hall_Basic_T =
  {
    _prefab = "HALL_BASIC_T"
    _shape  = "T"
  }

  Hall_Basic_P =
  {
    _prefab = "HALL_BASIC_P"
    _shape  = "P"
  }

  Hall_Basic_I_Stair =
  {
    _prefab = "HALL_BASIC_I_STAIR"
    _shape  = "IS"
  }

  Hall_Basic_I_Lift =
  {
    _prefab = "HALL_BASIC_I_LIFT_QUAKE"
    _shape  = "IL"
    _tags   = 1

    lift = "MT_SR_V15"
  }


  Sky_Hall_I =
  {
    _prefab = "SKY_HALL_I"
    _shape  = "I"
    _need_sky = 1
  }

  Sky_Hall_C =
  {
    _prefab = "SKY_HALL_C"
    _shape  = "C"
    _need_sky = 1

    support = "MT_MF_V11"
    torch_ent = "none"
  }

  Sky_Hall_I_Stair =
  {
    _prefab = "SKY_HALL_I_STAIR"
    _shape  = "IS"
    _need_sky = 1

--??    step = "STEP5"
  }




} -- end of QUAKE2.SKINS


----------------------------------------------------------------


QUAKE2.THEME_DEFAULTS =
{
  starts = { Start_basic = 50 } -- Needed but looks more like q2

  exits = { Exit_basic = 50 }

  pedestals = { Pedestal_1 = 50 } --Weapon platvorm

  stairs = { Stair_Up1 = 50, Stair_Down1 = 50,
              Lift_Up1 = 7,   Lift_Down1 = 7 }

  arches = { Arch1 = 50 }

  keys = { k_key1=60, k_key2=30, k_key3=30, k_key4=30, k_key5=30, k_key6=30, k_key7=30, k_key8=30, k_key9=30, k_key10=30 }

  switches = { sw_foo=50 }

  switch_fabs = { Switch_floor1 = 50 }

  locked_doors = { Locked_key1 = 50, Locked_key2 = 30, Locked_key3 = 30, Locked_key4 = 30, Locked_key5 = 30, Locked_key6 = 30, 
                   Locked_key7 = 30, Locked_key8 = 30, Locked_key9 = 30, Locked_key10 = 30,
                   Door_SW_1 = 50 }

  arches = { Arch1 = 50 }

  teleporters = { Teleporter1 = 50 }

  hallway_groups = { basic = 50 }

  mini_halls = { Hall_Basic_I = 50 }

  sky_halls = { skier = 50 }

  logos = { Pic_Carve = 50 }
  
   windows = { Window1 = 50 }
}


QUAKE2.NAME_THEMES =
{
  -- TODO (especially 'Strogg')
}


QUAKE2.HALLWAY_GROUPS =
{
  basic =
  {
    pieces =
    {
      Hall_Basic_I = 50
      Hall_Basic_C = 50
      Hall_Basic_T = 50
      Hall_Basic_P = 50

      Hall_Basic_I_Stair = 20
      Hall_Basic_I_Lift  = 2
    }
  }

  skier =
  {
    pieces =
    {
      Sky_Hall_I = 50
      Sky_Hall_C = 50
      Sky_Hall_I_Stair = 50

      Hall_Basic_T = 50  -- use indoor versions for these
      Hall_Basic_P = 50  --

      Hall_Basic_I_Lift = 2   -- TODO: sky version
    }
  }
}


QUAKE2.ROOM_THEMES =
{
  Base_generic =
  {
    walls =
    {
	  B_CP_V4=10,B_CP_V8=10,B_CP_V9=10,B_CP_V9B=10,B_CP_V18=10,B_CP_V19=10,B_HL_V2=10,B_HL_V2J=10,B_MF_V1=10,B_MF_V2=10,B_MF_V12=10,B_MF_V12B=10,B_PV_V1=10,B_PV_V1A=10,B_RC_V4=10,
	  B_RC_V8=10,B_RC_V9=10,B_RC_V24=10,B_RC_V24A=10,B_SR_20=10,B_SR_V26=10,BR_RC_V1=10,C_MF_V1=10,C_MF_V2B=10,C_MF_V3=10,C_MF_V3C=10,C_MF_V5=10,C_MF_V7=10,C_PV_M1=10,
	  --end bricks
      B_CP_41R=10,B_CP_V9A=10,B_CP_V9C=10,B_RC_M1A=10,B_SR_26A=10,C_PV_M2Y=10,C_PV_V18Z=10,
	  --end bricks2
	  C_PV_M1=10,R_SR_M2A=10,TI_RC_C1=10,TI_RC_C1A=10,TI_RC_C13=10,
	  --end floors
    }

    floors =
    {
      B_CP_V8=10,B_CP_V9=10,B_CP_V9B=10,B_CP_V18=10,B_CP_V19=10,B_MF_V4=10,B_RC_V16=10,B_RC_V16A=10,B_RC_V19=10,B_RC_V20=10,C_SR_MB2=10,C_SR_MB2A=10,C_SR_MB2B=10,RF_SR_M2S=10,
	  --end bricks
	  B_CT_V1A=10,B_CT_V1C=10,
	  --end bricks2
	  FL_CP_V5=10,FL_CP_V5A=10,FL_CP_V11C=10,FL_PV_M=10,FL_PV_M3=10,FL_PV_M4=10,FL_PV_MR4=10,FL_PV_V1A=10,FL_PV_V2A=10,FL_RC_C02=10,FL_RC_V4=10,FL_RC_V4A=10,FL_ST_M2=10,FL_ST_M2A=10,FL_ST_M2B=10,RF_SR_M2=10,RF_SR_M2S=10,
	  --end floors
    }

    ceilings =
	{
      B_CP_V9B=10,B_CP_V18=10,B_CP_V19=10,B_CP_V32=10,B_RC_V13A=10,B_RC_V13B=10,B_SR_V20B=10,B_SR_V22=10,B_SR_V26=10,C_MF_V1=10,C_MF_V3=10,C_MF_V3A=10,C_MF_V5=10,C_SR_MB2=10,C_SR_MB2A=10,
	  --end bricks
	  B_SR_26A=10,C_PV_V18Z=10,
	  --end bricks2
	  FL_CP_V5A=10,FL_PV_M4=10,FL_PV_V2A=10,FL_SR_V1=10,FL_SR_V1B=10,R_SR_M2=10,TI_RC_C1B=10,
	  --end floors
    }
  }

  Cave_generic =
  {
    naturals =
    {
	  S_RC_C01=10,S_RC_C03=10,S_RC_C07=10,S_RC_C09=10,S_SR_M1A=10,S_SR_M2A=10,S_SR_M3=10,S_SR_M6=10,S_SR_M7=10,
	  --end bricks
      GR_RC_C08=50,GROUND_ST=50,RC_RC_C4=10,RC_RC_C6=10,RC_RC_C6A=10,RC_RC_C6A_2=10,
      --end terrain
    }
  }

  Outdoors_generic =
  {
    floors =
    {
      GROUND_ST=50,RC_RC_C4=10,RC_RC_C6=10,RC_RC_C6A=10,RC_RC_C6A_2=10,
    }

    naturals =
    {
      GR_RC_C08=50,
    }
  }
}


QUAKE2.LEVEL_THEMES =
{
  quake2_base1 =
  {
    prob = 50

    liquids = { water=50, lava=40 }

    buildings = { Base_generic=50 }

    caves = { Cave_generic=50 }

    outdoors = { Outdoors_generic=50 }

  }
}


----------------------------------------------------------------

QUAKE2.MONSTERS =
{
  rat =
  {
    id = "props_rat"
    r = 12
    h = 10
    level = 1
    prob = 90
    health = 10
    damage = 2
    attack = "melee"
  }

  shrimp =
  {
    id = "props2_fish"
    r = 12
    h = 10
    level = 1
    prob = 10
    health = 10
    damage = 2
    attack = "melee"
  }

  dog =
  {
    id = "cast_dog"
    r = 16
    h = 38
    level = 1
    prob = 50
    health = 100
    damage = 16
    attack = "melee"
  }

  bitch =
  {
    id = "cast_bitch"
    r = 16
    h = 72
    level = 3
    prob = 50
    health = 100
    damage = 20
    attack = "hitscan"
  }
  
  punk =
  {
    id = "cast_punk"
    r = 16
    h = 72
    level = 3
    prob = 50
    health = 100
    damage = 20
    attack = "hitscan"
	spawnflags = 0
  }
  
  punk_flame =
  {
    id = "cast_punk"
    r = 16
    h = 72
    replaces = "punk"
    replace_prob = 50
    health = 100
    damage = 50
    attack = "hitscan"
	spawnflags = 4
  }
  
  punk_rocket =
  {
    id = "cast_punk"
    r = 16
    h = 72
    replaces = "punk"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "missile"
	spawnflags = 8
  }
  
  punk_hmg =
  {
    id = "cast_punk"
    r = 16
    h = 72
    replaces = "punk"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "hitscan"
	spawnflags = 16
  }
  
  punk_tommygun =
  {
    id = "cast_punk"
    r = 16
    h = 72
    replaces = "punk"
    replace_prob = 50
    health = 100
    damage = 30
    attack = "hitscan"
	spawnflags = 64
  }
  
  punk_grenade =
  {
    id = "cast_punk"
    r = 16
    h = 72
    replaces = "punk"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "missile"
	spawnflags = 128
  }
  
  runt =
  {
    id = "cast_runt"
    r = 16
    h = 72
    level = 3
    prob = 50
    health = 100
    damage = 20
    attack = "hitscan"
  }
  
  shorty =
  {
    id = "cast_shorty"
    r = 16
    h = 72
    level = 3
    prob = 50
    health = 100
    damage = 20
    attack = "hitscan"
  }
  
  shorty_flame =
  {
    id = "cast_shorty"
    r = 16
    h = 72
    replaces = "shorty"
    replace_prob = 50
    health = 100
    damage = 50
    attack = "hitscan"
	spawnflags = 4
  }
  
  shorty_rocket =
  {
    id = "cast_shorty"
    r = 16
    h = 72
    replaces = "shorty"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "missile"
	spawnflags = 8
  }
  
  shorty_hmg =
  {
    id = "cast_shorty"
    r = 16
    h = 72
    replaces = "shorty"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "hitscan"
	spawnflags = 16
  }
  
  shorty_tommygun =
  {
    id = "cast_shorty"
    r = 16
    h = 72
    replaces = "shorty"
    replace_prob = 50
    health = 100
    damage = 30
    attack = "hitscan"
	spawnflags = 64
  }
  
  shorty_grenade =
  {
    id = "cast_shorty"
    r = 16
    h = 72
    replaces = "shorty"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "missile"
	spawnflags = 128
  }
  
  thug =
  {
    id = "cast_thug"
    r = 16
    h = 72
    level = 3
    prob = 50
    health = 100
    damage = 20
    attack = "hitscan"
  }
  
  whore =
  {
    id = "cast_whore"
    r = 16
    h = 72
    level = 3
    prob = 50
    health = 100
    damage = 20
    attack = "hitscan"
  }
  
  whore_flame =
  {
    id = "cast_whore"
    r = 16
    h = 72
    replaces = "whore"
    replace_prob = 50
    health = 100
    damage = 50
    attack = "hitscan"
	spawnflags = 4
  }
  
  whore_rocket =
  {
    id = "cast_whore"
    r = 16
    h = 72
    replaces = "whore"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "missile"
	spawnflags = 8
  }
  
  whore_hmg =
  {
    id = "cast_whore"
    r = 16
    h = 72
    replaces = "whore"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "hitscan"
	spawnflags = 16
  }
  
  whore_tommygun =
  {
    id = "cast_whore"
    r = 16
    h = 72
    replaces = "whore"
    replace_prob = 50
    health = 100
    damage = 30
    attack = "hitscan"
	spawnflags = 64
  }
  
  whore_grenade =
  {
    id = "cast_whore"
    r = 16
    h = 72
    replaces = "whore"
    replace_prob = 50
    health = 100
    damage = 100
    attack = "missile"
	spawnflags = 128
  }
  
}


QUAKE2.WEAPONS =
{
  pipe = 
  {
    rate = 1.7
    damage = 10
    attack = "melee"
  }

  crowbar =
  {
    id = "weapon_crowbar"
    level = 1
    pref = 20
    add_prob = 10
    start_prob = 40
    attack = "melee"
    rate = 0.6
    damage = 50
  }
  
  pistol =
  {
    id = "weapon_pistol"
    level = 1
    pref = 20
    add_prob = 10
    start_prob = 40
    attack = "hitscan"
    rate = 2
    damage = 15
    ammo = "bullet"
    per = 1
    give = { {ammo="bullet",count=10} }
  }

  pistol_dmg =
  {
    id = "pistol_mod_damage"
    level = 1
    pref = 25
    add_prob = 20
    start_prob = 40
    attack = "hitscan"
    rate = 2
    damage = 30
    ammo = "bullet"
    per = 1
    give = { {ammo="bullet",count=10} }
  }
  
  pistol_reload =
  {
    id = "pistol_mod_reload"
    level = 1
    pref = 20
    add_prob = 15
    start_prob = 40
    attack = "hitscan"
    rate = 2
    damage = 15
    ammo = "bullet"
    per = 1
    give = { {ammo="bullet",count=10} }
  }
  
  pistol_rof =
  {
    id = "pistol_mod_rof"
    level = 1
    pref = 20
    add_prob = 15
    start_prob = 40
    attack = "hitscan"
    rate = 4
    damage = 15
    ammo = "bullet"
    per = 1
    give = { {ammo="bullet",count=10} }
  }
  
  shotgun =
  {
    id = "weapon_shotgun"
    level = 2
    pref = 40
    add_prob = 50
    attack = "hitscan"
    rate = 1
    damage = 16
    splash = {0,8}
    ammo = "shell"
    per = 2
    give = { {ammo="shell",count=8} }
  }

  tommygun =
  {
    id = "weapon_tommygun"
    level = 2
    pref = 30
    add_prob = 30
    attack = "hitscan"
    rate = 9
    damage = 14
    ammo = "bullet"
    per = 1
    give = { {ammo="bullet",count=50} }
  }

  hmg =
  {
    id = "weapon_heavymachinegun"
    level = 4
    pref = 90
    add_prob = 15
    attack = "hitscan"
    rate = 3
    damage = 50
    ammo = "308"
    per = 1
    give = { {ammo="308",count=30} }
  }

  hmgcooler =
  {
    id = "hmg_mod_cooling"
    level = 5
    pref = 90
    add_prob = 15
    attack = "hitscan"
    rate = 3
    damage = 50
    ammo = "308"
    per = 1
    give = { {ammo="308",count=30} }
  }
  
  grenadelauncher =
  {
    id = "weapon_grenadelauncher"
    level = 3
    pref = 30
    add_prob = 25
    attack = "missile"
    rate = 0.7
    damage = 125
    splash = {60,15,3}
    ammo = "grenade"
    per = 1
    give = { {ammo="grenade",count=5} }
  }

  rocket =
  {
    id = "weapon_bazooka"
    level = 5
    pref = 50
    add_prob = 20
    attack = "missile"
    rate = 1
    damage = 100
    splash = {0,20,6,2}
    ammo = "rocket"
    per = 1
    give = { {ammo="rocket",count=5} }
  }

  flamethrower =
  {
    id = "weapon_flamethrower"
    level = 4
    pref = 30
    add_prob = 25
    attack = "hitscan"
    rate = 0.1
    damage = 140
    ammo = "gas"
    per = 1
    splash = {0,25,5}
    give = { {ammo="gas",count=10} }
  }


}


QUAKE2.PICKUPS =
{
  -- HEALTH --


  heal_15 =
  {
    id = "item_health_sm"
    prob = 20
    give = { {health=15} }
  }

  heal_25 =
  {
    id = "item_health_lg"
    prob = 50
    give = { {health=25} }
  }


  -- ARMOR --


  armor_50_h =
  {
    id = "item_armor_helmet"
    prob = 15
    give = { {health=25} }
  }
  
  armor_50_b =
  {
    id = "item_armor_jacket"
    prob = 15
    give = { {health=25} }
  }
    
  armor_50_l =
  {
    id = "item_armor_legs"
    prob = 15
    give = { {health=25} }
  }
  

  armor_100_h =
  {
    id = "item_armor_helmet_heavy"
    prob = 15
    give = { {health=50} }
  }
  
   armor_100_b =
  {
    id = "item_armor_jacket_heavy"
    prob = 15
    give = { {health=50} }
  }
  
  armor_100_l =
  {
    id = "item_armor_legs_heavy"
    prob = 15
    give = { {health=50} }
  }

  -- AMMO --

  am_bullet =
  {
    id = "ammo_bullets"
    prob = 20
    give = { {ammo="bullet",count=15} }
  }
  
  am_cylinder =
  {
    id = "ammo_cylinder"
    prob = 20
    give = { {ammo="bullet",count=50} }
  }

  am_shell =
  {
    id = "ammo_shells"
    prob = 20
    give = { {ammo="shell",count=8} }
  }

  am_grenade =
  {
    id = "ammo_grenades"
    prob = 20
    give = { {ammo="grenade",count=3} }
  }

  am_rocket =
  {
    id = "ammo_rockets"
    prob = 20
    give = { {ammo="rocket",count=5} }
  }

  am_308 = 
  {
    id = "ammo_308"
    prob = 20
    give = { {ammo="308",count=30} }
  }

  am_gas =
  {
    id = "ammo_flametank"
    prob = 20
    give = { {ammo="gas",count=50} }
  }
  

}


QUAKE2.PLAYER_MODEL =
{
  quakeguy =
  {
    stats   = { health=0 }
    weapons = { pipe=1 }
  }
}


------------------------------------------------------------

QUAKE2.EPISODES =
{
  episode1 =
  {
    theme = "TECH"
    sky_light = 0.75
  }

  episode2 =
  {
    theme = "TECH"
    sky_light = 0.75
  }

  episode3 =
  {
    theme = "TECH"
    sky_light = 0.75
  }
  
  episode4 =
  {
    theme = "TECH"
    sky_light = 0.75
  }

  episode5 =
  {
    theme = "TECH"
    sky_light = 0.75
  }
}


----------------------------------------------------------------

function QUAKE2.setup()
  -- nothing needed
end


function QUAKE2.get_levels()
  local  EP_NUM = (OB_CONFIG.length == "full"   ? 5 ; 1)
  local MAP_NUM = (OB_CONFIG.length == "single" ? 1 ; 5)

  if OB_CONFIG.length == "few"     then MAP_NUM = 3 end
  if OB_CONFIG.length == "episode" then MAP_NUM = 7 end

  local prefixes = { "sr", "pv_", "sy", "steel", "ty", "rc" }

  for ep_index = 1,EP_NUM do
    -- create episode info...
    local EPI =
    {
      levels = {}
    }

    table.insert(GAME.episodes, EPI)

    local ep_info = QUAKE2.EPISODES["episode" .. ep_index]
    assert(ep_info)

    local ep_prefix = prefixes[ep_index]

    for map = 1,MAP_NUM do

      -- create level info...
      local LEV =
      {
        episode = EPI

        name     = ep_prefix .. (map)
        next_map = ep_prefix .. (map + 1)

         ep_along = map / MAP_NUM
        mon_along = (map + ep_index - 1) / MAP_NUM
      }

      -- end of episode? Go to next one (with cinematic) or face the Boss
      if map == MAP_NUM then
        if ep_index == 5 then
          LEV.next_map = "rcboss2"
        else
          LEV.next_map = string.format("%s1", prefixes[ep_index+1])
        end
      end

      table.insert( EPI.levels, LEV)
      table.insert(GAME.levels, LEV)
    end -- for map

  end -- for episode
end



----------------------------------------------------------------

OB_GAMES["quake2"] =
{
  label = "Kingpin"

  format = "quake2"

  tables =
  {
    QUAKE2
  }

  hooks =
  {
    setup        = QUAKE2.setup
    get_levels   = QUAKE2.get_levels
  }
}


OB_THEMES["quake2_base"] =
{
  label = "Base"
  for_games = { quake2=1 }
  name_theme = "TECH"
  mixed_prob = 50
}

