/*
 * Decompiled with CFR 0.152.
 */
package com.nerius.math.xform;

import com.nerius.math.geom.Point2D;
import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.Projection;

public class PerspectiveProjection
implements Projection {
    public final Point3D eyeball;
    public final double zPlane;

    public PerspectiveProjection(Point3D eyeball, double zPlane) {
        if (eyeball == null) {
            throw new NullPointerException("eyeball is null");
        }
        this.eyeball = eyeball;
        this.zPlane = zPlane;
    }

    @Override
    public Point2D project(Point3D pt3D) {
        return new Point2D(this.getXProjection(pt3D.x, pt3D.z), this.getYProjection(pt3D.y, pt3D.z));
    }

    private double getXProjection(double xCoord, double zCoord) {
        double f = xCoord - this.eyeball.x;
        return (f /= (this.eyeball.z - zCoord) / (this.eyeball.z - this.zPlane)) + this.eyeball.x;
    }

    private double getYProjection(double yCoord, double zCoord) {
        double f = yCoord - this.eyeball.y;
        return (f /= (this.eyeball.z - zCoord) / (this.eyeball.z - this.zPlane)) + this.eyeball.y;
    }
}

