/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class DiscGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Point3D[] curve;
        Thread.currentThread().setPriority(1);
        int radius = Integer.parseInt(args[0]);
        int faces = Integer.parseInt(args[1]);
        int height = Integer.parseInt(args[2]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[3]);
        double offsetAngle = Double.parseDouble(args[4]);
        if (adjustForOverlappingCylinderCuts) {
            if (faces % 2 != 0) {
                System.err.println("WARNING: Cannot adjust for overlapping cylinder cuts when number of faces\nin half-disc is odd.");
                curve = DiscGenerator.generateCurveNormally(radius, faces);
            } else {
                int i;
                Point3D[] curveTemp = DiscGenerator.generatePipeCurve(radius, faces / 2, 0, 0.0, 1);
                curve = new Point3D[faces + 1];
                AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
                for (i = 0; i < curveTemp.length; ++i) {
                    curve[i] = rot.transform(curveTemp[i]);
                }
                rot = new AxisRotation3D(4, 1.5707963267948966);
                for (i = curveTemp.length; i <= faces; ++i) {
                    curve[i] = rot.transform(curve[i - curveTemp.length + 1]);
                }
            }
        } else {
            curve = DiscGenerator.generateCurveNormally(radius, faces);
        }
        if (offsetAngle != 0.0) {
            double radians = Math.PI * offsetAngle / 180.0;
            AxisRotation3D rot = new AxisRotation3D(4, radians);
            for (int i = 0; i <= faces; ++i) {
                curve[i] = rot.transform(curve[i]);
            }
        }
        DiscGenerator.startMap();
        for (int i = 0; i < faces / 2; ++i) {
            if (i + 1 == faces / 2) {
                if (faces % 2 == 1) {
                    DiscGenerator.writeBrushExtendZ(-height, curve[i], curve[i + 3], curve[i + 2], curve[i + 1]);
                    continue;
                }
                DiscGenerator.writeBrushExtendZ(-height, curve[i], curve[i + 2], curve[i + 1], false);
                continue;
            }
            int vert = faces - i;
            DiscGenerator.writeBrushExtendZ(-height, curve[i], curve[vert], curve[vert - 1], curve[i + 1]);
        }
        DiscGenerator.endMap();
    }

    private static Point3D[] generateCurveNormally(int radius, int faces) {
        Point3D pt = new Point3D(radius, 0.0, 0.0);
        Point3D[] curve = new Point3D[faces + 1];
        for (int i = 0; i <= faces; ++i) {
            AxisRotation3D rot = new AxisRotation3D(4, Math.PI * (double)i / (double)faces);
            curve[i] = rot.transform(pt);
        }
        return curve;
    }
}

