/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.CorkscrewCapGenerator;
import generators.CorkscrewGenerator;
import generators.CorkscrewShinglesGenerator;
import generators.CorkscrewTilesGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class CorkscrewGeneratorGUI
extends JFrame {
    public static final int SHINGLES_TYPE_CYL = 0;
    public static final int SHINGLES_TYPE_RAMP_SQTOP = 1;
    public static final int SHINGLES_TYPE_RAMP_TRITOP = 2;
    public Config configuration;
    private int outerRadius = 768;
    private int innerRadius = 512;
    private int outerThickness = 256;
    private int innerThickness = 64;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String outerRadiusTitle = "Outer Radius";
    private String outerRadiusDescription = "The radius of the outside of the corkscrew. This parameter is ignored if shingles are being generated.";
    private String innerRadiusTitle = "Inner Radius";
    private String innerRadiusDescription = "The radius of the inside of the corkscrew. When shingles are being generated, this defines the radius of the shingles structure. This parameter is ignored when a cap is being generated. ";
    private String slicesTitle = "Slices";
    private String slicesDescription = "The number of slices that the outer and inner circumferences are chopped into. The total number of brushes generated is 2 * slices. If shingles are being generated then the total number of brushes is half that. A cap contains contains one brush more than shingles do.";
    private String altitudeTitle = "Altitude";
    private String altitudeDescription = "The amount of height you gain going along a quarter of the corkscrew, following either the inner or outer circumference. For smoothest results this should be a multiple of slices. If tiles are being generated, you may want to try negative values here in order to come up with the correct tile orientation.";
    private String adjustForOverlappingCylinderCutsTitle = "Adjust For Overlapping Cylinder Cuts";
    private String adjustForOverlappingCylinderCutsDescription = "If aligning [either the outer or inner circumference of] this corkscrew with a cylinder generated with Cylinder Generator and the adjustForOverlappingCylinderCuts flag is set for that cylinder, use the flag here as well so that the two would align perfectly. Also applies on Pipe Generator and adjustForOverlappingPipeCuts.";
    private String lipTitle = "Lip";
    private String lipDescription = "The difference in height between the outer circumference and the inner circumference, taken at the top surface of the corkscrew, not the bottom. If shingles are being generated, this parameter only affects the overall position (translation) of the shingles. This parameter is ignored when a cap is being generated.";
    private String outerThicknessTitle = "Outer Thickness";
    private String outerThicknessDescription = "The thickness, measured vertically, of the corkscrew at the outer circumference. This parameter is ignored if shingles or tiles are being generated.";
    private String innerThicknessTitle = "Inner Thickness";
    private String innerThicknessDescription = "The thickness, measured vertically, of the corkscrew at the inner circumference. When shingles are generated this defines the \"height\" of the shingles. This parameter is ignored when a cap is being generated, and also when tiles are being generated.";
    private String offsetAngleTitle = "Offset Angle";
    private String offsetAngleDescription = "The angle, in degrees, by which to rotate the corkscrew counter-clockwise. This only applies if normal brushes or tiles are being generated, not shingles or cap.";
    private String opNormalTitle = "Generate normal brushes";
    private String opNormalDescription = "Generates ordinary brushes. You may consider generating shingles for the inner wall of the corkscrew to prevent \"bouncing\" if the player is going to be flung around the inner wall. Also you may want to experiment with tiles and/or an outer cap.";
    private String opCylinderShinglesTitle = "Generate cylinder shingles";
    private String opCylinderShinglesDescription = "Can be applied to the inside of a corkscrew. These are one-directional when going around. Use this with the default corkscrew orientation (not rotated). ";
    private String opSquareRampShinglesTitle = "Generate ramp shingles, top shingle square";
    private String opSquareRampShinglesDescription = "Can be applied to the inside of a corkscrew. Use this when the corkscrew is rotated 90 degrees along the X or Y axis, becoming more like a ramp. The shingle at the top of the ramp is square to prevent lemmings when falling on that shingle.";
    private String opTriRampShinglesTitle = "Generate ramp shingles, top shingle triangular";
    private String opTriRampShinglesDescription = "Can be applied to the inside of a corkscrew. Use this when the corkscrew is rotated 90 degrees along the X or Y axis, becoming more like a ramp. The shingle at the top of the ramp is triangular in cross section, making the shingles suitable for the last quarter of a vertical loop.";
    private String opGenerateTilesTitle = "Generate tiles";
    private String opGenerateTilesDescription = "Can be applied to the top surface of a corkscrew. This is especially useful when the corkscrew is flipped upright and used as the wall of a loop. For normal use (when going around the corkscrew horizontally), be aware that the tiles may have sharp corners pointing upwards, which causes lemmings when falling on them.";
    private String opGenerateTilesReverseDirectionTitle = "Generate tiles, reverse direction";
    private String opGenerateTilesReverseDirectionDescription = "Exactly like above, except that the direction of the tiles is flipped.";
    private String opGenerateOuterCapTitle = "Generate outer cap";
    private String opGenerateOuterCapDescription = "Can be applied to the outside of a corkscrew. This is especially useful when the corkscrew is flipped upright to form a loop, and when players will be falling onto the top of that loop. The cap prevents lemmings";
    private JPanel adjustForOverlappingCutsPanel;
    private JCheckBox adjustForOverlappingCylinderCuts;
    private JPanel altitudePanel;
    private JDialog corkscrewNote;
    private JPanel cylinderShinglesOptionPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JButton generate;
    private JPanel generateOuterCapPanel;
    private JPanel generateTilesOptionPanel;
    private JPanel generateTilesReverseDirectionOptionPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inAltitude;
    private JTextField inInnerRadius;
    private JTextField inInnerThickness;
    private JTextField inLip;
    private JTextField inOffsetAngle;
    private JTextField inOuterRadius;
    private JTextField inOuterThickness;
    private JTextField inSlices;
    private JPanel innerRadiusPanel;
    private JPanel innerThicknessPanel;
    private JLabel labAltitude;
    private JLabel labInnerRadius;
    private JLabel labInnerThickness;
    private JLabel labLip;
    private JLabel labOffsetAngle;
    private JLabel labOuterRadius;
    private JLabel labOuterThickness;
    private JLabel labSlices;
    private JPanel lipPanel;
    private JMenuBar menu;
    private JPanel normalOptionPanel;
    private JMenu note;
    private JTextArea noteDescription;
    private JMenuItem noteOnShingles;
    private JPanel offsetAnglePanel;
    private JRadioButton opCylinderShingles;
    private JRadioButton opGenerateOuterCap;
    private JRadioButton opGenerateTiles;
    private JRadioButton opGenerateTilesReverseDirection;
    private JRadioButton opNormal;
    private JRadioButton opSquareRampShingles;
    private JRadioButton opTriRampShingles;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel outerRadiusPanel;
    private JPanel outerThicknessPanel;
    private JScrollPane scrollPane1;
    private JPanel slicesPanel;
    private JPanel squareShinglesOptionPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel triShinglesOptionPanel;
    private JPanel valuesPanel;
    private JPanel viewPanel;

    public CorkscrewGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.corkscrewNote = new JDialog();
        this.noteDescription = new JTextArea();
        this.scrollPane1 = new JScrollPane();
        this.viewPanel = new JPanel();
        this.valuesPanel = new JPanel();
        this.outerRadiusPanel = new JPanel();
        this.labOuterRadius = new JLabel();
        this.inOuterRadius = new JTextField();
        this.innerRadiusPanel = new JPanel();
        this.labInnerRadius = new JLabel();
        this.inInnerRadius = new JTextField();
        this.slicesPanel = new JPanel();
        this.labSlices = new JLabel();
        this.inSlices = new JTextField();
        this.altitudePanel = new JPanel();
        this.labAltitude = new JLabel();
        this.inAltitude = new JTextField();
        this.adjustForOverlappingCutsPanel = new JPanel();
        this.adjustForOverlappingCylinderCuts = new JCheckBox();
        this.lipPanel = new JPanel();
        this.labLip = new JLabel();
        this.inLip = new JTextField();
        this.innerThicknessPanel = new JPanel();
        this.labInnerThickness = new JLabel();
        this.inInnerThickness = new JTextField();
        this.outerThicknessPanel = new JPanel();
        this.labOuterThickness = new JLabel();
        this.inOuterThickness = new JTextField();
        this.offsetAnglePanel = new JPanel();
        this.labOffsetAngle = new JLabel();
        this.inOffsetAngle = new JTextField();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.cylinderShinglesOptionPanel = new JPanel();
        this.opCylinderShingles = new JRadioButton();
        this.squareShinglesOptionPanel = new JPanel();
        this.opSquareRampShingles = new JRadioButton();
        this.triShinglesOptionPanel = new JPanel();
        this.opTriRampShingles = new JRadioButton();
        this.generateTilesOptionPanel = new JPanel();
        this.opGenerateTiles = new JRadioButton();
        this.generateTilesReverseDirectionOptionPanel = new JPanel();
        this.opGenerateOuterCap = new JRadioButton();
        this.generateOuterCapPanel = new JPanel();
        this.opGenerateTilesReverseDirection = new JRadioButton();
        this.menu = new JMenuBar();
        this.note = new JMenu();
        this.noteOnShingles = new JMenuItem();
        this.corkscrewNote.setTitle("Note on shingles");
        this.corkscrewNote.setMinimumSize(new Dimension(330, 372));
        this.noteDescription.setEditable(false);
        this.noteDescription.setBackground(new Color(240, 240, 240));
        this.noteDescription.setColumns(20);
        this.noteDescription.setLineWrap(true);
        this.noteDescription.setRows(5);
        this.noteDescription.setText(" The fact that there are so many different types of shingles that can be generated is confusing. The three types are: shingles, tiles, and cap. Shingles go along the inside wall of the corkscrew, much like shingles on the inside of a cylinder. Tiles go on the main surface of the corkscrew (the top) and may help prevent \"bounching\", especially when flipped upright and used as the wall of a loop. A cap goes on the outside wall of the corkscrew and is useful to prevent lemmings when the corkscrew is flipped upright to form a loop; the cap would then be on top of the loop.");
        this.noteDescription.setWrapStyleWord(true);
        this.noteDescription.setMinimumSize(new Dimension(220, 150));
        this.noteDescription.setPreferredSize(new Dimension(220, 150));
        GroupLayout corkscrewNoteLayout = new GroupLayout(this.corkscrewNote.getContentPane());
        this.corkscrewNote.getContentPane().setLayout(corkscrewNoteLayout);
        corkscrewNoteLayout.setHorizontalGroup(corkscrewNoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(corkscrewNoteLayout.createSequentialGroup().addContainerGap().addComponent(this.noteDescription, -1, 430, Short.MAX_VALUE).addContainerGap()));
        corkscrewNoteLayout.setVerticalGroup(corkscrewNoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(corkscrewNoteLayout.createSequentialGroup().addContainerGap().addComponent(this.noteDescription, -1, -1, Short.MAX_VALUE)));
        this.setTitle("Corkscrew Generator");
        this.outerRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.outerRadiusPanelFocusGained(evt);
            }
        });
        this.labOuterRadius.setLabelFor(this.inOuterRadius);
        this.labOuterRadius.setText("outerRadius:");
        this.inOuterRadius.setText("1024");
        this.inOuterRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inOuterRadiusActionPerformed(evt);
            }
        });
        this.inOuterRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inOuterRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inOuterRadiusFocusLost(evt);
            }
        });
        GroupLayout outerRadiusPanelLayout = new GroupLayout(this.outerRadiusPanel);
        this.outerRadiusPanel.setLayout(outerRadiusPanelLayout);
        outerRadiusPanelLayout.setHorizontalGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOuterRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOuterRadius, -2, 64, -2).addContainerGap()));
        outerRadiusPanelLayout.setVerticalGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOuterRadius).addComponent(this.inOuterRadius, -2, -1, -2)).addContainerGap()));
        this.labInnerRadius.setLabelFor(this.inInnerRadius);
        this.labInnerRadius.setText("innerRadius:");
        this.inInnerRadius.setText("512");
        this.inInnerRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inInnerRadiusActionPerformed(evt);
            }
        });
        this.inInnerRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inInnerRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inInnerRadiusFocusLost(evt);
            }
        });
        GroupLayout innerRadiusPanelLayout = new GroupLayout(this.innerRadiusPanel);
        this.innerRadiusPanel.setLayout(innerRadiusPanelLayout);
        innerRadiusPanelLayout.setHorizontalGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labInnerRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inInnerRadius, -2, 64, -2).addContainerGap()));
        innerRadiusPanelLayout.setVerticalGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, innerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labInnerRadius).addComponent(this.inInnerRadius, -2, -1, -2)).addContainerGap()));
        this.labSlices.setLabelFor(this.inSlices);
        this.labSlices.setText("slices:");
        this.inSlices.setText("16");
        this.inSlices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inSlicesActionPerformed(evt);
            }
        });
        this.inSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inSlicesFocusLost(evt);
            }
        });
        GroupLayout slicesPanelLayout = new GroupLayout(this.slicesPanel);
        this.slicesPanel.setLayout(slicesPanelLayout);
        slicesPanelLayout.setHorizontalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlices, -2, 64, -2).addContainerGap()));
        slicesPanelLayout.setVerticalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlices).addComponent(this.inSlices, -2, -1, -2)).addContainerGap()));
        this.labAltitude.setLabelFor(this.inAltitude);
        this.labAltitude.setText("altitude:");
        this.inAltitude.setText("320");
        this.inAltitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inAltitudeActionPerformed(evt);
            }
        });
        this.inAltitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inAltitudeFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inAltitudeFocusLost(evt);
            }
        });
        GroupLayout altitudePanelLayout = new GroupLayout(this.altitudePanel);
        this.altitudePanel.setLayout(altitudePanelLayout);
        altitudePanelLayout.setHorizontalGroup(altitudePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(altitudePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labAltitude).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inAltitude, -2, 64, -2).addContainerGap()));
        altitudePanelLayout.setVerticalGroup(altitudePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(altitudePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(altitudePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labAltitude).addComponent(this.inAltitude, -2, -1, -2))));
        this.adjustForOverlappingCylinderCuts.setText("adjustForOverlappingCylinderCuts");
        this.adjustForOverlappingCylinderCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingCylinderCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingCylinderCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.adjustForOverlappingCylinderCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.adjustForOverlappingCylinderCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingCutsPanelLayout = new GroupLayout(this.adjustForOverlappingCutsPanel);
        this.adjustForOverlappingCutsPanel.setLayout(adjustForOverlappingCutsPanelLayout);
        adjustForOverlappingCutsPanelLayout.setHorizontalGroup(adjustForOverlappingCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingCutsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingCylinderCuts).addContainerGap()));
        adjustForOverlappingCutsPanelLayout.setVerticalGroup(adjustForOverlappingCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustForOverlappingCutsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustForOverlappingCylinderCuts).addContainerGap(-1, Short.MAX_VALUE)));
        this.labLip.setLabelFor(this.inLip);
        this.labLip.setText("lip:");
        this.inLip.setText("192");
        this.inLip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inLipActionPerformed(evt);
            }
        });
        this.inLip.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inLipFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inLipFocusLost(evt);
            }
        });
        GroupLayout lipPanelLayout = new GroupLayout(this.lipPanel);
        this.lipPanel.setLayout(lipPanelLayout);
        lipPanelLayout.setHorizontalGroup(lipPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lipPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labLip).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLip, -2, 64, -2).addContainerGap()));
        lipPanelLayout.setVerticalGroup(lipPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, lipPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(lipPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labLip).addComponent(this.inLip, -2, -1, -2)).addContainerGap()));
        this.innerThicknessPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.innerThicknessPanelFocusGained(evt);
            }
        });
        this.labInnerThickness.setLabelFor(this.inOuterRadius);
        this.labInnerThickness.setText("innerThickness:");
        this.inInnerThickness.setText("128");
        this.inInnerThickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inInnerThicknessActionPerformed(evt);
            }
        });
        this.inInnerThickness.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inInnerThicknessFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inInnerThicknessFocusLost(evt);
            }
        });
        GroupLayout innerThicknessPanelLayout = new GroupLayout(this.innerThicknessPanel);
        this.innerThicknessPanel.setLayout(innerThicknessPanelLayout);
        innerThicknessPanelLayout.setHorizontalGroup(innerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labInnerThickness).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inInnerThickness, -2, 64, -2).addContainerGap()));
        innerThicknessPanelLayout.setVerticalGroup(innerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, innerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(innerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labInnerThickness).addComponent(this.inInnerThickness, -2, -1, -2)).addContainerGap()));
        this.outerThicknessPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.outerThicknessPanelFocusGained(evt);
            }
        });
        this.labOuterThickness.setLabelFor(this.inOuterRadius);
        this.labOuterThickness.setText("outerThickness:");
        this.inOuterThickness.setText("256");
        this.inOuterThickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inOuterThicknessActionPerformed(evt);
            }
        });
        this.inOuterThickness.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inOuterThicknessFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inOuterThicknessFocusLost(evt);
            }
        });
        GroupLayout outerThicknessPanelLayout = new GroupLayout(this.outerThicknessPanel);
        this.outerThicknessPanel.setLayout(outerThicknessPanelLayout);
        outerThicknessPanelLayout.setHorizontalGroup(outerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOuterThickness).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOuterThickness, -2, 64, -2).addContainerGap()));
        outerThicknessPanelLayout.setVerticalGroup(outerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(outerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOuterThickness).addComponent(this.inOuterThickness, -2, -1, -2)).addContainerGap()));
        this.offsetAnglePanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.offsetAnglePanelFocusGained(evt);
            }
        });
        this.labOffsetAngle.setLabelFor(this.inOuterRadius);
        this.labOffsetAngle.setText("offsetAngle");
        this.inOffsetAngle.setText("0.0");
        this.inOffsetAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.inOffsetAngleActionPerformed(evt);
            }
        });
        this.inOffsetAngle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inOffsetAngleFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.inOffsetAngleFocusLost(evt);
            }
        });
        GroupLayout offsetAnglePanelLayout = new GroupLayout(this.offsetAnglePanel);
        this.offsetAnglePanel.setLayout(offsetAnglePanelLayout);
        offsetAnglePanelLayout.setHorizontalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOffsetAngle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOffsetAngle, -2, 64, -2).addContainerGap()));
        offsetAnglePanelLayout.setVerticalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOffsetAngle).addComponent(this.inOffsetAngle, -2, -1, -2)).addContainerGap()));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.outerThicknessPanel, -1, -1, Short.MAX_VALUE).addComponent(this.innerThicknessPanel, -1, -1, Short.MAX_VALUE).addComponent(this.outerRadiusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.innerRadiusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.slicesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.altitudePanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingCutsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.lipPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.offsetAnglePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.outerRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.altitudePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lipPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outerThicknessPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerThicknessPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingCutsPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetAnglePanel, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates a quarter of a corkscrew as a .map file to be opened in GtkRadiant.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, -1, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -1, 323, Short.MAX_VALUE)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -1, 23, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -2, 186, -2).addContainerGap()));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -1, 525, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generate).addGap(18, 18, 18)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusScrollPane, -2, 44, -2).addGroup(statusPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.generate))).addContainerGap()));
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/corkscrew.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 199, -2)));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opCylinderShingles);
        this.opCylinderShingles.setText("generate cylinder shingles");
        this.opCylinderShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opCylinderShinglesActionPerformed(evt);
            }
        });
        this.opCylinderShingles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opCylinderShinglesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opCylinderShinglesFocusLost(evt);
            }
        });
        GroupLayout cylinderShinglesOptionPanelLayout = new GroupLayout(this.cylinderShinglesOptionPanel);
        this.cylinderShinglesOptionPanel.setLayout(cylinderShinglesOptionPanelLayout);
        cylinderShinglesOptionPanelLayout.setHorizontalGroup(cylinderShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cylinderShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opCylinderShingles).addContainerGap(-1, Short.MAX_VALUE)));
        cylinderShinglesOptionPanelLayout.setVerticalGroup(cylinderShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opCylinderShingles));
        this.options.add(this.opSquareRampShingles);
        this.opSquareRampShingles.setText("generate ramp shingles, top shingle square");
        this.opSquareRampShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opSquareRampShinglesActionPerformed(evt);
            }
        });
        this.opSquareRampShingles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opSquareRampShinglesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opSquareRampShinglesFocusLost(evt);
            }
        });
        GroupLayout squareShinglesOptionPanelLayout = new GroupLayout(this.squareShinglesOptionPanel);
        this.squareShinglesOptionPanel.setLayout(squareShinglesOptionPanelLayout);
        squareShinglesOptionPanelLayout.setHorizontalGroup(squareShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(squareShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opSquareRampShingles).addContainerGap(-1, Short.MAX_VALUE)));
        squareShinglesOptionPanelLayout.setVerticalGroup(squareShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(squareShinglesOptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.opSquareRampShingles, -2, 15, -2)));
        this.options.add(this.opTriRampShingles);
        this.opTriRampShingles.setText("generate ramp shingles, top shingle triangular");
        this.opTriRampShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opTriRampShinglesActionPerformed(evt);
            }
        });
        this.opTriRampShingles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opTriRampShinglesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opTriRampShinglesFocusLost(evt);
            }
        });
        GroupLayout triShinglesOptionPanelLayout = new GroupLayout(this.triShinglesOptionPanel);
        this.triShinglesOptionPanel.setLayout(triShinglesOptionPanelLayout);
        triShinglesOptionPanelLayout.setHorizontalGroup(triShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(triShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opTriRampShingles).addContainerGap(-1, Short.MAX_VALUE)));
        triShinglesOptionPanelLayout.setVerticalGroup(triShinglesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(triShinglesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opTriRampShingles, -2, 15, -2).addContainerGap()));
        this.options.add(this.opGenerateTiles);
        this.opGenerateTiles.setText("generate tiles");
        this.opGenerateTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateTilesActionPerformed(evt);
            }
        });
        this.opGenerateTiles.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateTilesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateTilesFocusLost(evt);
            }
        });
        GroupLayout generateTilesOptionPanelLayout = new GroupLayout(this.generateTilesOptionPanel);
        this.generateTilesOptionPanel.setLayout(generateTilesOptionPanelLayout);
        generateTilesOptionPanelLayout.setHorizontalGroup(generateTilesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generateTilesOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opGenerateTiles, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateTilesOptionPanelLayout.setVerticalGroup(generateTilesOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateTilesOptionPanelLayout.createSequentialGroup().addGap(0, 4, Short.MAX_VALUE).addComponent(this.opGenerateTiles, -2, 15, -2)));
        this.options.add(this.opGenerateOuterCap);
        this.opGenerateOuterCap.setText("generate outer cap");
        this.opGenerateOuterCap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateOuterCapActionPerformed(evt);
            }
        });
        this.opGenerateOuterCap.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateOuterCapFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateOuterCapFocusLost(evt);
            }
        });
        GroupLayout generateTilesReverseDirectionOptionPanelLayout = new GroupLayout(this.generateTilesReverseDirectionOptionPanel);
        this.generateTilesReverseDirectionOptionPanel.setLayout(generateTilesReverseDirectionOptionPanelLayout);
        generateTilesReverseDirectionOptionPanelLayout.setHorizontalGroup(generateTilesReverseDirectionOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generateTilesReverseDirectionOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opGenerateOuterCap, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateTilesReverseDirectionOptionPanelLayout.setVerticalGroup(generateTilesReverseDirectionOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateTilesReverseDirectionOptionPanelLayout.createSequentialGroup().addGap(0, 8, Short.MAX_VALUE).addComponent(this.opGenerateOuterCap, -2, 15, -2)));
        this.options.add(this.opGenerateTilesReverseDirection);
        this.opGenerateTilesReverseDirection.setText("generate tiles, reverse direction");
        this.opGenerateTilesReverseDirection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateTilesReverseDirectionActionPerformed(evt);
            }
        });
        this.opGenerateTilesReverseDirection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateTilesReverseDirectionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CorkscrewGeneratorGUI.this.opGenerateTilesReverseDirectionFocusLost(evt);
            }
        });
        GroupLayout generateOuterCapPanelLayout = new GroupLayout(this.generateOuterCapPanel);
        this.generateOuterCapPanel.setLayout(generateOuterCapPanelLayout);
        generateOuterCapPanelLayout.setHorizontalGroup(generateOuterCapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generateOuterCapPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opGenerateTilesReverseDirection, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateOuterCapPanelLayout.setVerticalGroup(generateOuterCapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOuterCapPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.opGenerateTilesReverseDirection, -2, 14, -2).addContainerGap()));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.cylinderShinglesOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.squareShinglesOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.triShinglesOptionPanel, -2, -1, -2))).addComponent(this.generateTilesOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.generateTilesReverseDirectionOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.generateOuterCapPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cylinderShinglesOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.squareShinglesOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.triShinglesOptionPanel, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateTilesOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateOuterCapPanel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateTilesReverseDirectionOptionPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2).addGap(12, 12, 12)).addComponent(this.subtitlePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionPanel, -2, -1, -2))).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.statusPanel, -2, -1, -2).addGap(12, 12, 12))).addContainerGap(91, Short.MAX_VALUE)));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionPanel, -2, -1, -2).addComponent(this.valuesPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsPanel, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addComponent(this.iconPanel, -2, -1, -2).addGap(10, 10, 10))).addComponent(this.statusPanel, -2, -1, -2).addContainerGap(95, Short.MAX_VALUE)));
        this.scrollPane1.setViewportView(this.viewPanel);
        this.note.setText("Note");
        this.note.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.noteActionPerformed(evt);
            }
        });
        this.noteOnShingles.setText("Note on shingles");
        this.noteOnShingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorkscrewGeneratorGUI.this.noteOnShinglesActionPerformed(evt);
            }
        });
        this.note.add(this.noteOnShingles);
        this.menu.add(this.note);
        this.setJMenuBar(this.menu);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane1, -1, 705, Short.MAX_VALUE).addGap(0, 1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane1, GroupLayout.Alignment.TRAILING, -1, 705, Short.MAX_VALUE));
        this.pack();
    }

    private void inOuterRadiusFocusGained(FocusEvent evt) {
        this.outerRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.outerRadiusTitle);
        this.description.setText(this.outerRadiusDescription);
    }

    private void inOuterRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void outerRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inInnerRadiusFocusGained(FocusEvent evt) {
        this.innerRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.innerRadiusTitle);
        this.description.setText(this.innerRadiusDescription);
    }

    private void inInnerRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesFocusGained(FocusEvent evt) {
        this.slicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesTitle);
        this.description.setText(this.slicesDescription);
    }

    private void inSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inAltitudeFocusGained(FocusEvent evt) {
        this.altitudePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.altitudeTitle);
        this.description.setText(this.altitudeDescription);
    }

    private void inAltitudeFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingCylinderCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingCylinderCutsTitle);
        this.description.setText(this.adjustForOverlappingCylinderCutsDescription);
    }

    private void adjustForOverlappingCylinderCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingCutsPanel.setBackground(this.normal);
    }

    private void inLipFocusGained(FocusEvent evt) {
        this.lipPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.lipTitle);
        this.description.setText(this.lipDescription);
    }

    private void inLipFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        String[] args;
        this.generate.setEnabled(false);
        if (this.opNormal.isSelected()) {
            args = new String[]{this.inOuterRadius.getText(), this.inInnerRadius.getText(), this.inAltitude.getText(), this.inLip.getText(), this.inSlices.getText(), this.inOuterThickness.getText(), this.inInnerThickness.getText(), Boolean.toString(this.adjustForOverlappingCylinderCuts.isSelected()), this.inOffsetAngle.getText()};
            this.status.setText("Generating corkscrew...");
            CorkscrewGenerator.main(args);
        } else if (this.opCylinderShingles.isSelected() || this.opSquareRampShingles.isSelected() || this.opTriRampShingles.isSelected()) {
            int shingles = 0;
            if (this.opCylinderShingles.isSelected()) {
                shingles = 0;
            }
            if (this.opSquareRampShingles.isSelected()) {
                shingles = 1;
            }
            if (this.opTriRampShingles.isSelected()) {
                shingles = 2;
            }
            String[] args2 = new String[]{this.inInnerRadius.getText(), this.inAltitude.getText(), this.inLip.getText(), this.inSlices.getText(), this.inInnerThickness.getText(), Boolean.toString(this.adjustForOverlappingCylinderCuts.isSelected()), Integer.toString(shingles)};
            this.status.setText("Generating shingles...");
            CorkscrewShinglesGenerator.main(args2);
        } else if (this.opGenerateTiles.isSelected() || this.opGenerateTilesReverseDirection.isSelected()) {
            args = new String[]{this.inOuterRadius.getText(), this.inInnerRadius.getText(), this.inAltitude.getText(), this.inLip.getText(), this.inSlices.getText(), Boolean.toString(this.adjustForOverlappingCylinderCuts.isSelected()), Boolean.toString(this.opGenerateTilesReverseDirection.isSelected()), this.inOffsetAngle.getText()};
            this.status.setText("Generating tiles...");
            CorkscrewTilesGenerator.main(args);
        } else if (this.opGenerateOuterCap.isSelected()) {
            args = new String[]{this.inOuterRadius.getText(), this.inAltitude.getText(), this.inSlices.getText(), this.inOuterThickness.getText(), Boolean.toString(this.adjustForOverlappingCylinderCuts.isSelected())};
            this.status.setText("Generating cap...");
            CorkscrewCapGenerator.main(args);
        }
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void inInnerThicknessFocusGained(FocusEvent evt) {
        this.innerThicknessPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.innerThicknessTitle);
        this.description.setText(this.innerThicknessDescription);
    }

    private void inInnerThicknessFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void innerThicknessPanelFocusGained(FocusEvent evt) {
    }

    private void inOuterThicknessFocusGained(FocusEvent evt) {
        this.outerThicknessPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.outerThicknessTitle);
        this.description.setText(this.outerThicknessDescription);
    }

    private void inOuterThicknessFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void outerThicknessPanelFocusGained(FocusEvent evt) {
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opCylinderShinglesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opCylinderShinglesFocusGained(FocusEvent evt) {
        this.cylinderShinglesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opCylinderShinglesTitle);
        this.description.setText(this.opCylinderShinglesDescription);
    }

    private void opCylinderShinglesFocusLost(FocusEvent evt) {
        this.cylinderShinglesOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opSquareRampShinglesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opSquareRampShinglesFocusGained(FocusEvent evt) {
        this.squareShinglesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opSquareRampShinglesTitle);
        this.description.setText(this.opSquareRampShinglesDescription);
    }

    private void opSquareRampShinglesFocusLost(FocusEvent evt) {
        this.squareShinglesOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opTriRampShinglesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opTriRampShinglesFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.triShinglesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opTriRampShinglesTitle);
        this.description.setText(this.opTriRampShinglesDescription);
    }

    private void opTriRampShinglesFocusLost(FocusEvent evt) {
        this.triShinglesOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void inOffsetAngleFocusGained(FocusEvent evt) {
        this.offsetAnglePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetAngleTitle);
        this.description.setText(this.offsetAngleDescription);
    }

    private void inOffsetAngleFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void offsetAnglePanelFocusGained(FocusEvent evt) {
    }

    private void opGenerateTilesFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.generateTilesOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opGenerateTilesTitle);
        this.description.setText(this.opGenerateTilesDescription);
    }

    private void opGenerateTilesFocusLost(FocusEvent evt) {
        this.generateTilesOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opGenerateTilesReverseDirectionFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.generateTilesReverseDirectionOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opGenerateTilesReverseDirectionTitle);
        this.description.setText(this.opGenerateTilesReverseDirectionDescription);
    }

    private void opGenerateTilesReverseDirectionFocusLost(FocusEvent evt) {
        this.generateTilesReverseDirectionOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opGenerateOuterCapFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.generateOuterCapPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opGenerateOuterCapTitle);
        this.description.setText(this.opGenerateOuterCapDescription);
    }

    private void opGenerateOuterCapFocusLost(FocusEvent evt) {
        this.generateOuterCapPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opGenerateTilesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opGenerateTilesReverseDirectionActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opGenerateOuterCapActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inInnerRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inAltitudeActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLipActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterThicknessActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inInnerThicknessActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inOffsetAngleActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void noteActionPerformed(ActionEvent evt) {
    }

    private void noteOnShinglesActionPerformed(ActionEvent evt) {
        this.corkscrewNote.setVisible(true);
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inAltitude.getText());
            this.altitudePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a whole number for altitude\n" : statusText + ex.getMessage() + "\n";
            this.altitudePanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSlices.getText());
            if (temp < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a whole number for slices\n" : statusText + ex.getMessage() + "\n";
            this.slicesPanel.setBackground(Color.red);
        }
        if (this.opGenerateOuterCap.isSelected()) {
            this.inLip.setEnabled(false);
            this.labLip.setEnabled(false);
            this.lipPanel.setBackground(this.normal);
        } else {
            this.inLip.setEnabled(true);
            this.labLip.setEnabled(true);
            try {
                double temp2 = Double.parseDouble(this.inLip.getText());
                if (temp2 < 0.0) {
                    throw new Exception("lip cannot be negative");
                }
                this.lipPanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                generateOK = false;
                statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
                this.lipPanel.setBackground(Color.red);
            }
        }
        if (this.opCylinderShingles.isSelected() || this.opSquareRampShingles.isSelected() || this.opTriRampShingles.isSelected()) {
            this.inOuterRadius.setEnabled(false);
            this.labOuterRadius.setEnabled(false);
            this.outerRadiusPanel.setBackground(this.normal);
        } else {
            this.inOuterRadius.setEnabled(true);
            this.labOuterRadius.setEnabled(true);
            try {
                int temp3 = Integer.parseInt(this.inOuterRadius.getText());
                if (temp3 <= 0) {
                    throw new Exception("outerRadius must be positive");
                }
                if (temp3 <= this.innerRadius) {
                    throw new Exception("outerRadius must be greater than innerRadius");
                }
                this.outerRadius = temp3;
                this.outerRadiusPanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                generateOK = false;
                statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
                this.outerRadiusPanel.setBackground(Color.red);
            }
        }
        if (this.opGenerateOuterCap.isSelected()) {
            this.inInnerRadius.setEnabled(false);
            this.labInnerRadius.setEnabled(false);
            this.innerRadiusPanel.setBackground(this.normal);
        } else {
            this.inInnerRadius.setEnabled(true);
            this.labInnerRadius.setEnabled(true);
            try {
                int temp4 = Integer.parseInt(this.inInnerRadius.getText());
                if (temp4 <= 0) {
                    throw new Exception("innerRadius cannot be negative");
                }
                if (temp4 >= this.outerRadius) {
                    throw new Exception("innerRadius must be less than outerRadius");
                }
                this.innerRadius = temp4;
                this.innerRadiusPanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                generateOK = false;
                this.statusPanel.setBackground(Color.yellow);
                statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
                this.innerRadiusPanel.setBackground(Color.red);
            }
        }
        if (this.opCylinderShingles.isSelected() || this.opSquareRampShingles.isSelected() || this.opTriRampShingles.isSelected() || this.opGenerateTiles.isSelected() || this.opGenerateTilesReverseDirection.isSelected()) {
            this.inOuterThickness.setEnabled(false);
            this.labOuterThickness.setEnabled(false);
            this.outerThicknessPanel.setBackground(this.normal);
        } else {
            this.inOuterThickness.setEnabled(true);
            this.labOuterThickness.setEnabled(true);
            try {
                int temp5 = Integer.parseInt(this.inOuterThickness.getText());
                if (temp5 <= 0) {
                    throw new Exception("outerThickness must be positive");
                }
                if (temp5 <= this.innerThickness) {
                    throw new Exception("outerThickness must be greater than innerThickness");
                }
                this.outerThickness = temp5;
                this.outerThicknessPanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                generateOK = false;
                statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
                this.outerRadiusPanel.setBackground(Color.red);
            }
        }
        if (this.opGenerateOuterCap.isSelected() || this.opGenerateTiles.isSelected() || this.opGenerateTilesReverseDirection.isSelected()) {
            this.inInnerThickness.setEnabled(false);
            this.labInnerThickness.setEnabled(false);
            this.innerThicknessPanel.setBackground(this.normal);
        } else {
            this.inInnerThickness.setEnabled(true);
            this.labInnerThickness.setEnabled(true);
            try {
                int temp6 = Integer.parseInt(this.inInnerThickness.getText());
                if (temp6 <= 0) {
                    throw new Exception("innerThickness cannot be negative");
                }
                if (temp6 >= this.outerThickness) {
                    throw new Exception("innerThickness must be less than outerThickness");
                }
                this.innerThickness = temp6;
                this.innerThicknessPanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                generateOK = false;
                this.statusPanel.setBackground(Color.yellow);
                statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
                this.innerThicknessPanel.setBackground(Color.red);
            }
        }
        if (this.opCylinderShingles.isSelected() || this.opSquareRampShingles.isSelected() || this.opTriRampShingles.isSelected() || this.opGenerateOuterCap.isSelected()) {
            this.inOffsetAngle.setEnabled(false);
            this.labOffsetAngle.setEnabled(false);
            this.offsetAnglePanel.setBackground(this.normal);
        } else {
            this.inOffsetAngle.setEnabled(true);
            this.labOffsetAngle.setEnabled(true);
            try {
                double temp7 = Double.parseDouble(this.inOffsetAngle.getText());
                if (temp7 < 0.0) {
                    throw new Exception("offsetAngle cannot be negative");
                }
                this.offsetAnglePanel.setBackground(this.normal);
            }
            catch (Exception ex) {
                if (ex instanceof NumberFormatException) {
                    this.status.setText("Please enter a number for the offsetAngle");
                } else {
                    this.status.setText(ex.getMessage());
                }
                generateOK = false;
                this.offsetAnglePanel.setBackground(Color.red);
            }
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CorkscrewGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CorkscrewGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CorkscrewGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CorkscrewGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CorkscrewGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

