/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.OffsetPipeGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class OffsetPipeGeneratorGUI
extends JFrame {
    private Config configuration;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String radiusTitle = "Radius";
    private String radiusDescription = "The radius of the face of the pipe.";
    private String slicesTitle = "Slices";
    private String slicesDescription = "The number of individual brushes that will make up the surface of the ramp.";
    private String crossSectionTitle = "Cross Section";
    private String crossSectionDescription = "The height and depth of a quarter pipe. Note that the bottom brush may stick out due to the offset, but that distance is ignored here. ";
    private String lengthTitle = "Length";
    private String lengthDescription = "How long the pipe is. Can also be described as the width of the curved face.";
    private String generateOnlySeamTitle = "Generate Only Seam";
    private String generateOnlySeamDescription = "Generates only the bottom brush. ";
    private String adjustSeamForJoiningTitle = "Adjust Seam For Joining";
    private String adjustSeamForJoiningDescription = "This affects the shape of the bottom brush. Typically, this brush sticks out past the midline of the pipe due to the offset. If this flag is checked, the bottom brush is cut short by the midline, and its end vertex is moved down to lie exactly radius units directly below the circular center of the pipe. ";
    private String opNormalTitle = "Generate normal non-overlapping brushes";
    private String opNormalDescription = "Generates ordinary brushes. To make a slick ramp for jumping purposes, you will either have to add shingles to the ramp or generate overlapping brushes in order to prevent \"bouncing\". Another purpose for normal brushes is to define the visual component of a structure, for example by using surfaceparm nonsolid.";
    private String opOverlappingTitle = "Generate overlapping brushes";
    private String opOverlappingDescription = "Overlapping brushes are useful for making slick ramps (for jumping) such that the player doesn't \"bounce\" off the surface. However, it is not advises to texture the overlapping brush faces with drawn textures. Instead, apply slick caulk which does no damage to all of the overlapping brushes, then superimpose a set of non-overlapping brushes that have surfaceparm nonsolid.";
    private JCheckBox adjustSeamForJoining;
    private JPanel adjustSeamForJoiningPanel;
    private JPanel crossSectionPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JLabel descriptionTitle;
    private JButton generate;
    private JCheckBox generateOnlySeam;
    private JPanel generateOnlySeamPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inCrossSection;
    private JTextField inLength;
    private JTextField inRadius;
    private JTextField inSlices;
    private JScrollPane jScrollPane1;
    private JLabel labCrossSection;
    private JLabel labLength;
    private JLabel labRadius;
    private JLabel labSlices;
    private JPanel lengthPanel;
    private JPanel normalOptionPanel;
    private JRadioButton opNormal;
    private JRadioButton opOverlapping;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel overlappingBrushOptionPanel;
    private JPanel radiusPanel;
    private JScrollPane scrollPane;
    private JPanel slicesPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel valuesPanel;
    private JPanel viewPanel;

    public OffsetPipeGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.viewPanel = new JPanel();
        this.valuesPanel = new JPanel();
        this.radiusPanel = new JPanel();
        this.labRadius = new JLabel();
        this.inRadius = new JTextField();
        this.crossSectionPanel = new JPanel();
        this.labCrossSection = new JLabel();
        this.inCrossSection = new JTextField();
        this.slicesPanel = new JPanel();
        this.labSlices = new JLabel();
        this.inSlices = new JTextField();
        this.lengthPanel = new JPanel();
        this.labLength = new JLabel();
        this.inLength = new JTextField();
        this.adjustSeamForJoiningPanel = new JPanel();
        this.adjustSeamForJoining = new JCheckBox();
        this.generateOnlySeamPanel = new JPanel();
        this.generateOnlySeam = new JCheckBox();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.overlappingBrushOptionPanel = new JPanel();
        this.opOverlapping = new JRadioButton();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.setTitle("Offset Quarter Pipe Generator");
        this.setLocationByPlatform(true);
        this.radiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.radiusPanelFocusGained(evt);
            }
        });
        this.labRadius.setLabelFor(this.inRadius);
        this.labRadius.setText("radius:");
        this.inRadius.setText("512");
        this.inRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inRadiusFocusLost(evt);
            }
        });
        GroupLayout radiusPanelLayout = new GroupLayout(this.radiusPanel);
        this.radiusPanel.setLayout(radiusPanelLayout);
        radiusPanelLayout.setHorizontalGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(radiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRadius, -2, 64, -2).addContainerGap()));
        radiusPanelLayout.setVerticalGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, radiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labRadius).addComponent(this.inRadius, -2, -1, -2)).addContainerGap()));
        this.labCrossSection.setLabelFor(this.inCrossSection);
        this.labCrossSection.setText("crossSection:");
        this.inCrossSection.setText("768");
        this.inCrossSection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inCrossSectionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inCrossSectionFocusLost(evt);
            }
        });
        GroupLayout crossSectionPanelLayout = new GroupLayout(this.crossSectionPanel);
        this.crossSectionPanel.setLayout(crossSectionPanelLayout);
        crossSectionPanelLayout.setHorizontalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCrossSection).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCrossSection, -2, 64, -2).addContainerGap()));
        crossSectionPanelLayout.setVerticalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCrossSection).addComponent(this.inCrossSection, -2, -1, -2)).addContainerGap()));
        this.labSlices.setLabelFor(this.inSlices);
        this.labSlices.setText("slices:");
        this.inSlices.setText("24");
        this.inSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inSlicesFocusLost(evt);
            }
        });
        GroupLayout slicesPanelLayout = new GroupLayout(this.slicesPanel);
        this.slicesPanel.setLayout(slicesPanelLayout);
        slicesPanelLayout.setHorizontalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlices, -2, 64, -2).addContainerGap()));
        slicesPanelLayout.setVerticalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlices).addComponent(this.inSlices, -2, -1, -2)).addContainerGap()));
        this.labLength.setLabelFor(this.inLength);
        this.labLength.setText("length:");
        this.inLength.setText("256");
        this.inLength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inLengthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.inLengthFocusLost(evt);
            }
        });
        GroupLayout lengthPanelLayout = new GroupLayout(this.lengthPanel);
        this.lengthPanel.setLayout(lengthPanelLayout);
        lengthPanelLayout.setHorizontalGroup(lengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labLength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLength, -2, 64, -2).addContainerGap()));
        lengthPanelLayout.setVerticalGroup(lengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(lengthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labLength).addComponent(this.inLength, -2, -1, -2))));
        this.adjustSeamForJoining.setText("adjustSeamForJoining");
        this.adjustSeamForJoining.setHorizontalAlignment(11);
        this.adjustSeamForJoining.setHorizontalTextPosition(10);
        this.adjustSeamForJoining.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.adjustSeamForJoiningFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.adjustSeamForJoiningFocusLost(evt);
            }
        });
        GroupLayout adjustSeamForJoiningPanelLayout = new GroupLayout(this.adjustSeamForJoiningPanel);
        this.adjustSeamForJoiningPanel.setLayout(adjustSeamForJoiningPanelLayout);
        adjustSeamForJoiningPanelLayout.setHorizontalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustSeamForJoiningPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.adjustSeamForJoining).addContainerGap()));
        adjustSeamForJoiningPanelLayout.setVerticalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustSeamForJoiningPanelLayout.createSequentialGroup().addGap(0, 10, Short.MAX_VALUE).addComponent(this.adjustSeamForJoining, -2, 23, -2)));
        this.generateOnlySeam.setText("generateOnlySeam");
        this.generateOnlySeam.setActionCommand("");
        this.generateOnlySeam.setHorizontalAlignment(11);
        this.generateOnlySeam.setHorizontalTextPosition(10);
        this.generateOnlySeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetPipeGeneratorGUI.this.generateOnlySeamActionPerformed(evt);
            }
        });
        this.generateOnlySeam.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.generateOnlySeamFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.generateOnlySeamFocusLost(evt);
            }
        });
        GroupLayout generateOnlySeamPanelLayout = new GroupLayout(this.generateOnlySeamPanel);
        this.generateOnlySeamPanel.setLayout(generateOnlySeamPanelLayout);
        generateOnlySeamPanelLayout.setHorizontalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.generateOnlySeam).addContainerGap()));
        generateOnlySeamPanelLayout.setVerticalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.generateOnlySeam, -2, 23, -2).addContainerGap()));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.radiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.crossSectionPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lengthPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.adjustSeamForJoiningPanel, -1, -1, Short.MAX_VALUE).addComponent(this.generateOnlySeamPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(20, Short.MAX_VALUE)));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.radiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossSectionPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lengthPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generateOnlySeamPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustSeamForJoiningPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("The vertices for the curve are rotated downwards by half of a slice.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, subtitlePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.subtitle, -2, 565, -2).addGap(27, 27, 27)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descriptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane1)).addComponent(this.descriptionTitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 228, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetPipeGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opOverlapping);
        this.opOverlapping.setText("generate overlapping brushes");
        this.opOverlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetPipeGeneratorGUI.this.opOverlappingActionPerformed(evt);
            }
        });
        this.opOverlapping.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.opOverlappingFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetPipeGeneratorGUI.this.opOverlappingFocusLost(evt);
            }
        });
        GroupLayout overlappingBrushOptionPanelLayout = new GroupLayout(this.overlappingBrushOptionPanel);
        this.overlappingBrushOptionPanel.setLayout(overlappingBrushOptionPanelLayout);
        overlappingBrushOptionPanelLayout.setHorizontalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overlappingBrushOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opOverlapping).addContainerGap(-1, Short.MAX_VALUE)));
        overlappingBrushOptionPanelLayout.setVerticalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opOverlapping));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.overlappingBrushOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingBrushOptionPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetPipeGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generate).addGap(18, 18, 18)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.generate)).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -2, 45, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/offset-pipe.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -2, 243, -2).addContainerGap(-1, Short.MAX_VALUE)));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.subtitlePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, viewPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.valuesPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.descriptionPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, viewPanelLayout.createSequentialGroup().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.iconPanel, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.valuesPanel, -2, -1, -2).addComponent(this.descriptionPanel, -2, -1, -2)).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addGap(51, 51, 51).addComponent(this.optionsPanel, -2, -1, -2)).addGroup(viewPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.statusPanel, -2, -1, -2)));
        this.scrollPane.setViewportView(this.viewPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPane).addGap(0, 0, 0)));
        this.pack();
    }

    private void inRadiusFocusGained(FocusEvent evt) {
        this.radiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.radiusTitle);
        this.description.setText(this.radiusDescription);
    }

    private void inRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void radiusPanelFocusGained(FocusEvent evt) {
    }

    private void inCrossSectionFocusGained(FocusEvent evt) {
        this.crossSectionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.crossSectionTitle);
        this.description.setText(this.crossSectionDescription);
    }

    private void inCrossSectionFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesFocusGained(FocusEvent evt) {
        this.slicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesTitle);
        this.description.setText(this.slicesDescription);
    }

    private void inSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inLengthFocusGained(FocusEvent evt) {
        this.lengthPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.lengthTitle);
        this.description.setText(this.lengthDescription);
    }

    private void inLengthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateOnlySeamFocusGained(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.generateOnlySeamTitle);
        this.description.setText(this.generateOnlySeamDescription);
    }

    private void generateOnlySeamFocusLost(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.normal);
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        String[] args = new String[]{this.inRadius.getText(), this.inSlices.getText(), this.inCrossSection.getText(), this.inLength.getText(), Boolean.toString(this.opOverlapping.isSelected()), Boolean.toString(this.generateOnlySeam.isSelected()), Boolean.toString(this.adjustSeamForJoining.isSelected())};
        this.status.setText("Generating offset cylinder...");
        OffsetPipeGenerator.main(args);
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void generateOnlySeamActionPerformed(ActionEvent evt) {
    }

    private void opOverlappingFocusLost(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opOverlappingFocusGained(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opOverlappingTitle);
        this.description.setText(this.opOverlappingDescription);
    }

    private void opOverlappingActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustSeamForJoiningFocusGained(FocusEvent evt) {
        this.adjustSeamForJoining.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustSeamForJoiningTitle);
        this.description.setText(this.adjustSeamForJoiningDescription);
    }

    private void adjustSeamForJoiningFocusLost(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.normal);
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inRadius.getText());
            if (temp <= 0) {
                throw new Exception("outerRadius must be positive");
            }
            this.radiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.radiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSlices.getText());
            if (temp < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slicesPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inLength.getText());
            if (temp2 <= 1) {
                throw new Exception("Min length is 1");
            }
            this.lengthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.lengthPanel.setBackground(Color.red);
        }
        this.labCrossSection.setEnabled(true);
        this.inCrossSection.setEnabled(true);
        try {
            int temp3 = Integer.parseInt(this.inCrossSection.getText());
            if (temp3 <= 0) {
                throw new Exception("inCrossSection cannot be negative");
            }
            this.crossSectionPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.crossSectionPanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(OffsetPipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(OffsetPipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(OffsetPipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(OffsetPipeGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OffsetPipeGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

