/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class OverlappingVolcanoGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        int j;
        int i;
        Thread.currentThread().setPriority(1);
        int topCircumferenceRadius = Integer.parseInt(args[0]);
        int slopeRadius = Integer.parseInt(args[1]);
        int slicesCircumference = Integer.parseInt(args[2]);
        int slicesSlope = Integer.parseInt(args[3]);
        int crossSection = Integer.parseInt(args[4]);
        boolean offsetTopInsteadOfBottom = Boolean.valueOf(args[5]);
        int extrudeTopNSlices = Integer.parseInt(args[6]);
        double extrudeRadiusFactor = Double.parseDouble(args[7]);
        boolean adjustForOverlappingPipeCuts = Boolean.valueOf(args[8]);
        boolean adjustForOverlappingBowlCuts = Boolean.valueOf(args[9]);
        boolean invertSlopeVertices = Boolean.valueOf(args[10]);
        boolean generateOnlySeam = Boolean.valueOf(args[11]);
        boolean adjustSeamForJoining = Boolean.valueOf(args[12]);
        boolean cutTop = Boolean.valueOf(args[13]);
        boolean cutBottom = Boolean.valueOf(args[14]);
        int adjustMask = 0;
        if (adjustForOverlappingBowlCuts) {
            adjustMask |= 2;
        }
        if (adjustForOverlappingPipeCuts) {
            adjustMask |= 1;
        }
        Point3D[] curve = OverlappingVolcanoGenerator.generatePipeCurve(slopeRadius, slicesSlope, extrudeTopNSlices, extrudeRadiusFactor, adjustMask);
        if (invertSlopeVertices) {
            Point3D[] newCurve = new Point3D[curve.length];
            for (int i2 = 0; i2 < curve.length; ++i2) {
                newCurve[curve.length - i2 - 1] = new Point3D(-curve[i2].z, curve[i2].y, -curve[i2].x);
            }
            curve = newCurve;
        }
        for (int i3 = 0; i3 < curve.length; ++i3) {
            curve[i3] = new Point3D(curve[i3].x - (double)(topCircumferenceRadius + slopeRadius), curve[i3].y, curve[i3].z);
        }
        Point3D[][] extCurve = new Point3D[slicesSlope][2];
        Point3D[][][] mesh = new Point3D[slicesCircumference + 1][slicesSlope][2];
        for (int i4 = 0; i4 < slicesSlope; ++i4) {
            extCurve[i4][0] = i4 == 0 && cutTop ? curve[i4] : new Point3D(curve[i4].x + (curve[i4].x - curve[i4 + 1].x), curve[i4].y + (curve[i4].y - curve[i4 + 1].y), curve[i4].z + (curve[i4].z - curve[i4 + 1].z));
            mesh[0][i4][0] = extCurve[i4][0];
            extCurve[i4][1] = i4 == slicesSlope - 1 && cutBottom ? curve[i4 + 1] : new Point3D(curve[i4 + 1].x + (curve[i4 + 1].x - curve[i4].x), curve[i4 + 1].y + (curve[i4 + 1].y - curve[i4].y), curve[i4 + 1].z + (curve[i4 + 1].z - curve[i4].z));
            mesh[0][i4][1] = extCurve[i4][1];
        }
        AxisRotation3D rot = new AxisRotation3D(4, Math.PI / (double)(4 * slicesCircumference));
        for (i = 0; i < slicesSlope; ++i) {
            if (!offsetTopInsteadOfBottom) {
                mesh[0][i][(i + 1) % 2] = rot.transform(mesh[0][i][(i + 1) % 2]);
                continue;
            }
            mesh[0][i][(i + 0) % 2] = rot.transform(mesh[0][i][(i + 0) % 2]);
        }
        for (i = 1; i <= slicesCircumference; ++i) {
            rot = new AxisRotation3D(4, Math.PI * (double)i / (double)(2 * slicesCircumference));
            for (j = 0; j < slicesSlope; ++j) {
                mesh[i][j][0] = rot.transform(mesh[0][j][0]);
                mesh[i][j][1] = rot.transform(mesh[0][j][1]);
            }
        }
        if (adjustSeamForJoining) {
            for (i = 0; i < slicesSlope; ++i) {
                if (!offsetTopInsteadOfBottom) {
                    mesh[slicesCircumference][i][(i + 1) % 2] = new Point3D(0.0, extCurve[i][(i + 1) % 2].x, extCurve[i][(i + 1) % 2].z);
                    continue;
                }
                mesh[slicesCircumference][i][(i + 0) % 2] = new Point3D(0.0, extCurve[i][(i + 0) % 2].x, extCurve[i][(i + 1) % 2].z);
            }
        }
        OverlappingVolcanoGenerator.startMap();
        for (i = 0; i < slicesCircumference * 2; ++i) {
            if (generateOnlySeam && i != slicesCircumference * 2 - 1) continue;
            for (j = 0; j < slicesSlope; ++j) {
                Point3D pt6;
                Point3D pt5;
                Point3D pt4;
                Point3D pt3;
                Point3D pt2;
                Point3D pt1;
                if (i % 2 == 0) {
                    if (!offsetTopInsteadOfBottom && j % 2 == 0 || offsetTopInsteadOfBottom && j % 2 == 1) {
                        pt1 = mesh[i / 2][j][0];
                        pt2 = mesh[i / 2 + 1][j][0];
                        pt3 = mesh[i / 2][j][1];
                    } else {
                        pt1 = mesh[i / 2 + 1][j][1];
                        pt2 = mesh[i / 2][j][1];
                        pt3 = mesh[i / 2][j][0];
                    }
                } else if (!offsetTopInsteadOfBottom && j % 2 == 0 || offsetTopInsteadOfBottom && j % 2 == 1) {
                    pt1 = mesh[i / 2 + 1][j][1];
                    pt2 = mesh[i / 2][j][1];
                    pt3 = mesh[i / 2 + 1][j][0];
                } else {
                    pt1 = mesh[i / 2][j][0];
                    pt2 = mesh[i / 2 + 1][j][0];
                    pt3 = mesh[i / 2 + 1][j][1];
                }
                if (j >= (slicesSlope + 1) / 2) {
                    OverlappingVolcanoGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt3, false);
                    continue;
                }
                if (i < slicesCircumference - 1) {
                    pt4 = new Point3D(pt1.y, pt1.y, pt1.z);
                    pt5 = new Point3D(pt2.y, pt2.y, pt2.z);
                    pt6 = new Point3D(pt3.y, pt3.y, pt3.z);
                } else if (i > slicesCircumference - 1) {
                    pt4 = new Point3D(pt1.x, pt1.x, pt1.z);
                    pt5 = new Point3D(pt2.x, pt2.x, pt2.z);
                    pt6 = new Point3D(pt3.x, pt3.x, pt3.z);
                } else {
                    boolean oddSlices;
                    pt6 = null;
                    boolean offset = offsetTopInsteadOfBottom;
                    boolean oddRow = j % 2 != 0;
                    boolean bl = oddSlices = slicesCircumference % 2 != 0;
                    pt4 = offset ^ oddRow ? (oddSlices ? mesh[slicesCircumference / 2 + 1][j][1] : mesh[slicesCircumference / 2][j][0]) : (oddSlices ? mesh[slicesCircumference / 2 + 1][j][0] : mesh[slicesCircumference / 2][j][1]);
                    pt5 = new Point3D(pt4.x, pt4.x, pt4.z);
                    OverlappingVolcanoGenerator.startBrush();
                    OverlappingVolcanoGenerator.writeFace(pt1, pt2, pt3);
                    OverlappingVolcanoGenerator.writeFace(pt1, pt5, pt2);
                    OverlappingVolcanoGenerator.writeFace(pt2, pt5, pt3);
                    OverlappingVolcanoGenerator.writeFace(pt3, pt5, pt1);
                    OverlappingVolcanoGenerator.endBrush();
                }
                if (pt6 == null) continue;
                OverlappingVolcanoGenerator.startBrush();
                OverlappingVolcanoGenerator.writeFace(pt1, pt2, pt3);
                OverlappingVolcanoGenerator.writeFace(pt4, pt6, pt5);
                if (OverlappingVolcanoGenerator.equals(pt1, pt4)) {
                    OverlappingVolcanoGenerator.writeFace(pt2, pt1, pt5);
                } else {
                    OverlappingVolcanoGenerator.writeFace(pt2, pt1, pt4);
                }
                if (OverlappingVolcanoGenerator.equals(pt2, pt5)) {
                    OverlappingVolcanoGenerator.writeFace(pt3, pt2, pt6);
                } else {
                    OverlappingVolcanoGenerator.writeFace(pt3, pt2, pt5);
                }
                if (OverlappingVolcanoGenerator.equals(pt3, pt6)) {
                    OverlappingVolcanoGenerator.writeFace(pt1, pt3, pt4);
                } else {
                    OverlappingVolcanoGenerator.writeFace(pt1, pt3, pt6);
                }
                if (i == slicesCircumference * 2 - 1 && !adjustSeamForJoining) {
                    OverlappingVolcanoGenerator.writeFace(new Point3D(128.0, -128.0, 0.0), new Point3D(0.0, 0.0, 0.0), new Point3D(0.0, 0.0, -128.0));
                }
                OverlappingVolcanoGenerator.endBrush();
            }
        }
        OverlappingVolcanoGenerator.endMap();
    }
}

