/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import generators.GenerationUtils;

public final class PipeGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int radius = Integer.parseInt(args[0]);
        int slices = Integer.parseInt(args[1]);
        int crossSection = Integer.parseInt(args[2]);
        int length = Integer.parseInt(args[3]);
        boolean overlappingBrushes = Boolean.valueOf(args[4]);
        int extrudeTopNSlices = Integer.parseInt(args[5]);
        double extrudeRadiusFactor = Double.parseDouble(args[6]);
        boolean adjustForOverlappingPipeCuts = Boolean.valueOf(args[7]);
        boolean adjustForOverlappingBowlCuts = Boolean.valueOf(args[8]);
        int adjustMask = 0;
        if (adjustForOverlappingBowlCuts) {
            adjustMask |= 2;
        }
        if (adjustForOverlappingPipeCuts) {
            adjustMask |= 1;
        }
        Point3D[] curve = PipeGenerator.generatePipeCurve(radius, slices, extrudeTopNSlices, extrudeRadiusFactor, adjustMask);
        PipeGenerator.startMap();
        for (int i = 0; i < slices; ++i) {
            Point3D pt4;
            Point3D pt3;
            Point3D pt2;
            Point3D pt1;
            if (!overlappingBrushes) {
                pt1 = curve[i];
                pt2 = curve[i + 1];
                pt3 = new Point3D(pt2.x, pt2.y + (double)length, pt2.z);
                pt4 = new Point3D(pt1.x, pt2.y + (double)length, pt1.z);
            } else {
                double pt1x = Math.round(curve[i].x);
                double pt1z = Math.round(curve[i].z);
                double pt2x = Math.round(curve[i + 1].x);
                double pt2z = Math.round(curve[i + 1].z);
                double y = curve[i].y;
                pt1 = new Point3D(pt1x + (pt1x - pt2x), y, pt1z + (pt1z - pt2z));
                pt2 = new Point3D(pt2x + (pt2x - pt1x), y, pt2z + (pt2z - pt1z));
                pt3 = new Point3D(pt2.x, y + (double)length, pt2.z);
                pt4 = new Point3D(pt1.x, y + (double)length, pt1.z);
            }
            if (i < (slices + 1) / 2) {
                PipeGenerator.writeBrushExtendX(crossSection, pt1, pt2, pt3, pt4);
                continue;
            }
            PipeGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt3, pt4);
            if (i != (slices + 1) / 2 || overlappingBrushes) continue;
            PipeGenerator.writeBrushExtendZ(-crossSection, curve[i], new Point3D(curve[i].x, curve[i].y + (double)length, curve[i].z), new Point3D(crossSection, curve[i].y + (double)length, curve[i].z), new Point3D(crossSection, curve[i].y, curve[i].z));
        }
        PipeGenerator.endMap();
    }
}

