/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.OffsetCylinderGenerator;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class OffsetCylinderGeneratorGUI
extends JFrame {
    public static final int SHINGLES_TYPE_CYL = 0;
    public static final int SHINGLES_TYPE_RAMP_SQTOP = 1;
    public static final int SHINGLES_TYPE_RAMP_TRITOP = 2;
    private Config configuration;
    private int outerRadius = 768;
    private int innerRadius = 512;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String outerRadiusTitle = "Outer Radius";
    private String outerRadiusDescription = "The radius of the outside of the cylinder.";
    private String innerRadiusTitle = "Inner Radius";
    private String innerRadiusDescription = "The radius of the inside of the cylinder. This may be zero to generate a disc. ";
    private String slicesTitle = "Slices";
    private String slicesDescription = "The number of individual brushes to be generated.";
    private String heightTitle = "Height";
    private String heightDescription = "How tall the cylinder is.";
    private String adjustSeamForJoiningTitle = "Adjust Seam For Joining";
    private String adjustSeamForJoiningDescription = "This affects the shape of the seam. Typically, this brush sticks out past the midline of the cylinder due to the offset. If this flag is checked, the brush is cut short by the midline (the plane x = 0), and its end vertices are moved down to lie exactly outerRadius and innerRadius units directly above the circular center of the cylinder. ";
    private String generateOnlySeamTitle = "Generate Only Seam";
    private String generateOnlySeamDescription = "Generates only the brush at the very top of the quarter cylinder. This is the brush that extends past the plane x = 0 (the midway divider).";
    private String opNormalTitle = "Generate normal non-overlapping brushes";
    private String opNormalDescription = "Generates ordinary brushes. To make a cylinder wall to fling you around at high speeds, you will either have to add shingles to the cylinder or generate overlapping brushes in order to prevent \"bouncing\". Another purpose for normal brushes is to define the visual component of a structure, for example by using surfaceparm nosolid.";
    private String opOverlappingTitle = "Generate overlapping brushes";
    private String opOverlappingDescription = "Overlapping brushes are useful for making cylinders such that the player doesn't \"bounce\" off the surface when flying against the wall of the inside of the cylinder at high speeds. However, it is not advised to texture the overlapping brush faces with drawn textures. Instead, apply caulk to all of the overlapping brushes, then superimpose a set of normal non-overlapping brushes that have surfaceparm nonsolid.";
    private String opCylinderShinglesTitle = "Generate cylinder shingles";
    private String opCylinderShinglesDescription = "Can be used together with non-overlapping brushes to create smooth surfaces that allow for high speeds while clinging to the inside of a cylinder. These shingles are one-directional.";
    private String opSquareRampShinglesTitle = "Generate ramp shingles, top shingle square";
    private String opSquareRampShinglesDescription = "Shingles useful if the cylinder is turned upwards to form a vertical ramp. The top shingle is square to prevent lemmings.";
    private String opTriRampShinglesTitle = "Generate ramp shingles, top shingle triangular";
    private String opTriRampShinglesDescription = "Shingles useful if the cylinder is turned upwards to form a vertical ramp. The top shingle is triangular, making the shingles suitable for the last quarter of a vertical loop.";
    private String opOuterCapTitle = "Generate outer cap";
    private String opOuterCapDescription = "Can be applied to the outside of a cylinder. This is especially useful when the cylinder is flipped horizontally, and when players will be falling onto the top of the cylinder. The cap prevents lemmings.";
    private JCheckBox adjustSeamForJoining;
    private JPanel adjustSeamForJoiningPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JLabel descriptionTitle;
    private JButton generate;
    private JCheckBox generateOnlySeam;
    private JPanel generateOnlySeamPanel;
    private JPanel heightPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inHeight;
    private JTextField inInnerRadius;
    private JTextField inOuterRadius;
    private JTextField inSlices;
    private JPanel innerRadiusPanel;
    private JScrollPane jScrollPane1;
    private JLabel labHeight;
    private JLabel labInnerRadius;
    private JLabel labOuterRadius;
    private JLabel labSlices;
    private JPanel normalOptionPanel;
    private JRadioButton opNormal;
    private JRadioButton opOverlapping;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel outerRadiusPanel;
    private JPanel overlappingBrushOptionPanel;
    private JPanel slicesPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel valuesPanel;

    public OffsetCylinderGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.valuesPanel = new JPanel();
        this.outerRadiusPanel = new JPanel();
        this.labOuterRadius = new JLabel();
        this.inOuterRadius = new JTextField();
        this.innerRadiusPanel = new JPanel();
        this.labInnerRadius = new JLabel();
        this.inInnerRadius = new JTextField();
        this.slicesPanel = new JPanel();
        this.labSlices = new JLabel();
        this.inSlices = new JTextField();
        this.heightPanel = new JPanel();
        this.labHeight = new JLabel();
        this.inHeight = new JTextField();
        this.generateOnlySeamPanel = new JPanel();
        this.generateOnlySeam = new JCheckBox();
        this.adjustSeamForJoiningPanel = new JPanel();
        this.adjustSeamForJoining = new JCheckBox();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.overlappingBrushOptionPanel = new JPanel();
        this.opOverlapping = new JRadioButton();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.setTitle("Offset Cylinder Generator");
        this.setLocationByPlatform(true);
        this.outerRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.outerRadiusPanelFocusGained(evt);
            }
        });
        this.labOuterRadius.setLabelFor(this.inOuterRadius);
        this.labOuterRadius.setText("outerRadius:");
        this.inOuterRadius.setText("768");
        this.inOuterRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inOuterRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inOuterRadiusFocusLost(evt);
            }
        });
        GroupLayout outerRadiusPanelLayout = new GroupLayout(this.outerRadiusPanel);
        this.outerRadiusPanel.setLayout(outerRadiusPanelLayout);
        outerRadiusPanelLayout.setHorizontalGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOuterRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOuterRadius, -2, 64, -2).addContainerGap()));
        outerRadiusPanelLayout.setVerticalGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOuterRadius).addComponent(this.inOuterRadius, -2, -1, -2)).addContainerGap()));
        this.labInnerRadius.setLabelFor(this.inInnerRadius);
        this.labInnerRadius.setText("innerRadius:");
        this.inInnerRadius.setText("512");
        this.inInnerRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inInnerRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inInnerRadiusFocusLost(evt);
            }
        });
        GroupLayout innerRadiusPanelLayout = new GroupLayout(this.innerRadiusPanel);
        this.innerRadiusPanel.setLayout(innerRadiusPanelLayout);
        innerRadiusPanelLayout.setHorizontalGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labInnerRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inInnerRadius, -2, 64, -2).addContainerGap()));
        innerRadiusPanelLayout.setVerticalGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, innerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labInnerRadius).addComponent(this.inInnerRadius, -2, -1, -2)).addContainerGap()));
        this.labSlices.setLabelFor(this.inSlices);
        this.labSlices.setText("slices:");
        this.inSlices.setText("24");
        this.inSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inSlicesFocusLost(evt);
            }
        });
        GroupLayout slicesPanelLayout = new GroupLayout(this.slicesPanel);
        this.slicesPanel.setLayout(slicesPanelLayout);
        slicesPanelLayout.setHorizontalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlices, -2, 64, -2).addContainerGap()));
        slicesPanelLayout.setVerticalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlices).addComponent(this.inSlices, -2, -1, -2)).addContainerGap()));
        this.labHeight.setLabelFor(this.inHeight);
        this.labHeight.setText("height:");
        this.inHeight.setText("256");
        this.inHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inHeightFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.inHeightFocusLost(evt);
            }
        });
        GroupLayout heightPanelLayout = new GroupLayout(this.heightPanel);
        this.heightPanel.setLayout(heightPanelLayout);
        heightPanelLayout.setHorizontalGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(heightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labHeight).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inHeight, -2, 64, -2).addContainerGap()));
        heightPanelLayout.setVerticalGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(heightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labHeight).addComponent(this.inHeight, -2, -1, -2))));
        this.generateOnlySeam.setText("generateOnlySeam");
        this.generateOnlySeam.setHorizontalAlignment(11);
        this.generateOnlySeam.setHorizontalTextPosition(10);
        this.generateOnlySeam.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.generateOnlySeamFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.generateOnlySeamFocusLost(evt);
            }
        });
        GroupLayout generateOnlySeamPanelLayout = new GroupLayout(this.generateOnlySeamPanel);
        this.generateOnlySeamPanel.setLayout(generateOnlySeamPanelLayout);
        generateOnlySeamPanelLayout.setHorizontalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateOnlySeam, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateOnlySeamPanelLayout.setVerticalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.generateOnlySeam).addContainerGap()));
        this.adjustSeamForJoining.setText("adjustSeamForJoining");
        this.adjustSeamForJoining.setHorizontalAlignment(11);
        this.adjustSeamForJoining.setHorizontalTextPosition(10);
        this.adjustSeamForJoining.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.adjustSeamForJoiningFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.adjustSeamForJoiningFocusLost(evt);
            }
        });
        GroupLayout adjustSeamForJoiningPanelLayout = new GroupLayout(this.adjustSeamForJoiningPanel);
        this.adjustSeamForJoiningPanel.setLayout(adjustSeamForJoiningPanelLayout);
        adjustSeamForJoiningPanelLayout.setHorizontalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustSeamForJoiningPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustSeamForJoining, -1, -1, Short.MAX_VALUE).addContainerGap()));
        adjustSeamForJoiningPanelLayout.setVerticalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustSeamForJoiningPanelLayout.createSequentialGroup().addGap(0, 9, Short.MAX_VALUE).addComponent(this.adjustSeamForJoining)));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.outerRadiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.innerRadiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.heightPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.generateOnlySeamPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.adjustSeamForJoiningPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.outerRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateOnlySeamPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustSeamForJoiningPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("The vertices are rotated counter-clockwise by a half of a slice.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, -1, Short.MAX_VALUE).addContainerGap()));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 186, -2).addContainerGap()));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetCylinderGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opOverlapping);
        this.opOverlapping.setText("generate overlapping brushes");
        this.opOverlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetCylinderGeneratorGUI.this.opOverlappingActionPerformed(evt);
            }
        });
        this.opOverlapping.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.opOverlappingFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OffsetCylinderGeneratorGUI.this.opOverlappingFocusLost(evt);
            }
        });
        GroupLayout overlappingBrushOptionPanelLayout = new GroupLayout(this.overlappingBrushOptionPanel);
        this.overlappingBrushOptionPanel.setLayout(overlappingBrushOptionPanelLayout);
        overlappingBrushOptionPanelLayout.setHorizontalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overlappingBrushOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opOverlapping).addContainerGap(-1, Short.MAX_VALUE)));
        overlappingBrushOptionPanelLayout.setVerticalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opOverlapping));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.overlappingBrushOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE)).addGap(0, 12, Short.MAX_VALUE)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingBrushOptionPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OffsetCylinderGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generate).addGap(18, 18, 18)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -1, 46, Short.MAX_VALUE).addContainerGap()).addGroup(statusPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.generate).addContainerGap(-1, Short.MAX_VALUE)));
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/offsetCylinder.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.icon, -2, 229, -2).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.icon, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.subtitlePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.statusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.optionsPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.iconPanel, -2, -1, -2))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addGap(39, 39, 39).addComponent(this.descriptionPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.valuesPanel, -2, -1, -2).addComponent(this.descriptionPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.iconPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(69, 69, 69).addComponent(this.optionsPanel, -2, -1, -2).addGap(86, 86, 86))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void inOuterRadiusFocusGained(FocusEvent evt) {
        this.outerRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.outerRadiusTitle);
        this.description.setText(this.outerRadiusDescription);
    }

    private void inOuterRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void outerRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inInnerRadiusFocusGained(FocusEvent evt) {
        this.innerRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.innerRadiusTitle);
        this.description.setText(this.innerRadiusDescription);
    }

    private void inInnerRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesFocusGained(FocusEvent evt) {
        this.slicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesTitle);
        this.description.setText(this.slicesDescription);
    }

    private void inSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inHeightFocusGained(FocusEvent evt) {
        this.heightPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.heightTitle);
        this.description.setText(this.heightDescription);
    }

    private void inHeightFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateOnlySeamFocusGained(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.generateOnlySeamTitle);
        this.description.setText(this.generateOnlySeamDescription);
    }

    private void generateOnlySeamFocusLost(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.normal);
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opOverlappingFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.overlappingBrushOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opOverlappingTitle);
        this.description.setText(this.opOverlappingDescription);
    }

    private void opOverlappingFocusLost(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void opOverlappingActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        String[] args = new String[]{this.inOuterRadius.getText(), this.inInnerRadius.getText(), this.inSlices.getText(), this.inHeight.getText(), Boolean.toString(this.opOverlapping.isSelected()), Boolean.toString(this.generateOnlySeam.isSelected()), Boolean.toString(this.adjustSeamForJoining.isSelected())};
        this.status.setText("Generating offset cylinder...");
        OffsetCylinderGenerator.main(args);
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void adjustSeamForJoiningFocusGained(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustSeamForJoiningTitle);
        this.description.setText(this.adjustSeamForJoiningDescription);
    }

    private void adjustSeamForJoiningFocusLost(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.normal);
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inHeight.getText());
            if (temp <= 1) {
                throw new Exception("Min height is 1");
            }
            this.heightPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.heightPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSlices.getText());
            if (temp < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slicesPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inOuterRadius.getText());
            if (temp2 <= 0) {
                throw new Exception("outerRadius must be positive");
            }
            if (temp2 <= this.innerRadius) {
                throw new Exception("outerRadius must be greater than innerRadius");
            }
            this.outerRadius = temp2;
            this.outerRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.outerRadiusPanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inInnerRadius.getText());
            if (temp3 <= 0) {
                throw new Exception("innerRadius cannot be negative");
            }
            if ((this.opNormal.isSelected() || this.opOverlapping.isSelected()) && temp3 >= this.outerRadius) {
                throw new Exception("innerRadius must be less than outerRadius");
            }
            this.innerRadius = temp3;
            this.innerRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.innerRadiusPanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(OffsetCylinderGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(OffsetCylinderGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(OffsetCylinderGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(OffsetCylinderGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OffsetCylinderGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

