/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package main;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;

/**
 *
 * @author edward
 */
public class Config {
    
    private final File configFile = new File("surface_generator.config");
    private File workingDirectory;
    private int screenWidth;
    private int screenHeight;
    
    /**
     * Load the configuration from file
     */
    public Config()
    {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        screenWidth = screenSize.width;
        screenHeight = screenSize.height;
        
        try(BufferedReader reader = new BufferedReader(new FileReader(configFile)))
        {            
            String line = null;
            
            while((line = reader.readLine()) != null)
            {
                String[] token = line.split("\t");
                if(token[0].equals("workingDirectory"))
                    setWorkingDirectory(new File(token[1]));
            }
        }
        catch(IOException io)
        {
            // do nothing for now
        }
        
    }
    
    /**
     * Save the configuration to file
     */
    private void saveConfig()
    {   
        try(PrintWriter writer = new PrintWriter(new FileWriter(configFile)))
        {   
            if(workingDirectory != null)
                writer.println("workingDirectory\t" + workingDirectory.getAbsolutePath());
        }
        catch(IOException io)
        {
            // do nothing for now
        }
        
    }
    
    /**
     * accessor for the current working directory. Will return null if not set
     * @return the current working directory, or null if unset.
     */
    public File getWorkingDirectory()
    {
        return workingDirectory;
    }
    
    /**
     * sets the working directory and saves the configuration to file. If null or not a directory, does nothing
     * @param newWorkingDirectory the new working directory.
     */
    public void setWorkingDirectory(File newWorkingDirectory)
    {
        if(newWorkingDirectory != null & newWorkingDirectory.isDirectory())
        {
            workingDirectory = newWorkingDirectory;
            saveConfig();
        }
    }
    
    /**
     * Returns the screen height as an int
     * @return the screen height
     */
    public int getScreenHeight()
    {
        return screenHeight;
    }
    
    /**
     * Returns the screen width as an int
     * @return the screen height
     */
    public int getScreenWidth()
    {
        return screenWidth;
    }
}
