//---------------------------------------------------------------------------
// Command & Conquer AUD sound file plugin
// Pseudo code source: http://www.geocities.com/SiliconValley/8682/aud3.txt
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
//---------------------------------------------------------------------------
#define EXPORT __declspec (dllexport)
//---------------------------------------------------------------------------
typedef struct image_list_t *ilist_t;
typedef struct image_list_t
{
        unsigned long width;
        unsigned long height;
        unsigned long offset;
        ilist_t nextim;
} image_list_t;
//---------------------------------------------------------------------------
typedef struct entry_list_t *elist_t;
typedef struct entry_list_t {
  char name[256]; //name of the entry
  unsigned long size; //size, must be correct for entry saving, not for images
  unsigned long csize; //compressed size
  unsigned long comptype; //compression type, 0 = none, 1 = Daikatana RLE, 2 = deflate
  unsigned long offset; // offset to file data or image data (past the header and palette)
  unsigned long format; //0 = regular image, 1 = art, 2 = 16-bit, ...
  unsigned long palette_offset; //Offset to palette data (if exists), -1 = no palette
  unsigned long palette_type; // 0 = regular 768, 1 = bmp 1024, ...
  unsigned long image_offset; //Offset to raw image data
  unsigned long width; // 0 if not image
  unsigned long height; // 0 if not image
  unsigned long extra; // for extra stuff used with plugins (output size when retrieving data)
  unsigned long numtex; // 1 = normal image, 0 if not image, > 1 for textures with more than one images
  elist_t next;
  ilist_t nextim;
} entry_list_t;
//---------------------------------------------------------------------------
elist_t mapped = NULL;
char *pWav = NULL;
HANDLE hwav;
HANDLE hentry;
//---------------------------------------------------------------------------
typedef struct aud_t
{
        unsigned short SamplesPerSec;  //Frequency
        long Size;   //Size of file (without header)
        long OutSize;   //Size of ouput data
        BYTE Flags;      //bit 0=stereo, bit 1=16bit
        BYTE Typ;      //1=WW compressed, 99=IMA ADPCM
} aud_t;
//---------------------------------------------------------------------------
typedef struct chunk_t
{
        WORD Size;    //Size of compressed data
        WORD OutSize;    //Size of ouput data
        long ID; //Always $0000DEAF
} chunk_t;
//---------------------------------------------------------------------------
char Index_Adjust [8] = {-1,-1,-1,-1,2,4,6,8};
//---------------------------------------------------------------------------
short Step_Table [89] = {
        7,     8,     9,     10,    11,    12,     13,    14,    16,
        17,    19,    21,    23,    25,    28,     31,    34,    37,
        41,    45,    50,    55,    60,    66,     73,    80,    88,
        97,    107,   118,   130,   143,   157,    173,   190,   209,
        230,   253,   279,   307,   337,   371,    408,   449,   494,
        544,   598,   658,   724,   796,   876,    963,   1060,  1166,
        1282,  1411,  1552,  1707,  1878,  2066,   2272,  2499,  2749,
        3024,  3327,  3660,  4026,  4428,  4871,   5358,  5894,  6484,
        7132,  7845,  8630,  9493,  10442, 11487,  12635, 13899, 15289,
        16818, 18500, 20350, 22385, 24623, 27086,  29794, 32767 };
//---------------------------------------------------------------------------
#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void *yuck)
{
        switch (reason)
        {
                case DLL_PROCESS_DETACH:
                        UnmapViewOfFile(mapped);
                        UnmapViewOfFile(pWav);
                        CloseHandle(hentry);
                        CloseHandle(hwav);
                break;
        }

        return 1;
}
//---------------------------------------------------------------------------
// how many different extensions are supported
EXPORT short CALLBACK get_ext_count (void)
{
        return 6;
}
//---------------------------------------------------------------------------
// extensions that this plugin wants to handle
#pragma argsused
EXPORT char * CALLBACK get_ext (int number)
{
        switch (number)
        {
        		case 1:
            	return "aud";

            case 2:
            	return "juv";

            case 3:
            	return "v00";

            case 4:
            	return "v01";

            case 5:
            	return "v02";

            case 6:
            	return "v03";
        }
}
//---------------------------------------------------------------------------
// returns a short description of extension
#pragma argsused
EXPORT char * CALLBACK get_format_desc (int number)
{
        return "CC AUD sound file";
}
//---------------------------------------------------------------------------
// Let's determine if we can recognize the file
EXPORT elist_t CALLBACK open (HWND hwnd, char *fullname, char *filename, int size, int offset)
{
        aud_t aud;
        FILE *sourcef;
        char error[256];

        if (mapped != NULL) {
        		return mapped;
        }

        sourcef = fopen (fullname, "rb");
        if (sourcef == NULL)
        {
                wsprintf (error, "Couldn't open file %s !", fullname);
                MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);
                return NULL;
        }
        fseek(sourcef, offset, 0);
        fread(&aud, sizeof(aud_t), 1, sourcef);
        
        //wsprintf (error, "aud_file.SamplesPerSec: %i\naud_file.Size: %li\naud_file.OutSize: %li\naud_file.Flags: %i\naud_file.Typ: %i", aud.SamplesPerSec, aud.Size, aud.OutSize, aud.Flags, aud.Typ);
        //MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);

        if (aud.Typ != 99)
        {
                wsprintf (error, "Not a proper AUD file! (type: %i)", aud.Typ);
                MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);
                fclose(sourcef);
                return NULL;  //format not supported
        }
        else {
                hentry = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, sizeof(entry_list_t), NULL);
                if (hentry != NULL)
                {
                	mapped = (elist_t) MapViewOfFile(hentry, FILE_MAP_WRITE, 0, 0, 0);

                	if (mapped != NULL)
                	{
                        if (size == 0)  //file is not in a package, size has to be determined
        						{
        							fseek(sourcef, 0, 2);
            					mapped->size = ftell(sourcef);
        						}
                        else mapped->size = size;
        						fclose(sourcef);
                        mapped->format = 500; //format for sounds
                        mapped->offset = offset;
                        mapped->extra = aud.OutSize; //GFE needs the output size of the raw sound data
                        strcpy(mapped->name, filename);
                	}
                	else {
                		CloseHandle(hentry);
                	}
                }
                return mapped;  // we are in business...
        }
}
//---------------------------------------------------------------------------
// returns a short description string of the plug-in (showns on the menu)
EXPORT char * CALLBACK get_desc (void)
{
        return "Command and Conquer AUD sound file";
}
//---------------------------------------------------------------------------
// displaying the "About" -dialog
EXPORT void CALLBACK plugin_info (HWND hwnd)
{
	MessageBox(hwnd, "GFE test plug-in.\nThanks to Vladan Bato for\nreleasing the AUD format specs!", "The Amazing AUD Plug-in", MB_OK);
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_entry (void)
{
        UnmapViewOfFile(mapped);
        mapped = NULL;
        CloseHandle(hentry);
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_wave_data (void)
{
        UnmapViewOfFile(pWav);
        pWav = NULL;
        CloseHandle(hwav);
}
//---------------------------------------------------------------------------
#pragma argsused
EXPORT char * CALLBACK get_wave_data (HWND hwnd, char *fullname, int offset, int number)
{
        int Index = 0, cindex, Cur_Sample = 0, op, Sb, fsize; // kayty = 0;
        aud_t aud_file;
        chunk_t chunk;
        char *buffy, mini[5] = { 0, 0, 0, 0, 0 }, Code; // error[256];
        short Delta, shortie;
        BOOL swtch = 0;
        FILE *stream;

        stream = fopen (fullname, "rb");
        if (stream == NULL)
        {
                //wsprintf (error, "Couldn't open file %s !", fullname);
                //MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);
                return NULL;
        }
        fseek(stream, offset, 0);
        fread(&aud_file, sizeof(aud_t), 1, stream);

        hwav = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, (aud_file.OutSize + 44)+ 1, NULL);
        if (hwav != NULL)
        {
                pWav = (char *) MapViewOfFile(hwav, FILE_MAP_WRITE, 0, 0, 0);
        }
        else return NULL;
        //wsprintf (error, "aud_file.SamplesPerSec: %i\naud_file.Size: %li\naud_file.OutSize: %li\naud_file.Flags: %i\naud_file.Typ: %i", aud_file.SamplesPerSec, aud_file.Size, aud_file.OutSize, aud_file.Flags, aud_file.Typ);
        //MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);

        if (pWav == NULL)
        		CloseHandle(hwav);
        else {
                fread(&chunk, sizeof(chunk_t), 1, stream);
                buffy = (char *) malloc (chunk.Size);
                cindex = 0;
                if (buffy == NULL || chunk.ID != 0x0000DEAF)
                {
                        fclose(stream);
                        UnmapViewOfFile(pWav);
                        pWav = NULL;
                        CloseHandle(hwav);
                        //wsprintf (error, "Bad chunk!");
                        //MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);
                        return NULL;
                }
                fread(buffy, chunk.Size, 1, stream);

                //let's create the wave file (in a shitty way)
                strcpy (pWav, "RIFF");
                fsize = aud_file.OutSize + 36;
                memcpy(mini, &fsize, 4);
                pWav[4] = mini[0];
                pWav[5] = mini[1];
                pWav[6] = mini[2];
                pWav[7] = mini[3];

                strcpy (mini, "WAVE");
                pWav[8] = mini[0];
                pWav[9] = mini[1];
                pWav[10] = mini[2];
                pWav[11] = mini[3];

                strcpy (mini, "fmt ");
                pWav[12] = mini[0];
                pWav[13] = mini[1];
                pWav[14] = mini[2];
                pWav[15] = mini[3];

                fsize = 16;
                memcpy(mini, &fsize, 4);
                pWav[16] = mini[0];
                pWav[17] = mini[1];
                pWav[18] = mini[2];
                pWav[19] = mini[3];

                shortie = 1;
                memcpy(mini, &shortie, 2);
                pWav[20] = mini[0];
                pWav[21] = mini[1];
                pWav[22] = mini[0];
                pWav[23] = mini[1];

        			fsize = aud_file.SamplesPerSec;
        			memcpy(mini, &fsize, 4);
               pWav[24] = mini[0];
        			pWav[25] = mini[1];
        			pWav[26] = mini[2];
        			pWav[27] = mini[3];

        			fsize = 2 * aud_file.SamplesPerSec;
        			memcpy(mini, &fsize, 4);
        			pWav[28] = mini[0];
        			pWav[29] = mini[1];
        			pWav[30] = mini[2];
        			pWav[31] = mini[3];

        			shortie = 2;
        			memcpy(mini, &shortie, 2);
        			pWav[32] = mini[0];
        			pWav[33] = mini[1];

        			shortie = 16;
        			memcpy(mini, &shortie, 2);
        			pWav[34] = mini[0];
        			pWav[35] = mini[1];

                pWav[36] = 'd';
                pWav[37] = 'a';
                pWav[38] = 't';
                pWav[39] = 'a';

                fsize = aud_file.OutSize;
                memcpy(mini, &fsize, 4);
                pWav[40] = mini[0];
                pWav[41] = mini[1];
                pWav[42] = mini[2];
                pWav[43] = mini[3];

                op = 42;

                while (!feof(stream)) //no sense
                {
                        if (cindex == chunk.Size)
                        {
                                free(buffy);
                                fread(&chunk, sizeof(chunk_t), 1, stream);

                                //wsprintf (error, "CSize: %li\nOut: %li\nID: %li\nCindex: %li\nOp: %li", chunk.Size, chunk.OutSize, chunk.ID, cindex, op);
                                //MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);

                                if (chunk.ID != 0x0000DEAF)
                                {
                        				//wsprintf (error, "Bad chunk!\nCindex: %li\nOp: %li", cindex, op);
                           			//MessageBox(hwnd, error, "AUD Plug-in error", MB_OK);
                           			break;
                                }

                                if (chunk.Size == 0) //this is weird...
                                {
                                    chunk.Size = 2;
                                    buffy = (char *) malloc (chunk.Size);
                                		if (buffy == NULL)
                                		{
                                			UnmapViewOfFile(pWav);
                                       pWav = NULL;
                                       CloseHandle(hwav);
                                       fclose(stream);
                                			return NULL;
                                		}
                                    buffy[0] = 0;
                                    buffy[1] = 0;
                                }
                                else {
                                		buffy = (char *) malloc (chunk.Size);
                                		if (buffy == NULL)
                                		{
                                			UnmapViewOfFile(pWav);
                                       fclose(stream);
                                			return NULL;
                                		}
                                		fread(buffy, chunk.Size, 1, stream);
                                }
                                cindex = 0;
                                swtch = 0;
                        }

                        if (swtch == 0)
                        {
                                Code = (char)((buffy[cindex]) & 0x0F);
                                swtch = 1;
                                op = op + 2;
                        }
                        else {
                                Code = (char)(((buffy[cindex]) & 0xF0) >> 4);
                                cindex++;
                                swtch = 0;
                                op = op + 2;
                        }

                        if ((Code & 0x08) != 0) Sb = 1;
                        else Sb = 0;
                        Code = (char)(Code & 0x07);   //Separate the sign bit from the rest

                        Delta = (Step_Table[Index]*Code) / 4 + Step_Table[Index] / 8;
                        //The last one is to minimize errors
                        if (Sb == 1) Delta = -Delta;
                        Cur_Sample = Cur_Sample + Delta;
                        if (Cur_Sample > 32767)
                                Cur_Sample = 32767;
                        else if (Cur_Sample < -32768)
                                Cur_Sample = -32768;
                        if ((op + 1) >= (aud_file.OutSize + 44)) break;
                        shortie = (short) Cur_Sample;
                        pWav[op] = (char) shortie;
                        pWav[op+1] = (char) (shortie >> 8);
                        Index = Index + Index_Adjust[Code];
                        if (Index < 0) Index = 0;
                        if (Index > 88) Index = 88;
                }
        }

        if(buffy) free(buffy);
        fclose(stream);

        return pWav;
}
//---------------------------------------------------------------------------