// ------------------------------------------------------
//       TGA stuff
// ------------------------------------------------------

typedef struct tgaheader_t
{
  BYTE IDLength;        /* 00h  Size of Image ID field */
  BYTE ColorMapType;    /* 01h  Color map type */
  BYTE ImageType;       /* 02h  Image type code */
  short CMapStart;       /* 03h  Color map origin */
  short CMapLength;      /* 05h  Color map length */
  BYTE CMapDepth;       /* 07h  Depth of color map entries */
  short XOffset;         /* 08h  X origin of image */
  short YOffset;         /* 0Ah  Y origin of image */
  short Width;           /* 0Ch  Width of image */
  short Height;          /* 0Eh  Height of image */
  BYTE PixelDepth;      /* 10h  Image pixel size */
  BYTE ImageDescriptor; /* 11h  Image descriptor byte */
} tgaheader_t;
