#ifndef FourWaySplitterMethod_Header
#define FourWaySplitterMethod_Header

#include <controls/MultiSplitter.h>

namespace AztecGUI {

  class FourWaySplitter : public SplitterMethod {
  public:

    /**
     *  FourWay          TwoAtTop        TwoAtRight
     *  +--+--+  +-----+  +--+--+ +-----+ +-----+
     *  | 0| 1|  |  0  |  | 0| 1| | 0|  | |  | 1|
     *  +--+--+  +--+--+  +--+--+ +--+ 1| | 0+--+
     *  | 2| 3|  | 1| 2|  |  2  | | 2|  | |  | 2|
     *  +--+--+  +--+--+  +-----+ +--+--+ +--+--+
     *          TwoAtBottom      TwoAtLeft
     *
     *
     *  TwoVertical
     *  
     *  +--+--+
     *  |  |  |
     *  | 0| 1|
     *  |  |  |
     *  +--+--+
     */

    typedef enum { FourWay, TwoAtBottom, TwoAtTop, TwoAtLeft, TwoAtRight, TwoVertical } SplitStyle;

    FourWaySplitter(int borderWidth = 6, 
                    int edgeWidth = 0, 
                    SplitStyle style = FourWay, 
                    float splitX = 0.5f, 
                    float splitY = 0.5f);

    // SplitterMethod methods
    int getPaneCount();
    HitTestResultEnum hitTest(MultiSplitter *splitterWnd, int x, int y);
    Aztec::MRect2D getRectFor(MultiSplitter *splitterWnd, int index);
    Aztec::MMouseCursor getCursorForHit(HitTestResultEnum hitResult);
    void beginDrag(MultiSplitter *splitterWnd, HitTestResultEnum hitResult, int x, int y);
    void doDrag(MultiSplitter *splitterWnd, HitTestResultEnum hitResult, int x, int y);
    void endDrag(MultiSplitter *splitterWnd, HitTestResultEnum hitResult, int x, int y);
    void maximisePane(int pane);

  private:  
    int borderWidth;
    int edgeWidth;

    SplitStyle splitStyle;

    int startX;
    int startY;
    float startSplitX;
    float startSplitY;

    float splitX;
    float splitY;

    int maximisedPane;
  };
}


#endif

