#ifndef UVCanvas_Header
#define UVCanvas_Header

// The UV canvas is really just a special case of the 3d scene canvas.
#include <controls/Aztec3DSceneCanvas.h>
#include <MMath.h>

#include <MSceneObject.h>

namespace AztecGUI {

  class UVCanvas : public Aztec3DSceneCanvas
  {
  public:
    UVCanvas(AztecView *parentView);
    ~UVCanvas();

    // Aztec3DCanvas methods
    void draw3D(Aztec::MSelectMethod method, std::vector<Aztec::MSelectionItem> &items, float left, float top, float right = 0.0f, float bottom = 0.0f);
    void draw3DExtras();

  protected:
    void drawUVMeshes(Aztec::MSelectMethod method, std::vector<Aztec::MSceneObjectPtr> &objects);

  };

  typedef Aztec::MRefCountedPtr<UVCanvas> UVCanvasPtr;
}

#endif

