#ifndef Aztec2_Chamfer_Tool_Header
#define Aztec2_Chamfer_Tool_Header


#include <tools/MXYZToolType.h>
#include <MEditableMesh.h>
#include <functions/mesh/MeshFunctions.h>


namespace AztecGUI {

  /**
   * This tool is an interactive chamfering and solid chamfering tool inspired 
   * greatly by the amazing work of Sebastian Thiel [Sebastian-Thiel@t-online.de]. 
   * He has written some great Maya tools, which this chamfer tool was 
   * inspired from.
   *
   * The soild chamfer tool takes selected edges, and adds extra detail edges 
   * parallel to that selection. The normal chamfer produces those extra 
   * detail edges, but removes the original vertices in order to make a smooth 
   * rounder corner.
   */
  class ChamferTool : public MXYZToolType
  {
  public:
    ChamferTool(bool solid);
    
    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    
    int WrapMouse() {return 1;};
    int getDefaultManip() {return 3;};

  protected:
     /**
      * This gets the selection normal, and returns true if some
      * face were selected, false if nothing was selected.
      */
     bool updateNormal();

     /**
      * This is directio that we are extruding in
      */
     Aztec::MVector3 chamferVector;
     /**
      * This is the centre of the extrusion.
      */
     Aztec::MVector3 m_ExtrudeCentre;
     /**
      * This is the transformation matrix to use when
      * drawing the widgets
      */
     Aztec::MMatrix4 toolTransform;
     /**
      * This indicates if we are acutally extrusing yet, or
      * just looking at stuff.
      */
     bool doingChamfer;
     /**
      * This is the Distance that we have extruded along
      * the extrude vector so far.
      */
     double chamferDistance;

     double lastGoodChamferDistance;
     double lastBadChamferDistance;

     bool solidChamfer;


     /**
      * This is the starting point for extrusion.
      */
     Aztec::MVector3 m_StartPos;
     /**
      * This is the current centre of the centre of the
      * faces during extrusion.
      */
     Aztec::MVector3 m_CurrentPos;

     Aztec::MVector3 mouseStartedPos;

     void splitEdgesAroundEdges(Aztec::MEditableMeshPtr mesh, Aztec::AztecFlags flags, float dist = 0.5, bool distIsFraction = true);

  };


}

#endif

