#ifndef MPolylineAddPointTool_Header
#define MPolylineAddPointTool_Header

#include <tools/MXYZToolType.h>

// AztecLib includes
#include <MLineShape.h>
#include <MLineMesh.h>

namespace AztecGUI {
  class MPolylineAddPointTool : public MXYZToolType {
  public:
    MPolylineAddPointTool();

    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    int getDefaultManip();

  private:
    bool dragging;

    Aztec::MSceneObjectPtr sceneObj;
    Aztec::MLineShapePtr shapeObj;
    Aztec::MLineMeshPtr meshObj;

    void getMeshObject();
    Aztec::MVector3 getPositionFromMouse(const Aztec::MMouseEvent &event);
  };
}
#endif