#ifndef UVEditView_Header
#define UVEditView_Header

#include <MRefCountedPtr.h>
#include <views/AztecGLView.h>
#include <views/DeletingView.h>
#include <controls/UVCanvas.h>
#include <views/SelectingView.h>

namespace AztecGUI {

  class UVEditView : public AztecGLView, public SelectingView {
  public:

    static std::string VIEW_GROUP;

    UVEditView(const std::string &viewName);
    ~UVEditView();

    UVCanvasPtr getUVCanvas();

    // AztecGLView methods
    AztecGLCanvasPtr getCanvas();

    // AztecView methods
    AztecViewPtr createCopy();
    void drawView();
    std::string getViewGroup() const;
    MToolTypePtr getSelectTool();


    // MComponent methods
    void onCreate();

    // SelectingView methods
    bool selectParent();
    bool selectChild();
    bool selectSiblingNext();
    bool selectSiblingPrev();
    bool selectNone();
    bool selectAll();
    bool selectInverse();
    bool selectAllChildren();
    bool anythingSelected();
    Aztec::MVector3 getSelectionCentre();


  protected:
    UVCanvasPtr canvas;
  };

  typedef Aztec::MRefCountedPtr<UVEditView> UVEditViewPtr;
}

#endif

