#include <Aztec3DPCH.h>

#include <controls/OptionsWindow.h>

#include <gui/MBorderLayout.h>
#include <gui/MGridLayout.h>
#include <gui/MTreeControl.h>
#include <gui/MButton.h>
#include <gui/MFlowLayout.h>
#include <gui/MLabel.h>

#include <config/UIConfig.h>

namespace AztecGUI {

  class KeyboardTree : public Aztec::MTreeControl {
  public:
    void onCreate() {
      std::map<std::string, Aztec::MTreeItemPtr> categoryMap;
      
      UIConfig::CommandList commands;
      UIConfig::getFriendlyCommands(commands);
      for (int i = 0; i < commands.size(); ++i) {
        if (commands[i].command.length() > 0 && commands[i].friendly.length() > 0) {
          if (categoryMap.find(commands[i].category) == categoryMap.end()) {
            categoryMap[commands[i].category] = addItem(commands[i].category);
          }
          
          addItem(commands[i].friendly, categoryMap[commands[i].category]);
        }
      }
    }

    bool onItemSelected(const Aztec::MTreeItemPtr &item);
  
  };

  static OptionsWindowPtr globalOptionsWindow;

  OptionsWindow::OptionsWindow(const std::string &title) 
    : MWindow(title) 
  {

  }

  bool OptionsWindow::onClose() {
    globalOptionsWindow = NULL;
    return false;
  }

  class OptionsHotkey : public Aztec::MHotKeyControl {
  public:
    OptionsHotkey(int width, Aztec::MTextFieldPtr f) 
      : Aztec::MHotKeyControl(width)
    {
      field = f;
    }

    bool onChanged() {
      if (field != NULL) {
        field->setValue(UIConfig::getShortcut(getHotKey(), getModifiers(), true));
      }
      return true;
    }


  private:
    Aztec::MTextFieldPtr field;

  };

  void OptionsWindow::onCreate() {
    setLayoutManager(new Aztec::MBorderLayout());
    
    Aztec::MContainerPtr content = new Aztec::MContainer();
    addComponent(content, Aztec::MBorderLayout::CENTRE);
    
    content->setLayoutManager(new Aztec::MBorderLayout());
    
    Aztec::MTreeControlPtr tree = new KeyboardTree();
    
    content->addComponent(tree, Aztec::MBorderLayout::CENTRE);
    
    Aztec::MContainerPtr options = new Aztec::MContainer();
    options->setMinimumSize(Aztec::MSize2D(150,200));
    
    
    content->addComponent(options, Aztec::MBorderLayout::EAST);
    
    Aztec::MContainerPtr bottom = new Aztec::MContainer();
    bottom->setLayoutManager(new Aztec::MBorderLayout());
    Aztec::MContainerPtr buttons = new Aztec::MContainer();
    buttons->setLayoutManager(new Aztec::MGridLayout(3,1));
    
    content->addComponent(bottom, Aztec::MBorderLayout::SOUTH);
    bottom->addComponent(buttons, Aztec::MBorderLayout::EAST);
    
    buttons->addComponent(new Aztec::MButton("Apply", "apply", Aztec::MSize2D(64,24)));
    buttons->addComponent(new Aztec::MButton("Ok", "ok", Aztec::MSize2D(64,24)));
    buttons->addComponent(new Aztec::MButton("Close", "cancel", Aztec::MSize2D(64,24)));
    
    
    options->setLayoutManager(new Aztec::MFlowLayout(2, 2, 1));
    currentFriendly = addField(options, "Current Item", new Aztec::MTextField(30));
    currentCommand = addField(options, "Script", new Aztec::MTextField(50));
    alreadyUsedCommand = new Aztec::MTextField(50);
    currentShortcut = addField(options, "Shortcut", new OptionsHotkey(15, alreadyUsedCommand));
    addField(options, "Key already assigned To", &*alreadyUsedCommand);
    alreadyUsedCommand->setEnabled(false);
    options->addComponent(new Aztec::MButton("Add Shortcut", "addShortcut"));
  }

  bool OptionsWindow::onCommand(const std::string &command, const Aztec::MComponentPtr &component) {
    if (command == "addShortcut") {
      UIConfig::addShortcut(currentShortcut->getHotKey(), currentShortcut->getModifiers(), true, currentCommand->getValue());
      return true;
    } else if (command == "cancel") {
      this->close();
      return true;
    } else if (command == "ok") {
      // save the config and close the window.
      AztecGUI::UIConfig::saveConfig();
      this->close();

      return true;
    } else if (command == "apply") {
      // save the config
      AztecGUI::UIConfig::saveConfig();
      return true;

    }

    return false;
  }

  void OptionsWindow::show() {
    if (globalOptionsWindow == NULL) {
      globalOptionsWindow = new OptionsWindow("Configure Aztec");
      globalOptionsWindow->create();
    }
    
    globalOptionsWindow->setVisible(true);
    globalOptionsWindow->doLayout();
    
    
  }

  bool KeyboardTree::onItemSelected(const Aztec::MTreeItemPtr &item) {
    if (globalOptionsWindow != NULL && item->getSelected()) {
      // check to see what group this item is in.
      Aztec::MTreeItemPtr groupItem = item->getParent();

      if (groupItem != NULL) {
        globalOptionsWindow->currentShortcut->setEnabled(true);
        globalOptionsWindow->currentFriendly->setEnabled(true);
        globalOptionsWindow->currentCommand->setEnabled(true);
        globalOptionsWindow->alreadyUsedCommand->setEnabled(true);

        std::string friendly = item->getText();
        std::string command = UIConfig::getFriendlyCommand(friendly);
        Aztec::MKeyEvent::KeyCode code;
        Aztec::MShiftState state;
        bool onPressed;
        bool hasShortcut = UIConfig::getShortcut(command, code, state, onPressed);

        globalOptionsWindow->currentFriendly->setValue(friendly);
        globalOptionsWindow->currentCommand->setValue(command);

        if (hasShortcut) {
          globalOptionsWindow->currentShortcut->setHotKey(code, state);

          // get the command for this thing.
          UIConfig::getShortcut(code, state, true);

        } else {
          globalOptionsWindow->currentShortcut->clearHotKey();
          globalOptionsWindow->alreadyUsedCommand->setValue("");
        }
      } else {
        globalOptionsWindow->currentShortcut->clearHotKey();
        globalOptionsWindow->currentShortcut->setEnabled(false);
        globalOptionsWindow->currentFriendly->setEnabled(false);
        globalOptionsWindow->currentCommand->setEnabled(false);
        globalOptionsWindow->alreadyUsedCommand->setEnabled(false);
      }

      return true;
    }
    return false;
  }


}

