#include <Aztec3DPCH.h>

#include <functions/edit/VisibilityFunctions.h>

// Aztec2 includes
#include <views/AztecViewManager.h>
#include <utils/SceneFunctions.h>

// AztecLib includes
#include <MScene.h>
#include <MSystemManager.h>
#include <MUIManager.h>


namespace AztecGUI {

  static void showFunc(const Aztec::MScenePtr &scene, const Aztec::MTreeObjectNodePtr &node) {
    if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::OBJECT_TYPE) {
      node->getObject()->setFlag(OBJECTFLAG_VISIBLE);
    } else {
      
      Aztec::MSceneObjectPtr sceneObj = AZTEC_CAST(Aztec::MSceneObject, node->getObject());
      if (sceneObj != NULL) {
        Aztec::MComponentisedObjectPtr compObj = sceneObj->getComponentObject();
        
        if (compObj != NULL) {
          // we only really want to do things here if we are showing/hiding edges.
          if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::EDGE_TYPE) {
            for (int n = 0; n < compObj->getComponentCount(Aztec::MComponentisedObject::EDGE_TYPE); ++n) {
              if (compObj->isComponentFlagged(Aztec::MComponentisedObject::EDGE_TYPE,n)) {
                compObj->flagComponent(Aztec::MComponentisedObject::EDGE_TYPE, n,EDGE_VISIBLE, Aztec::MComponentisedObject::atSet);
              }
            }
          }    
        }
      }
    }
  }

  static void hideFunc(const Aztec::MScenePtr &scene, const Aztec::MTreeObjectNodePtr &node) {
    if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::OBJECT_TYPE) {
      node->getObject()->unsetFlag(OBJECTFLAG_VISIBLE);
    } else {
      
      Aztec::MSceneObjectPtr sceneObj = AZTEC_CAST(Aztec::MSceneObject, node->getObject());
      if (sceneObj != NULL) {
        Aztec::MComponentisedObjectPtr compObj = sceneObj->getComponentObject();
        
        if (compObj != NULL) {
          // we only really want to do things here if we are showing/hiding edges.
          if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::EDGE_TYPE) {
            for (int n = 0; n < compObj->getComponentCount(Aztec::MComponentisedObject::EDGE_TYPE); ++n) {
              if (compObj->isComponentFlagged(Aztec::MComponentisedObject::EDGE_TYPE,n)) {
                compObj->flagComponent(Aztec::MComponentisedObject::EDGE_TYPE, n,EDGE_VISIBLE | EDGE_SELECTED, Aztec::MComponentisedObject::atUnset);
              }
            }
          }    
        }
      }
    }
  }

  static int showAll(const StringVector &args, std::string &result) {
    return applyFunction(Aztec::MScene::getGlobalScene(), "Show All", allObjectsCriteria, showFunc);
  }

  static int showSelected(const StringVector &args, std::string &result) {
    return applyFunction(Aztec::MScene::getGlobalScene(), "Show Selected", ifSelectedCriteria, showFunc);
  }

  static int showUnselected(const StringVector &args, std::string &result) {
    return applyFunction(Aztec::MScene::getGlobalScene(), "Show Unselected", ifNotSelectedCriteria, showFunc);
  }

  static int hideAll(const StringVector &args, std::string &result) {
    return applyFunction(Aztec::MScene::getGlobalScene(), "Hide All", allObjectsCriteria, hideFunc);
  }

  static int hideSelected(const StringVector &args, std::string &result) {
    return applyFunction(Aztec::MScene::getGlobalScene(), "Hide Selected", ifSelectedCriteria, hideFunc);
  }

  static int hideUnselected(const StringVector &args, std::string &result) {
    return applyFunction(Aztec::MScene::getGlobalScene(), "Hide Unselected", ifNotSelectedCriteria, hideFunc);
  }

  static const char *VISIBILTY_CATEGORY = "Visiblity";

  void registerVisibilityFunctions(FunctionManager &man) {

    man.registerFunction("showAll", showAll, VISIBILTY_CATEGORY, "Show all Objects or Components");
    man.registerFunction("showSelected", showSelected, VISIBILTY_CATEGORY, "Show all selected Objects or Components");
    man.registerFunction("showUnselected", showUnselected, VISIBILTY_CATEGORY, "Show all unselected Objects or Components");
    man.registerFunction("hideAll", hideAll, VISIBILTY_CATEGORY, "Hide all objects or components");
    man.registerFunction("hideSelected", hideSelected, VISIBILTY_CATEGORY, "Hide selected Objects or Components");
    man.registerFunction("hideUnselected", hideUnselected, VISIBILTY_CATEGORY, "Hide unselected Objects or Components");

  }


}

