#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/mesh/MeshFunctions.h>
#include <utils/SceneFunctions.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <misc/MSceneHelper.h>

// Standard includes

namespace AztecGUI {

  void doComponentConnect(const Aztec::MScenePtr &scene, const Aztec::MTreeObjectNodePtr &node) {
    Aztec::MNamedObjectPtr namedObj = AZTEC_CAST(Aztec::MNamedObject, node->getObject());
    Aztec::MEditableMeshPtr mesh = Aztec::getEditableMeshObject(namedObj);
    if (mesh == NULL) {
      Aztec::MSystemManager::getInstance()->logOutput("Warning: edgeConnect() failed on object '%s', only operates on editable meshes", namedObj != NULL ? namedObj->getName().c_str() : "");
      return;
    }

    if (mesh->getComponentMode() == Aztec::MComponentisedObject::POINT_TYPE) {
      pointConnectMesh(mesh);
    } else if (mesh->getComponentMode() == Aztec::MComponentisedObject::EDGE_TYPE) {
      edgeConnectMesh(mesh, 1);
    } else if (mesh->getComponentMode() == Aztec::MComponentisedObject::FACET_TYPE) {
      faceConnectMesh(mesh);
    }
  }

  int componentConnect(const StringVector &args, std::string &result) {

    applyToObjects(Aztec::MScene::getGlobalScene(), Aztec::MScene::getGlobalScene()->getObjectList(), ifSelectedCriteria, doComponentConnect);

    AztecViewManager::redrawAllViews();
	  
    return FunctionManager::SUCCEED;
  }


}

