#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>

// Standard includes

namespace AztecGUI {
  

  int detachFaces(const StringVector &args, std::string &result) {
    if (Aztec::MUIManager::getComponentMode() != Aztec::MComponentisedObject::FACET_TYPE) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: detachFaces() requires us to be in the FACE component mode.");
      return FunctionManager::FAIL;
    }

    Aztec::MBaseObjectPtr Obj;
    Aztec::MSceneObjectPtr SceneObj;
    Aztec::MEditableMeshPtr Mesh;
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    
    scene->getObjectList()->beginIteration();
    while (( Obj = scene->getObjectList()->getNext() ) != NULL ) {
      if (!Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        continue;
      }
      
      SceneObj = AZTEC_CAST(Aztec::MSceneObject, Obj);
      
      if (SceneObj == NULL) {
        continue;
      }
      
      Mesh = AZTEC_CAST(Aztec::MEditableMesh, SceneObj->getShapeObject()->convertToMesh());
      
      if (Mesh == NULL) {
        continue;
      }
      
      Mesh->separateFaces(TRIANGLE_SELECTED);
    }
    scene->getObjectList()->endIteration();
    
    AztecViewManager::redrawAllViews();

    return FunctionManager::SUCCEED;
  }


}

