#include <Aztec3DPCH.h>
#include <tools/MGraphSelectTool.h>

// Aztec2 includes
#include <views/AztecGraphView.h>
#include <views/AztecViewManager.h>

namespace AztecGUI {

  MGraphSelectTool::MGraphSelectTool() {
    m_Dragging = false;
  }

  static GraphComponent* getGraph(Aztec::MComponentPtr comp) {
    GraphComponent *graph = AZTEC_CAST(GraphComponent, comp);

    if (graph != NULL) {
      return graph;
    }

    // try and get our graph component
    AztecGraphView *graphView = AZTEC_CAST(AztecGraphView, comp);
    if (graphView != NULL) {
      return graphView->getGraphComponent();
    }

    return NULL;
  }

  std::string MGraphSelectTool::getName() {
    return "GraphSelectTool";
  }

  int MGraphSelectTool::drawTool(bool select, const Aztec::MComponentPtr &comp) {
    GraphComponent *graph = getGraph(comp);

    if (graph == NULL) {
      return 0;
    }

    if (m_Dragging) {
      float x1,y1,x2,y2;

      graph->clientToGraph(m_DownX, m_DownY, x1,y1);
      graph->clientToGraph(m_CurX, m_CurY, x2,y2);

      glColor3f(0.1f, 1.0f, 0.7f);
      glBegin(GL_LINE_LOOP);
      glVertex2f(x1,y1);
      glVertex2f(x2,y1);
      glVertex2f(x2,y2);
      glVertex2f(x1,y2);

      glEnd();
    }

    return 1;
  }

  int MGraphSelectTool::onMouseDown(const Aztec::MMouseEvent &event) {
    MToolType::onMouseDown(event);

    m_Dragging = true;
    m_CurX = m_DownX = event.getX();
    m_CurY = m_DownY = event.getY();
  
    return TOOLRESULT_DRAWCURRENT;
  }

  int MGraphSelectTool::onMouseUp(const Aztec::MMouseEvent &event)
  {
    MToolType::onMouseUp(event);

    GraphComponent *graph = getGraph(event.getComponent());

    if (graph == NULL) {
      return TOOLRESULT_DRAWNONE;
    }
  
    m_Dragging = false;

    m_UpX = event.getX();
    m_UpY = event.getY();

    std::vector<GraphComponent::ListKey> keys;
    std::vector<GraphPair> graphValues;

    graph->getGraphValues(graphValues);

    // If we are holding down control or alt, that means we are either
    // adding or subtracting from our selection, so we don't clear it
    if (!event.getShiftState().shiftPressed && !event.getShiftState().ctrlPressed) {
      for (int i = 0; i < graphValues.size(); ++i) {
        MFloatKeyListPtr keyList = AZTEC_CAST(MFloatKeyList, graphValues[i].value);
    
        if (keyList == NULL) {
          continue;
        }
        // loop over the keys
        for (int keyIndex = 0; keyIndex < keyList->getKeyCount(); ++keyIndex) {
          keyList->getKeyAtIndex(keyIndex)->setSelected(false);
        }
      }
    }

    bool selectionTarget = true;

    if (event.getShiftState().shiftPressed) {
      selectionTarget = false;
    }

#ifdef WIN32
    RECT selectionRect;

    selectionRect.left = m_DownX;
    selectionRect.top = m_DownY;
    selectionRect.right  = m_UpX;
    selectionRect.bottom = m_UpY;

    if (selectionRect.left > selectionRect.right) {
      std::swap(selectionRect.left, selectionRect.right);
    }
    if (selectionRect.top > selectionRect.bottom) {
      std::swap(selectionRect.top, selectionRect.bottom);
    }

    selectionRect.left -= 3;
    selectionRect.top -= 3;
    selectionRect.right += 3;
    selectionRect.bottom += 3;

    graph->getKeysInRect(selectionRect, keys);
#else
#warning TODO: Linux code
#endif

    for (int i = 0; i < keys.size(); ++i) {
      keys[i].first->getKeyAtIndex(keys[i].second)->setSelected(selectionTarget);
    }
  
    return TOOLRESULT_DRAWCURRENT;
  }

  int MGraphSelectTool::onMouseMove(const Aztec::MMouseEvent &event)
  {
    MToolType::onMouseMove(event);
  
    m_CurX = event.getX();
    m_CurY = event.getY();
  
    if (m_Dragging) {
      return TOOLRESULT_DRAWCURRENT;
    }
  
    return TOOLRESULT_DRAWNONE;
  }


}
