#include <Aztec3DPCH.h>
#include <tools/MPolylineAddPointTool.h>


// Aztec2 includes
#include <views/Aztec3DView.h>
#include <utils/AztecGLUtils.h>
#include <config/UIConfig.h>

// AztecLib includes
#include <MUIManager.h>
#include <MScene.h>

namespace AztecGUI {
  
  MPolylineAddPointTool::MPolylineAddPointTool()
  {
    dragging = false;
  }

  std::string MPolylineAddPointTool::getName() {
    return "toolPolylineAddPoints";
  }

  int MPolylineAddPointTool::drawTool(bool select, const Aztec::MComponentPtr &component)
  {
    return 0;
  }

  int MPolylineAddPointTool::onMouseDown(const Aztec::MMouseEvent &event)
  {
    MXYZToolType::onMouseDown(event);
  
    // check to see what component mode we are in. If we are not in point mode,
    // then do nothing
    if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::POINT_TYPE) {

      AztecGLCanvasPtr glView = AztecGLView::getGLCanvasFor(event.getComponent());
    
      if (glView == NULL) {
        return TOOLRESULT_DRAWNONE;
      }
    
      Aztec::MVector3 newPoint = getPositionFromMouse(event);
    
      if (event.getShiftState().leftMouseDown) {
        dragging = true;
        getMeshObject();
      
        // deselect all the previous points.
        for (int index = 0; index < meshObj->getComponentCount(Aztec::MComponentisedObject::POINT_TYPE); ++index) {
          meshObj->flagComponent(Aztec::MComponentisedObject::POINT_TYPE, 
            index, 
            Aztec::MComponentisedObject::COMPONENT_SELECTED,
            Aztec::MComponentisedObject::atUnset);
        }
      
        meshObj->addVertex(newPoint);
        meshObj->flagComponent(Aztec::MComponentisedObject::POINT_TYPE, 
          meshObj->getVertexCount() - 1, 
          Aztec::MComponentisedObject::COMPONENT_SELECTED);
      
        // if we have more than one vertex, we can join them together with an edge
        if (meshObj->getVertexCount() > 1) {
          meshObj->addEdge(meshObj->getVertexCount()-2, meshObj->getVertexCount()-1);
        }
      
        return TOOLRESULT_DRAWALL;
      
      } else if (event.getShiftState().middleMouseDown) {
        dragging = true;
        getMeshObject();
      
        meshObj->setVertexPosition(meshObj->getVertexCount() - 1, newPoint);
        return TOOLRESULT_DRAWALL;
      }
    
    }
    return TOOLRESULT_DRAWNONE;
  }

  int MPolylineAddPointTool::onMouseMove(const Aztec::MMouseEvent &event) {
    if (dragging) {
      // if we are dragging it means we are adjusting the newly added point
      // so lets move it around.

      getMeshObject();

      Aztec::MVector3 newPoint = getPositionFromMouse(event);

      meshObj->setVertexPosition(meshObj->getVertexCount() - 1, newPoint);
      return TOOLRESULT_DRAWALL;
    }

    return TOOLRESULT_DRAWNONE;
  }

  int MPolylineAddPointTool::onMouseUp(const Aztec::MMouseEvent &event) {
    dragging = false;
    return TOOLRESULT_DRAWNONE;
  }

  void MPolylineAddPointTool::getMeshObject() {
    // if we already have a mesh object, then we don't need to go looking
    if (meshObj != NULL) {
      return;
    }

    // find our current selection, if any
    Aztec::MBaseObjectTreePtr objects = Aztec::MScene::getGlobalScene()->getObjectList();
    Aztec::MBaseObjectPtr object;

    objects->beginIteration();
    while ((object = objects->getNext()) != NULL) {
      // if the object isn't selected, it definitely cannot be ours.
      if (!object->isFlagged(OBJECTFLAG_SELECTED)) {
        continue;
      }

      sceneObj = AZTEC_CAST(Aztec::MSceneObject, object);

      if (sceneObj == NULL) {
        continue;
      }

      shapeObj = AZTEC_CAST(Aztec::MLineShape, sceneObj->getShapeObject());

      // use the first line shape we come across
      if (shapeObj != NULL) {
        break;
      }
    }
    objects->endIteration();

    // if we have no line shape at all, we must make one.
    if (shapeObj == NULL) {
      sceneObj = new Aztec::MSceneObject();
      shapeObj = new Aztec::MLineShape();
      meshObj = new Aztec::MLineMesh();

      shapeObj->setLineMesh(meshObj);
      sceneObj->setShapeObject(shapeObj);

      sceneObj->setName("line");
      shapeObj->setName("lineShape");
      meshObj->setName("lineMesh");

      Aztec::MScene::getGlobalScene()->addObject(sceneObj);
      Aztec::MScene::getGlobalScene()->addObject(shapeObj);

      Aztec::MScene::getGlobalScene()->selectObject(sceneObj);
    } else {
      meshObj = shapeObj->getLineMesh();
    }

    // change to point mode so we can see the points we are making
    Aztec::MUIManager::setComponentMode(Aztec::MComponentisedObject::POINT_TYPE);
  }

  Aztec::MVector3 MPolylineAddPointTool::getPositionFromMouse(const Aztec::MMouseEvent &event) {
    AztecGLCanvasPtr glView = AztecGLView::getGLCanvasFor(event.getComponent());

    // add the new point in.
    Aztec::MRay ray = glView->getRay(event.getX(), event.getY());
    Aztec::MPlane plane = glView->getGridPlane();

    return ray.intersectWithPlane(plane);
  }

  int MPolylineAddPointTool::getDefaultManip() {
    return -1;
  }


}