#ifndef MLayoutManager_Header
#define MLayoutManager_Header

#include <MRefCountedPtr.h>

namespace Aztec {

  class MLayoutManager;
  typedef MRefCountedPtr<MLayoutManager> MLayoutManagerPtr;

  class MConstraint {
  public:
    MConstraint(unsigned long value = 0) : m_Value(value) { }

    bool operator ==(const MConstraint &rhs) const {
      return m_Value == rhs.m_Value;
    }

    operator long() const {
      return m_Value;
    }

    const unsigned long m_Value;
  };

}

#include <gui/MGuiBase.h>
#include <gui/MComponent.h>
#include <gui/MContainer.h>

#include <string>


namespace Aztec {

  /**
   * Implementations of this interface define how components 
   * are arranged and laid out in a container.
   */
  class AZTECGUI_EXPORT MLayoutManager : public virtual IMGuiBase {
  protected:
    MLayoutManager() { }
    ~MLayoutManager() { }

  public:
    typedef MLayoutManagerPtr Ptr;

    /**
     * Adds the window to the layout manger.
     */
    virtual void addComponent(MComponentPtr component) = 0;

    /**
     * Adds the window to the layout manger.
     */
    virtual void addComponent(MComponentPtr component, MConstraint constraints) = 0;

    /**
     * Removes the given component from the layout.
     */
    virtual void removeComponent(MComponentPtr component) = 0;

    /**
     * Performs the laying out of the container
     */
    virtual void layoutContainer(MContainerPtr container) = 0;

    /**
     * Gets the minimum size of the given container.
     */
    virtual MSize2D getMinimumSize(MContainerPtr container) = 0;

    /**
     * Gets the preferred size of the given container.
     */
    virtual MSize2D getPreferredSize(MContainerPtr container) = 0;

    /**
     * Gets the constraint used on a given component.
     */
    virtual MConstraint getConstraint(const MComponentPtr &component) = 0;
  };

}


#endif

