#ifndef MMenu_Header
#define MMenu_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMMenu;
  typedef MRefCountedPtr<IMMenu> IMMenuPtr;

}

#include <gui/MMenuShell.h>
#include <gui/MMenuItem.h>
#include <gui/MComponent.h>
#include <gui/MPoint2D.h>


#include <string>


namespace Aztec {

  /**
   * MMenus are a collection of sub menu items.
   */
  class AZTECGUI_EXPORT IMMenu : public virtual IMMenuShell {
  protected:
    IMMenu() { }
    ~IMMenu() { }

  public:
    typedef IMMenuPtr Ptr;

    /**
     * This gets the number of sub menus off this menu item.
     */
    virtual int getItemCount() = 0;

    /**
     * This gets the sub menu at the given index.
     */
    virtual MMenuItemPtr getItem(int index) = 0;

    /**
     * This adds the given item to this menu as a sub menu item.
     */
    virtual void addItem(MMenuItemPtr item) = 0;

    /**
     * This inserts the given item at the given index to 
     * this menu as a sub menu item.
     */
    virtual void addItem(MMenuItemPtr item, int index) = 0;

    /**
     * This adds a separator on the end of the menu.
     */
    virtual void addSeparator() = 0;

    /**
     * This inserts a separator at the given index.
     */
    virtual void addSeparator(int index) = 0;

    /**
     * This removes the sub menu at the given index.
     */
    virtual void removeItem(int index) = 0;

    /**
     * This is called when a child item has been clicked. This is only called 
     * if the onClick() method of the item itself didn't handle the click 
     * (i.e. returned false).
     *
     * @param item The menu item being clicked
     * @return true if the message was handled, false if it wasn;t.
     */
    virtual bool onItemClick(const MMenuItemPtr &item) = 0;

    /** 
     * Calling this will cause this menu to appear as a popup menu to allow 
     * the user to pick a menu item. This is most often used in conjuction 
     * with an event handler for a right click, so a context menu can be shown.
     *
     * @param component The component that will be displaying the popup
     * @param position The position of the popup menu relative to the component.
     */
    virtual bool popupMenu(const MComponentPtr &component, const MPoint2D &position) = 0;
  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MMenuImpl.h>

/*
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MMenuItemImpl.h>


#endif

