#ifndef MMenuItem_Header
#define MMenuItem_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMMenuItem;
  class MMenuItem;

  typedef MRefCountedPtr<IMMenuItem> IMMenuItemPtr;
  typedef MRefCountedPtr<MMenuItem> MMenuItemPtr;

  class MMenu;
  typedef MRefCountedPtr<MMenu> MMenuPtr;

}

#include <gui/MComponent.h>
#include <gui/MLayoutManager.h>

#include <string>

namespace Aztec {

  /**
   * Menu Items are items in a menu which can be clicked
   * on the people.
   */
  class AZTECGUI_EXPORT IMMenuItem : public virtual IMGuiBase {
  protected:
    IMMenuItem() { }
    ~IMMenuItem() { }

  public:
    /**
     * This is a base class for an item listner. A class derived from 
     * MenuItemListener is optionally passed into loadMenu, which is used to listen to menu click events.
     */
    class Listener : public MRefCountedObject {
    public:
      /**
       * This is called when a 
       */
      virtual bool onClick(const MMenuItemPtr &item) = 0;
    };

    typedef MRefCountedPtr<Listener> ListenerPtr;

    typedef IMMenuItemPtr Ptr;

    /**
     * Sets the text displayed for this menu item.
     */
    virtual void setCaption(const std::string &caption) = 0;
    /**
     * Gets the caption displayed for this menu
     */
    virtual std::string getCaption() = 0;

    /**
     * This is an application defined command string 
     * that is associated with the menu item.
     */
    virtual void setCommand(const std::string &command) = 0;
    /**
     * This gets the application defined string for
     * this menu item.
     */
    virtual std::string getCommand() = 0;

    /**
     * This sets the command associated with the option box next to each menu item. This is typically a java script command to open some option windows.
     */
    virtual void setOptionCommand(const std::string &command) = 0;

    /**
     * Gets the option box text associated with the menu item. This is typically a java script command to open some option windows.
     */
    virtual std::string getOptionCommand() = 0;

    virtual void setChecked(bool isChecked) = 0;

    virtual bool getChecked() = 0;

    virtual void setEnabled(bool isEnabled) = 0;

    virtual bool getEnabled() = 0;

    virtual MMenuPtr getSubMenu() = 0;
    virtual void setSubMenu(const MMenuPtr &rhs) = 0;

    /**
     * This is called when the menu item is clicked 
     * and something needs to happen
     */
    virtual bool onClick() = 0;

  };



}


#include <gui/MMenu.h>


#endif

