
#ifndef QComboBox_Header
#define QComboBox_Header

#include <string>
#include <iostream>

#include <qcombobox.h>

#include "gui/MApplication.h"
#include "gui/MComboBox.h"


/**
 * Custom QComboBox class for passing signals into AztecGUI
 */
class CQComboBox_ : public QComboBox {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQComboBox_(QWidget* parent, const Aztec::MComboBoxPtr ref)
    : QComboBox(parent),
      m_Ref(ref) {
    // Connect the signals
    connect(this, SIGNAL(activated(int)), SLOT(onActivated(int)));
  };

  ~CQComboBox_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MComboBox
   */
  Aztec::MComboBoxPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  // None, the signals used above are already defined

protected slots:
  /**
   * These methods passes the signals to AztecGUI
   */
  void onActivated(int index) {
    //QComboBox::activated(index);

    // TODO: Segfaults, try again with optimizations disabled
    m_Ref->onChanged();
  };

};


#endif

