
#ifndef QMenuBar_Header
#define QMenuBar_Header

#include <string>
#include <iostream>

#include <qmenubar.h>

#include "gui/MMenuBar.h"


/**
 * Custom QMenuBar class for passing signals into AztecGUI
 */
class CQMenuBar_ : public QMenuBar {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQMenuBar_(QWidget* parent, const Aztec::MMenuBarPtr ref)
    : QMenuBar(parent),
      m_Ref(ref) {
    // Connect the signals
    connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(showEvent(QShowEvent*)), SLOT(onShow(QShowEvent*)));
  };

  ~CQMenuBar_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MMenuBar that is using us
   */
  Aztec::MMenuBarPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  void resizeEvent(QResizeEvent* ev);
  void showEvent(QShowEvent* ev);

protected slots:
  /**
   * These methods passes the signals to AztecGUI
   */
  void onResize(QResizeEvent* ev) {
    QMenuBar::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };

  void onShow(QShowEvent* ev) {
    QMenuBar::showEvent(ev);
    m_Ref->onShow();
  };

};


#endif

