#ifndef MMenuBarImpl_Header
#define MMenuBarImpl_Header

#include <gui/MMenuBar.h>
#include <gui/MComponent.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT MMenuBar : public virtual Aztec::IMMenuBar, public MComponent, public MMenuShell {
  public:
    MMenuBar();
    ~MMenuBar();

    BOOL onMenuInput(MSG* pMsg);


    // MComponentImpl methods
    bool createImpl();

    // MComponent methods
    bool wndProc(UINT message, WPARAM wParam, LPARAM lParam, LRESULT *result);
    bool onPaint();
    MSize2D getMinimumSize();
    bool isMinimumSizeSet();

    // MMenuShell methods
    int getItemCount();
    MMenuItemPtr getItem(int index);
    void addItem(MMenuItemPtr item);
    void addItem(MMenuItemPtr item, int index);
    void addSeparator();
    void addSeparator(int index);
    void removeItem(int index);
    bool onItemClick(const MMenuItemPtr &item);

  protected:
    class MenuItem {
    public:
      typedef enum { Normal, Hilighted, Selected } MenuState;
      
      MenuItem();
      MenuItem(const MenuItem &src);
      ~MenuItem();
      
      RECT rect;
      MMenuItemPtr menuItem;
      int width;
      int height;
    };

    typedef std::vector<MenuItem> ItemVector;
    
    ItemVector items;
    int hilightedMenu;
    bool openingMenus;
    bool constantSize;
    int itemHeight;
    int lastRowCount;
    bool hilight3D;
    bool centreText;
    bool isMenuBar;
    BOOL m_bTrack;
    bool useXPColours;

    int lastX, lastY;

    void drawMenuItems(HDC dc);
    void layoutItems(HDC dc);
    void calcItemSizes(HDC dc);
    int getMenuHeight();
    void setHilightedMenu(int index, int changeOpeningMenu = -1);
    int getItemFromPos(int x, int y);
    void showMenu(int index);

    std::string getCaption(int index);
    bool mouseInside;
  };

}


#endif