/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/qt3/MScrolledContainerImpl.h>
#include <gui/qt3/MAppImpl.h>

#include <gui/qt3/QScrolledContainer_.moc>


namespace Aztec {

  MScrolledContainer::MScrolledContainer() {
    isvisible = Automatic;
    vertVisible = false;
  }

  bool MScrolledContainer::createImpl() {
    MApp* app = MApp::getInstance();

    // Only create the window once
    if (m_Handle != 0l) {
      return true;
    }

    QWidget* parentWnd = 0l;
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    m_Handle = new CQScrolledContainer_(parentWnd, this);

    if (m_Handle != 0l) {
      app->registerComponent(m_Handle, this);

      onCreate();
      return true;
    }

    return false;
  }

  void MScrolledContainer::setVisibility(ScrollBarEnum scroller, VisiblityEnum visibility) {
/*    if (isvisible == Always) {
      setScrollVisible(scroller, true);
    } else if (isvisible == Never) {
      setScrollVisible(scroller, false);
    } else {*/
      doLayout();
//    }
  }

  VisiblityEnum MScrolledContainer::getVisibility(ScrollBarEnum scroller) {
/*
    if (scroller == VerticalScroller) {
      return vertVisibility;
    } else if (scroller == HorizontalScroller) {
      return horzVisibility;
    } else {
      assert(0);
      return Never;
    }
    */
    return Never;
  }

  bool MScrolledContainer::onScrolled(ScrollBarEnum scroller) {
    return false;
  }


  void MScrolledContainer::addComponent(MComponentPtr component) {
    // Call base class for taking care of the container window
    MContainer::addComponent(component);

    // ..and put the component on the viewport window
    addComponent(component, MConstraint());
  }

  void MScrolledContainer::addComponent(MComponentPtr component, int index) {
    // Call base class for taking care of the container window
    MContainer::addComponent(component, index);

    // ..and put the component on the viewport window
    addComponent(component, index, MConstraint());
  }

  void MScrolledContainer::addComponent(Aztec::MComponentPtr component, Aztec::MConstraint constraints) {
    // Call base class for taking care of the container window
    MContainer::addComponent(component, constraints);

    // ..and put the component on the viewport window
    QScrollView* sv = dynamic_cast<QScrollView*>(m_Handle);
    if (sv != 0l) {
      sv->addChild(component->getHandle());
      component->setVisible(true);
    }
}

  void MScrolledContainer::addComponent(Aztec::MComponentPtr component, int index, Aztec::MConstraint constraints) {
    // Call base class for taking care of the container window
    MContainer::addComponent(component, index, constraints);

    // ..and put the component on the viewport window
    std::cout << "MScrolledContainer::addComponent(comp, index, const)" << std::endl;

    // TODO: Implementation
  }

  void MScrolledContainer::doLayout() {
    if (getComponentCount() > 0) {
      MSize2D childsize = getComponent(0)->getPreferredSize();
      MSize2D size = getClientSize();

      bool changed = false;
      if (isvisible == Automatic) {
        if (childsize.getHeight() > size.getHeight()) {
          changed = vertVisible != true;
          size.adjustWidth(-2);
          setScrollVisible(VerticalScroller, true);
        } else {
          changed = vertVisible != false;
          setScrollVisible(VerticalScroller, false);
        }

      }

      if (!changed) {
        size.setHeight(childsize.getHeight());

        // NOTE: No positioning here, can only be done by using m_Handle->moveChild
        getComponent(0)->setSize(size);
        /*QScrollView* sv = dynamic_cast<QScrollView*>(m_Handle);
        if (sv != 0l) sv->updateContents();*/
      }
    }
  }

  void MScrolledContainer::setScrollVisible(ScrollBarEnum scroller, bool visible) {
    if (vertVisible == visible) return;
    vertVisible = visible;

    // TODO: Implementation
    doLayout();
  }


  // MComponent methods

  /*void MScrolledContainer::setPosition(const MPoint2D &pos) {
    std::cout << "MScrolledContainer::setPosition(MPoint2D)" << std::endl;
  }

  void MScrolledContainer::setPosition(int X, int Y) {
    std::cout << "MScrolledContainer::setPosition(X, Y)" << std::endl;
  }

  void MScrolledContainer::setPosition(int X, int Y, int width, int height) {
    std::cout << "MScrolledContainer::setPosition(X, Y, width, height)" << std::endl;
  }

  MPoint2D MScrolledContainer::getPosition() {
    std::cout << "MScrolledContainer::getPosition()" << std::endl;
  }

  void MScrolledContainer::setSize(const MSize2D &size) {
    std::cout << "MScrolledContainer::setSize(MSize2D)" << std::endl;
  }

  void MScrolledContainer::setSize(int width, int height) {
    std::cout << "MScrolledContainer::setSize(width, height)" << std::endl;
  }

  MRect2D MScrolledContainer::getWindowRect() {
    std::cout << "MScrolledContainer::getWindowRect()" << std::endl;
  }*/

  void MScrolledContainer::setWindowRect(const MRect2D &rect) {
    // First, call the base class to handle the container window
    MContainer::setWindowRect(rect);

    // And here we take care of the viewport inside the container window
    QScrollView* sv = dynamic_cast<QScrollView*>(m_Handle);
    if (sv != 0l) sv->resizeContents(rect.getWidth()-16, rect.getHeight()-16);
  }

  /*MSize2D MScrolledContainer::getClientSize() {
    std::cout << "MScrolledContainer::getClientSize()" << std::endl;
  }

  MSize2D MScrolledContainer::getSize() {
    std::cout << "MScrolledContainer::getSize()" << std::endl;
  }*/


  // Private methods

  QWidget* MScrolledContainer::getHandle() {
    // Return a pointer to the widget that should be used for putting other widgets on
    QScrollView* sv = dynamic_cast<QScrollView*>(m_Handle);
    assert(sv != 0l);
    return sv->viewport();
  }


}

