#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MCheckbox.h>
namespace Aztec {

  static JSBool js_MCheckbox_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_getMax(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setMax(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_getMin(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setMin(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_CheckBoxAddListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSClass js_MCheckbox_class = {
    "MCheckbox", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMCheckbox_methods[] = {
    // Object/mesh creation
    {"getValue",  js_getValue,          0},
    {"setValue",  js_setValue,          1},
    {"addListener",    js_CheckBoxAddListener,    1},
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMCheckboxClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MCheckbox_class, js_MCheckbox_constructor, 0,
      NULL, aztecMCheckbox_methods, 0, 0);
    
    return cl;
    
  }
  
  static JSBool js_MCheckbox_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {

    // we only accept 0 or 1 argument
    if  (argc > 1) {
      return JS_FALSE;
    }

    int value = false;
    long max = 100;
    long pos = 0;

    if (argc >= 1) {
      JS_ValueToBoolean(cx, argv[0], &value);
    }

    MCheckboxPtr newComponent = new MCheckbox(value != 0);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      return JS_FALSE;
    }

    MCheckboxPtr slider = getGuiObject<MCheckbox>(cx, obj);
    
    if (slider != NULL) {
      *rval = BOOLEAN_TO_JSVAL( slider->getValue() );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  static JSBool js_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    MCheckboxPtr slider = getGuiObject<MCheckbox>(cx, obj);
    
    if (slider != NULL) {
      int value = 0;
      JS_ValueToBoolean(cx, argv[0], &value);
      slider->setValue( value != 0 );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }
    


  class JS_CheckboxChangeListener : public MCheckbox::ChangeListener {
  public:
    JS_CheckboxChangeListener(JSContext *cx, JSObject *obj, JSFunction *function, uintN argc, jsval *argv) {
      this->cx = cx;
      this->func = function;
      this->object = obj;
      for (uintN i = 0; i < argc; ++i) {
        args.push_back(argv[i]);
      }
    }

    void onChange(const MCheckboxPtr &checkbox) {

      jsval rval;

      jsval *argv = new jsval[args.size()];

      for (unsigned i = 0; i < args.size(); ++i) {
        argv[i] = args[i];
      }

      JS_CallFunction(cx, object, func, args.size(), argv, &rval);

      delete[] argv;
    }

    JSContext *cx;
    JSFunction *func;
    JSObject *object;
    std::vector<jsval> args;
  };

  static JSBool js_CheckBoxAddListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc < 1) {
      return JS_FALSE;
    }

    MCheckboxPtr checkbox = getGuiObject<MCheckbox>(cx, obj);
    JSFunction *func = JS_ValueToFunction(cx, argv[0]);
    
    if (func != NULL && checkbox != NULL) {

      checkbox->addListener(new JS_CheckboxChangeListener(cx, obj, func, argc - 1, argv + 1));

      return JS_TRUE;
    } else {
      return JS_FALSE;
    }


    return JS_FALSE;
  }


}
