#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MComboBox.h>
namespace Aztec {

  static JSBool js_MComboBox_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval);
  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval);
  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value);
  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value);
  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_addListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_method_addItem(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  static JSBool js_prop_getIndex(JSContext *cx, JSObject *obj, jsval id, jsval *rval);
  static JSBool js_getIndex(JSContext *cx, JSObject *obj, jsval *rval);
  static JSBool js_prop_setIndex(JSContext *cx, JSObject *obj, jsval id, jsval *js_value);
  static JSBool js_setIndex(JSContext *cx, JSObject *obj, jsval js_value);


  JSClass js_MComboBox_class = {
    "MComboBox", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMComboBox_methods[] = {
    // Object/mesh creation
    {"getValue",  js_method_getValue,          0},
    {"setValue",  js_method_setValue,          1},
    {"add",  js_method_addItem,          0},
    {"addListener",        js_addListener,        3},
    {NULL,                NULL,                   0} 
  };
  
  static JSPropertySpec js_MComboBox_props[] = {
    {"value", 0, JSPROP_ENUMERATE, js_prop_getValue, js_prop_setValue}, 
    {"index", 1, JSPROP_ENUMERATE, js_prop_getIndex, js_prop_setIndex}, 
    {0, 0, 0, 0}
  };

  JSObject* initMComboBoxClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MComboBox_class, js_MComboBox_constructor, 0,
      NULL, aztecMComboBox_methods, 0, 0);

    JS_DefineProperties(cx, cl, js_MComboBox_props);
    
    return cl;
    
  }
  
  static JSBool js_MComboBox_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {

    // we only accept 0, 1, or 2 arguments
    if (argc > 2) {
      return JS_FALSE;
    }

    std::string value;
    int32 width = -1;

    if (argc >= 1) {
      value = JS_GetStringBytes(JS_ValueToString(cx, argv[0]));
    }
    if (argc >= 2) {
      JS_ValueToInt32(cx, argv[1], &width);
    }

    MComboBoxPtr newComponent;
    
    if (width != -1) {
      // TODO: allow the MComboBox to have a width
      newComponent = new MComboBox();
    } else {
      newComponent = new MComboBox();
    }
    newComponent->setValue(value);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      JS_ReportError(cx, "getValue() requires one argument.");
      return JS_FALSE;
    }

    return js_getValue(cx, obj, rval);
  }

  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    return js_getValue(cx, obj, rval);
  }

  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval) {
    MComboBoxPtr textField = getGuiObject<MComboBox>(cx, obj);
    
    if (textField != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, textField->getValue().c_str()) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      JS_ReportError(cx, "setValue() requires one argument.");
      return JS_FALSE;
    }
    
    return js_setValue(cx, obj, argv[0]);
  }

  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    return js_setValue(cx, obj, *js_value);
  }

  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value)
  {
    MComboBoxPtr textField = getGuiObject<MComboBox>(cx, obj);
    
    if (textField != NULL) {
      textField->setValue( JS_GetStringBytes( JS_ValueToString(cx, js_value) ) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }

  static JSBool js_prop_getIndex(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    return js_getIndex(cx, obj, rval);
  }

  static JSBool js_getIndex(JSContext *cx, JSObject *obj, jsval *rval) {
    MComboBoxPtr textField = getGuiObject<MComboBox>(cx, obj);
    
    if (textField != NULL) {
      *rval = INT_TO_JSVAL( textField->getSelectedIndex() );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_prop_setIndex(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    return js_setIndex(cx, obj, *js_value);
  }

  static JSBool js_setIndex(JSContext *cx, JSObject *obj, jsval js_value)
  {
    MComboBoxPtr textField = getGuiObject<MComboBox>(cx, obj);
    
    int32 value = -1;
    if (!JS_ValueToInt32(cx, js_value, &value)) {
      return JS_FALSE;
    }

    if (textField != NULL) {
      textField->setSelectedIndex( value );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }


  static JSBool js_method_addItem(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      JS_ReportError(cx, "setValue() requires one argument.");
      return JS_FALSE;
    }
    
    MComboBoxPtr textField = getGuiObject<MComboBox>(cx, obj);
    
    if (textField != NULL) {
      textField->addItem( JS_GetStringBytes( JS_ValueToString(cx, argv[0]) ) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }

  
  class JSComboBoxListener : public MComboBox::ComboBoxListener {
  public:
    JSComboBoxListener(JSContext *cx, JSObject *obj, JSFunction *function, uintN argc, jsval *argv) {
      this->cx = cx;
      this->func = function;
      this->object = obj;
      for (uintN i = 0; i < argc; ++i) {
        args.push_back(argv[i]);
      }
    }

    void onListen(const MComboBoxPtr &field) {

      jsval rval;

      jsval *argv = new jsval[args.size() + 1];

      argv[0] = OBJECT_TO_JSVAL(object);
      for (int i = 0; i < args.size(); ++i) {
        argv[i+1] = args[i];
      }

      JS_CallFunction(cx, object, func, args.size() + 1, argv, &rval);

      delete[] argv;
    }

    JSContext *cx;
    JSFunction *func;
    JSObject *object;
    std::vector<jsval> args;
  };

  static JSBool js_addListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc < 1) {
      return JS_FALSE;
    }

    MComboBoxPtr component = getGuiObject<MComboBox>(cx, obj);
    JSFunction *func = JS_ValueToFunction(cx, argv[0]);
    
    if (func != NULL && component != NULL) {

      component->addListener(new JSComboBoxListener(cx, obj, func, argc - 1, argv + 1));

      return JS_TRUE;
    } else {
      return JS_FALSE;
    }

    return JS_FALSE;
  }

}
