#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MFlowLayout.h>

namespace Aztec {
  JSBool js_MFlowLayout_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    // we only accept 0, or 2 arguments to a constructor.
    // with zero, args, we do a default border width. 2 args we have a border width and height.

    int gapX = 2, gapY = 2;
    int numComponents = -1;

    if (argc != 0) {
      if (argc >= 1 && JSVAL_IS_INT(argv[0])) {
        gapX = JSVAL_TO_INT(argv[0]);
      }
      if (argc >= 2 && JSVAL_IS_INT(argv[1])) {
        gapY = JSVAL_TO_INT(argv[1]);
      }
      if (argc >= 3 && JSVAL_IS_INT(argv[2])) {
        numComponents = JSVAL_TO_INT(argv[2]);
      }
    }

    MLayoutManagerPtr layout;
    
    layout = new MFlowLayout(gapX, gapY, numComponents);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(layout));
  }
  
  JSClass js_MFlowLayout_class = {
    "MFlowLayout", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  
  static JSFunctionSpec aztecMFlowLayout_methods[] = {
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMFlowLayoutClass(JSContext *cx) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
      &js_MFlowLayout_class, js_MFlowLayout_constructor, 0,
      NULL, aztecMFlowLayout_methods, 0, 0);
    

    return cl;
  }


}
