#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MSize2D.h>

namespace Aztec {

  static MSize2D *js_getSize2D(JSContext *cx, JSObject *obj) {
    return reinterpret_cast<MSize2D*>(JS_GetPrivate(cx, obj));
  }

  JSBool js_MSize2D_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    return JS_SetPrivate(cx, obj, NULL);
  }
  
  void js_MSize2D_finalize(JSContext *cx, JSObject *obj) {
    MSize2D *size = js_getSize2D(cx, obj);

    if (size != NULL) {
      delete size;
    }

    JS_SetPrivate(cx, obj, NULL);

  }
  
  static const int X1 = 0;
  static const int Y1 = 1;
  static const int X2 = 2;
  static const int Y2 = 3;
  static const int LEFT = 4;
  static const int TOP = 5;
  static const int RIGHT = 6;
  static const int BOTTOM = 7;
  static const int WIDTH = 8;
  static const int HEIGHT = 9;


  JSBool js_getProperty(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MSize2D *size = js_getSize2D(cx, obj);

    if (size != NULL) {

      if (JSVAL_IS_INT(id)) {
        switch (JSVAL_TO_INT(id)) {
        case X1:
        case LEFT: 
          *rval = INT_TO_JSVAL(size->getLeft());
          return JS_TRUE;
        case Y1:
        case TOP:
          *rval = INT_TO_JSVAL(size->getTop());
          return JS_TRUE;
        case X2:
        case RIGHT:
          *rval = INT_TO_JSVAL(size->getRight());
          return JS_TRUE;
        case Y2:
        case BOTTOM:
          *rval = INT_TO_JSVAL(size->getBottom());
          return JS_TRUE;
        case WIDTH:
          *rval = INT_TO_JSVAL(size->getWidth());
          return JS_TRUE;
        case HEIGHT:
          *rval = INT_TO_JSVAL(size->getHeight());
          return JS_TRUE;
        }
      }

    }
    
    return JS_FALSE;
  }

  JSBool js_setProperty(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    MSize2D *size = js_getSize2D(cx, obj);

    if (size != NULL) {

      int32 value = -1;

      if (!JS_ValueToInt32(cx, *js_value, &value)) return JS_FALSE;

      if (JSVAL_IS_INT(id)) {
        switch (JSVAL_TO_INT(id)) {
        case X1:
        case LEFT:
          size->x1 = value;
          return JS_TRUE;
        case Y1:
        case TOP:
          size->y1 = value;
          return JS_TRUE;
        case X2:
        case RIGHT:
          size->x2 = value;
          return JS_TRUE;
        case Y2:
        case BOTTOM:
          size->y2 = value;
          return JS_TRUE;
        case WIDTH:
          size->setWidth(value);
          return JS_TRUE;
        case HEIGHT:
          size->setHeight(value);
          return JS_TRUE;
        }
      }

    }
    
    return JS_FALSE;
  }


  
  JSClass js_MSize2D_class = {
    "MSize2D", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   js_MSize2D_finalize
  };
  
  JSFunctionSpec js_MSize2D_methods[] = {
    {NULL,                NULL,                   0} 
  };

  JSPropertySpec js_MSize2D_props[] = {
    {"x1", X1, JSPROP_ENUMERATE, js_getProperty, js_setProperty }, 
    {"y1", Y1, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {"x2", X2, JSPROP_ENUMERATE, js_getProperty, js_setProperty }, 
    {"y2", Y2, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {"left", LEFT, JSPROP_ENUMERATE, js_getProperty, js_setProperty }, 
    {"top", TOP, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {"right", RIGHT, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {"bottom", BOTTOM, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {"width", WIDTH, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {"height", HEIGHT, JSPROP_ENUMERATE, js_getProperty, js_setProperty },
    {0, 0, 0, 0}
  };
  

  JSObject* initMSize2DClass(JSContext *cx) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
      &js_MSize2D_class, js_MSize2D_constructor, 0,
      NULL, js_MSize2D_methods, 0, 0);

    return cl;
  }

  JSObject* createMSize2D(JSContext *cx, JSObject *parent, const MSize2D &event) {
    JSObject *object = JS_NewObject(cx, &js_MSize2D_class, NULL, parent);
    JS_DefineProperties(cx, object, js_MSize2D_props);
    JS_SetPrivate(cx, object, new MSize2D(event)) ;
    return object;
  }

}
