#include <AztecGUICommonPCH.h>

#include <gui/win32/MImageComponentImpl.h>
#include <gui/MApplication.h>

namespace Aztec {

  MImageComponent::MImageComponent()
  {
    imageChanged = false;
  }

  MImageComponent::~MImageComponent() {
  }

  bool MImageComponent::createImpl() {
    MApp *app;
    HWND parentHWND = NULL;

    // Get the parent windows hwnd, so we can create our button.
    if (m_Parent != NULL) {
      parentHWND = m_Parent->getHWnd();
    }

    app = MApp::getInstance();

    // create the actual windows control.
    DWORD bitmapflag = image != NULL ? BS_BITMAP : 0;

    m_hWnd = ::CreateWindow((LPCTSTR)app->getWindowClass("imagecomponent"), "", WS_CHILD,
                            0, 10, 0, 10, parentHWND, NULL, app->getHInstance(), NULL);

    // if it succeeded, update everything.
    if (m_hWnd != 0) {
      // Register this control and hwnd with the application.
      app->registerComponent(m_hWnd, this);

      // Change the font of the button.
      ::SendMessage(m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      if (image != NULL) {
        setImage(image);
      }


      // Call the create event handler.
      onCreate();

      // show the button, and update the screen.
      setVisible(true);
      ::UpdateWindow(m_hWnd);

      return true;
    }

    return false;
  }


  void MImageComponent::setImage(const Aztec::MImagePtr &i) {
    image = i;
    imageChanged = true;


    if (m_hWnd != NULL) {
      // Make sure we get repainted at some point soon.
      ::InvalidateRect(m_hWnd, NULL, FALSE);
      ::UpdateWindow(m_hWnd);
      getParent()->doLayout();
    }
  }

  MImagePtr MImageComponent::getImage() {
    return image;
  }


  MSize2D MImageComponent::getMinimumSize() {
    if (image != NULL) {
      return MSize2D(image->getWidth(), image->getHeight());
    } else {
      return MComponent::getMinimumSize();
    }
  }

  bool MImageComponent::isMinimumSizeSet() {
    return true;
  }

  static void FillRect(HDC dc, const MRect2D &rect, HBRUSH brush) {
    if (rect.getWidth() > 0 && rect.getHeight() > 0) {
      RECT r;
      r.left = rect.getLeft();
      r.top = rect.getTop();
      r.right = rect.getRight();
      r.bottom = rect.getBottom();

      ::FillRect(dc, &r, brush);
    }
  }

  bool MImageComponent::onPaint() {
    if (image == NULL) {
      return false;
    }

    if (imageChanged) {
      bitmap.setFromImage(image, paintDC);
      imageChanged = false;
    }

    MSize2D clientSize = getClientSize();

    // if our client size is bigger than our image, centre our image.

    MPoint2D drawPos;
    MRect2D top, left, right, bottom;

    if (clientSize.getWidth() > image->getWidth()) {
      drawPos.x = (clientSize.getWidth() - image->getWidth()) / 2;

      left.x1 = 0;
      left.y1 = 0;
      left.x2 = drawPos.x;
      left.y2 = clientSize.getHeight();

      right.x1 = drawPos.x + image->getWidth();
      right.y1 = 0;
      right.x2 = clientSize.getWidth();
      right.y2 = clientSize.getHeight();
    }

    if (clientSize.getHeight() > image->getHeight()) {
      drawPos.y = (clientSize.getHeight() - image->getHeight()) / 2;

      top.x1 = drawPos.x;
      top.y1 = 0;
      top.x2 = drawPos.x + image->getWidth();
      top.y2 = drawPos.y;

      bottom.x1 = drawPos.x;
      bottom.y1 = drawPos.y + image->getHeight();
      bottom.x2 = drawPos.x + image->getWidth();
      bottom.y2 = clientSize.getHeight();
    }

    FillRect(paintDC, left, (HBRUSH)::GetStockObject(GRAY_BRUSH));
    FillRect(paintDC, top, (HBRUSH)::GetStockObject(GRAY_BRUSH));
    FillRect(paintDC, right, (HBRUSH)::GetStockObject(GRAY_BRUSH));
    FillRect(paintDC, bottom, (HBRUSH)::GetStockObject(GRAY_BRUSH));

    bitmap.Draw(paintDC, drawPos.x, drawPos.y, 0, 0, bitmap.m_Width, bitmap.m_Height);



    return true;
  }


}

