#include <AztecGUICommonPCH.h>

#include <gui/win32/MWindowImpl.h>
#include <gui/win32/MAppImpl.h>
#include <gui/win32/MMenuImpl.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MWindow::MWindow(const std::string &title) {
    setTitle(title);
//    createImpl();
  }

  MWindow::~MWindow() {
  }

  bool MWindow::createImpl() {
    return doCreateImpl(WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, 0);
  }

  bool MWindow::create() {
    return createImpl();
  }

  void MWindow::setTitle(const std::string &title) {
    m_Title = title;
    if (m_hWnd != NULL) {
      ::SetWindowText(m_hWnd, m_Title.c_str());
    }
  }

  std::string MWindow::getTitle() {
    return m_Title;
  }

  void MWindow::setMenu(MMenuPtr menu) {
    if (menu == NULL) {
      m_Menu = NULL;
      ::SetMenu(m_hWnd, NULL);
    } else {
      m_Menu = menu;
      ::SetMenu(m_hWnd, menu->getHMenu(false));
    }

    // after setting a menu, we have to do a layout, because the client area may have changed.
    doLayout();
  }

  MMenuPtr MWindow::getMenu() {
    return m_Menu;
  }

  void MWindow::close() {
    ::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
  }

  bool MWindow::onClose() {
    return false;
  }

  MSize2D MWindow::getMinimumSize() {
    MSize2D size = MContainer::getMinimumSize();

    // adjus this minimum size based on the current window borders and what not.
    RECT rect = {size.x1, size.y1, size.x2, size.y2 };
    AdjustWindowRect(&rect, ::GetWindowLong(m_hWnd, GWL_STYLE), ::GetMenu(m_hWnd) != NULL);

    // otherwise return a tiny rectangle.
    return MSize2D(rect.left, rect.top, rect.right, rect.bottom);
  }

  MSize2D MWindow::getPreferredSize() {
    MSize2D size = MContainer::getPreferredSize();

    // adjus this minimum size based on the current window borders and what not.
    RECT rect = {size.x1, size.y1, size.x2, size.y2 };
    AdjustWindowRect(&rect, ::GetWindowLong(m_hWnd, GWL_STYLE), ::GetMenu(m_hWnd) != NULL);

    // otherwise return a tiny rectangle.
    return MSize2D(rect.left, rect.top, rect.right, rect.bottom);
  }

  bool MWindow::doCreateImpl(DWORD style, DWORD styleExtended, const MWindowPtr &parent) {
    // only create the window once.
    if (m_hWnd != NULL) {
      return true;
    }

    MApp *app;

    app = MApp::getInstance();

    m_hWnd = ::CreateWindowEx(styleExtended, (LPCTSTR)app->getWindowClass("Window"), m_Title.c_str(), style, 
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, parent != NULL ? parent->m_hWnd : NULL, NULL, app->getHInstance(), NULL); 

    if (m_hWnd != 0) {
      app->registerComponent(m_hWnd, this);

      // update our menu
//      setMenu(m_Menu);

      // set our font to be all purty
      ::SendMessage(m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      onCreate();

      return true;
    }

    return false;
  }


}
