#ifndef Aztec_Camera_Header
#define Aztec_Camera_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MCamera;
  typedef MRefCountedPtr<MCamera> MCameraPtr;

}

#include "MShapeObject.h"
#include "MMesh.h"
#include "MMath.h"

namespace Aztec {

  //----------------------------------------------------------------------------------------
  //  MCamera
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MCamera : public MShapeObject {
  public:
    MCamera();
    ~MCamera();

    // MShapeObject methods
    bool drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
    
    // MBaseObject methods
    MStr getClassName() {return MStr("MCamera");};
    MStr getParentClassName() {return MStr("MShapeObject");};
    MBaseObjectPtr createNew();

  private:
    void generateCameraMesh();

    MMeshPtr cameraMesh;
  };

}
#endif
