#ifndef Aztec_MCompleteTranslator_Header
#define Aztec_MCompleteTranslator_Header

#include <ModelGeneric.h>
#include <translator/MSceneTranslator.h>

//----------------------------------------------------------------------------------------
//  MCompleteTranslator
//----------------------------------------------------------------------------------------
// This class is aimed at providing a consitent emthod of reading and writing complete
// scenes that is a MSceneTranslator descendant. It relies almost entirely on each classes 
// Read and Write file realted memebers.

namespace Aztec {

  class MGENEXPORT MCompleteTranslator : public MSceneTranslator {
  public:
    MCompleteTranslator();
    virtual ~MCompleteTranslator();
    
    // Class related
    virtual MStr getClassName();
    virtual MStr getParentClassName();

    // MTranslator methods
    virtual std::string getFilter();
    virtual std::string getFilterDescription();
    
    virtual bool canImport();
    virtual bool canExport();
    virtual bool canImportFile(MStr Filename);
    
    // MSceneTranslator methods
    virtual bool importFile(MStr Filename, MScenePtr Scene);
    virtual bool exportFile(MStr Filename, MScenePtr Scene);

    // MTranslator methods
    MTranslatorPtr createNew() const;
  };
  
  
}

#endif
