#ifndef MIMAGES_H
#define MIMAGES_H

#include "GL/gl.h"

#include "ModelGeneric.h"

#include "MBaseObject.h"

#define RAW_STORE_RGB      0x0001
#define RAW_STORE_ALPHA    0x0002

namespace Aztec {

  class MImage;

  typedef MRefCountedPtr<MImage> MImagePtr;

  enum MImageSizeOp {miDiscard, miStretch, miCrop};

  enum MImageFormat { miIndexed, miRGB, miGrey };

  //----------------------------------------------------------------------------------------
  //  MImage
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MImage : public MBaseObject {
  public:
    MImageFormat m_FType;
    int m_Stride, m_BitsPerPixel, m_ChannelsPerPixel;
    int m_MapLen, m_BitsPerMapPixel, m_ChannelsPerMapPixel;
    BYTE *m_ColorMap;
    
    MStr     m_Filename;
    UINT     m_TextureName;
    MImagePtr m_GLImage;
    
    bool     m_RequireAlpha, m_MakeGLImage;
    
    MImage();
    ~MImage();
    
    // Image manipualtion
    int getWidth();
    int getHeight();
    void setSize(int Width, int Height, MImageSizeOp Op = miDiscard);
    void setSizeGLFriendly(bool RoundDown = false, int Max = 256, MImageSizeOp Op = miStretch);
    void clear(BYTE r = 0, BYTE g = 0, BYTE b = 0, BYTE a = 0);
    
    BYTE* getPixelData();
    BYTE* getAlphaData();

    // Conversion Ops
    void setFrom8Bit(BYTE *SrcPixels, BYTE **SrcPal);
    
    // GLRelated commands
    
    // Returns the MImage object that is useable for OpenGL Textures.
    MImagePtr getGLImage();
    // Returns the OpenGL Name that represents the texture.
    UINT getGLImageName();
    // Creates a MImage object that is useable for GL Textues and names the texture
    void createGLImage(bool DontCreateIfExists  = true);
    // Deletes the MImage objects used for GL Textures and deletes the name for the texture.
    void deleteGLImage();
    // Sets the Target texture as the gl texture
    void setGLImageAsCurrent(GLenum Target);
    
    // Operators
    MImage& operator=(const MImage &Src);
    
    // Misc operations
    void flipVertical();

    // MBaseObject methods
    virtual MStr getClassName() {return MStr("MImage");};
    virtual MStr getParentClassName() {return MStr("MBaseObject");};
    virtual MBaseObjectPtr createNew();
    
  private:
    int m_Width;
    int m_Height;
    BYTE *m_Pixels;
    BYTE *m_Alpha;
    
  };

}


#endif
