#ifndef MLineShapeObject_Header
#define MLineShapeObject_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MLineShape;

  typedef MRefCountedPtr<MLineShape> MLineShapePtr;
}

#include "MShapeObject.h"
#include "MLineMesh.h"

namespace Aztec {

  /**
   * The MLineShape object represents a shape that contains a series of 
   * unconnected line segments, which are in turn a series of connected 
   * points. Points can be connected by straight lines, splines or various 
   * other curves.
   */
  class MGENEXPORT MLineShape : public MShapeObject {
  public:
    MLineShape(MLineMeshPtr input = NULL);
    ~MLineShape();
    
    /**
     * This gets the Mesh that is the input for this shape.
     *
     * @return The input Mesh for this Shape.
     */
    MLineMeshPtr getLineMesh();

    /**
     * This sets the input mesh for this shape.
     *
     * @param mesh The new mesh to use as the input.
     */
    void setLineMesh(MLineMeshPtr mesh);

    // MShapeObject methods
    bool drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
    MComponentisedObjectPtr getComponentObject();
    MEditableComponentisedObjectPtr getEditableComponentObject();
    
    // MBaseObject methods
    virtual MStr getClassName() {return MStr("MLineShape");};
    virtual MStr getParentClassName() {return MStr("MShapeObject");};
    virtual MBaseObjectPtr createNew();

  protected:
    MObjectParameterPtr m_InMeshParam;

  };
  
  
}

#endif
