#ifndef MNamedObject_Header
#define MNamedObject_Header

extern "C" {
#define XP_PC
#include "jsapi.h"
}

#include "ModelGeneric.h"
#include "MScriptingSupport.h"

namespace Aztec {
  
  class MNamedObject;
  
  typedef MRefCountedPtr<MNamedObject> MNamedObjectPtr;

  class MParameterObject;
  class MParameterObjectList;
  typedef MRefCountedPtr<MParameterObject> MParameterObjectPtr;
  typedef MRefCountedPtr<MParameterObjectList> MParameterObjectListPtr;


}

#include "MDAGNode.h"
#include "MMath.h"

namespace Aztec {
  
  /**
   * This is the common base object used through out the model 
   * library. It contains lots of versatile important information 
   * about an object. Each BaseObject contains A 32 bit Flag, a list
   * of named prameters, and a 
   */
  class MGENEXPORT MNamedObject : public MDAGNode {
  public:
    // Construction/Destruction
    MNamedObject();
    virtual ~MNamedObject();
    
    // Class related
    virtual MStr getClassName() {return MStr("MNamedObject");};
    virtual MStr getParentClassName() {return MStr("MBaseObject");};
    virtual MBaseObjectPtr createNew();
    virtual void setFrom(MBaseObjectPtr SrcObj);
    
    // Scene Names and things like that
    void setName(LPCTSTR Name);
    MStr getName();
    
    // Update the object suing any input nodes or whatever. Used when updating obhects that are dependant on others.
    int addDependant(MBaseObjectPtr Obj);
    int removeDependant(MBaseObjectPtr Obj);
    MBaseObjectPtr getDependantList();
    
    void setObjectType(AztecFlags Type);
    
    // Parameter Setting and Getting
    int addParameter(MParameterObjectPtr ParamObj);
    int replaceParamObject(const MStr &Name, MParameterObjectPtr Param);
    MParameterObjectPtr findParameter(const MStr ParamName);
    MParameterObjectListPtr getParamList();
    
    int setParamByName(const MStr &ParamName, const MStr &Value, bool SetKey = false);
    int getParamByName(const MStr &ParamName, MStr &Value);
    MStr getParamByName(const MStr &ParamName);
    MVector3 getParamVec(const MStr &ParamName);
    float getParamFloat(const MStr &ParamName);
    int getParamInt(const MStr &ParamName);

	// Scripting support
	virtual MScriptingSupportPtr getScriptObject();

  protected:
    MBaseObjectPtr m_DependantList;
    
    MParameterObjectListPtr m_ParamList;
    
  };
  
}


#include "MParameterObject.h"
#include "MParameterObjectList.h"

#include "ModelTypes.h"
#include "MMath.h"


#endif
