#ifndef MShapeObject_Header
#define MShapeObject_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MShapeObject;
  typedef MRefCountedPtr<MShapeObject> MShapeObjectPtr;

  class MSceneObject;
  typedef MRefCountedPtr<MSceneObject> MSceneObjectPtr;

}

#include <MMesh.h>
#include <MComponentisedObject.h>
#include <MEditableComponentisedObject.h>
#include <params/MObjectParameter.h>

namespace Aztec {

  //--------------
  // MShapeObect
  //--------------
  class MGENEXPORT MShapeObject : public MNamedObject {
  public:
    MShapeObject();
    virtual ~MShapeObject();
    
    /**
     * This converts this shape object into a mesh object.
     */
    virtual MMeshPtr convertToMesh();

    /**
     * This allows a shape to be drawn in a custom way.
     */
    virtual bool drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
    
    /**
     * This gets the component object for this shape. The component object
     * is the interface that the system can access an objects components,
     * such as points, edges and faces, to draw and query them.
     * Each implementing shape should override this if it needs components
     * to be accessed.
     */
    virtual MComponentisedObjectPtr getComponentObject();

    /**
     * This gets the editable component object for this shape. The editable 
     * component object allows editing of components of an object, such as
     * points, edges, faces and things like that.
     */
    virtual MEditableComponentisedObjectPtr getEditableComponentObject();

    // Class related
    virtual MStr getClassName() {return MStr("MShapeObject");};
    virtual MStr getParentClassName() {return MStr("MNamedObject");};
    virtual MBaseObjectPtr createNew();
    
  };
  
  
}

#endif
