#ifndef MODELTYPES_H
#define MODELTYPES_H

#include "ModelGeneric.h"
#include "MBasicTypes.h"

#include <MMath.h>

namespace Aztec {
  
	// Data type used for bit flags
	typedef unsigned long AztecFlags;

  //enum MComponentMode {cmObject, cmPoint, cmFace, cmEdge };
  typedef enum { glNone, glNearest, glLinear } GLTextureMode ; 
  typedef enum { glWireframe, glFlat, glSmooth } GLShadingMode;
  typedef enum { glUnlit, glLit, glHeadlight } GLLightingMode;
  enum MSelectMethod {smNone = 0x00, smSelect = 0x01, smDeselect = 0x02, smSelectBox = 0x11, smDeselectBox = 0x12, smSelecting = 0x0F, smBoxing = 0xF0};
  
  
  //----------------------------------------------------------------------------------------
  //  MRGBAByte
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MRGBAByte
  {
  public:
    BYTE  r,g,b,a;
    
    void set(BYTE nr, BYTE ng, BYTE nb, BYTE na);
  };

  /**
   * The MRGBAFloat class is a 4 component colour using floats for storage.
   * When there are some extra methods that it needs, this will be changed
   * to a class derived from MVector4.
   */
  typedef MVector4 MRGBAFloat;
  
  //----------------------------------------------------------------------------------------
  //  MFlagObject
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MFlagObject
  {
  protected:
    AztecFlags       m_Flags;
    
  public:
    MFlagObject() { m_Flags = 0;}
    MFlagObject(AztecFlags flgs) { m_Flags = flgs;}
    
    void setFlag(AztecFlags Flag) {m_Flags |= Flag;}
    bool isFlagged(AztecFlags Flag) const {return ((m_Flags&Flag)>0);}
    void unsetFlag(AztecFlags Flag) {m_Flags &= ~Flag;}
    void toggleFlag(AztecFlags Flag) {m_Flags ^= Flag;}
    AztecFlags getFlags() const {return m_Flags;}
    void assignFlags(AztecFlags Flag) {m_Flags = Flag;}
  };
  
  
  //----------------------------------------------------------------------------------------
  //  MRGBAFloat
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MSceneViewFlags
  {
  public:
    GLShadingMode m_ShadingMode;
    GLTextureMode m_TexturingMode;
    GLLightingMode m_LightingMode;
    AztecFlags m_ComponentMode;
    AztecFlags m_CullBackface;
    int m_TextureMode;
    MSelectMethod m_SelectMethod;
    
    UINT              *m_SelectBuf;
    
    MRGBAFloat        m_WireColor, m_FlatColor;
    bool              m_DrawWire;
    
    bool m_GLLighting;

    bool m_Playing;
  };
  
}


#endif
